/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search.service;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.StringUtils;
import org.egov.search.domain.Filter;
import org.egov.search.domain.Filters;
import org.egov.search.domain.Page;
import org.egov.search.domain.SearchResult;
import org.egov.search.domain.Sort;
import org.egov.search.service.ElasticSearchClient;
import org.elasticsearch.index.query.BoolFilterBuilder;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;
import org.elasticsearch.index.query.MatchAllQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SearchService {
    private ElasticSearchClient elasticSearchClient;

    @Autowired
    public SearchService(ElasticSearchClient elasticSearchClient) {
        this.elasticSearchClient = elasticSearchClient;
    }

    public SearchResult search(List<String> indices, List<String> types, String searchText, Filters filters, Sort sort, Page page) {
        BoolFilterBuilder filterBuilder = this.constructBoolFilter(filters);
        MatchAllQueryBuilder queryBuilder = QueryBuilders.matchAllQuery();
        if (StringUtils.isNotEmpty((String)searchText)) {
            queryBuilder = QueryBuilders.queryString((String)searchText).lenient(Boolean.valueOf(true)).field("searchable.*").field("common.*").field("clauses.*");
        }
        Object rootQueryBuilder = filters.isNotEmpty() ? QueryBuilders.filteredQuery((QueryBuilder)queryBuilder, (FilterBuilder)filterBuilder) : queryBuilder;
        String response = this.elasticSearchClient.search(indices, types, (QueryBuilder)rootQueryBuilder, sort, page);
        return SearchResult.from(response);
    }

    private BoolFilterBuilder constructBoolFilter(Filters filters) {
        List<FilterBuilder> mustFilters = this.queryBuilders(filters.getAndFilters());
        List<FilterBuilder> shouldFilters = this.queryBuilders(filters.getOrFilters());
        List<FilterBuilder> notFilters = this.queryBuilders(filters.getNotInFilters());
        BoolFilterBuilder boolFilterBuilder = FilterBuilders.boolFilter();
        mustFilters.stream().forEach(arg_0 -> ((BoolFilterBuilder)boolFilterBuilder).must(arg_0));
        shouldFilters.stream().forEach(arg_0 -> ((BoolFilterBuilder)boolFilterBuilder).should(arg_0));
        notFilters.stream().forEach(arg_0 -> ((BoolFilterBuilder)boolFilterBuilder).mustNot(arg_0));
        return boolFilterBuilder;
    }

    private List<FilterBuilder> queryBuilders(List<Filter> filters) {
        return filters.stream().map(Filter::filterBuilder).collect(Collectors.toList());
    }
}

