/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search.domain;

import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.builder.EqualsBuilder;
import org.apache.commons.lang.builder.HashCodeBuilder;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.egov.search.domain.NoOpFilter;
import org.egov.search.domain.QueryStringFilter;
import org.egov.search.domain.RangeFilter;
import org.egov.search.domain.TermsStringFilter;
import org.elasticsearch.index.query.FilterBuilder;
import org.elasticsearch.index.query.FilterBuilders;

public abstract class Filter {
    protected String fieldName;

    protected Filter(String fieldName) {
        this.fieldName = fieldName;
    }

    public String field() {
        return this.fieldName;
    }

    public FilterBuilder filterBuilder() {
        return FilterBuilders.matchAllFilter();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this);
    }

    public boolean equals(Object obj) {
        return EqualsBuilder.reflectionEquals((Object)this, (Object)obj);
    }

    public int hashCode() {
        return HashCodeBuilder.reflectionHashCode((Object)this);
    }

    public static Filter queryStringFilter(String fieldName, String value) {
        if (StringUtils.isEmpty((String)value) || StringUtils.isEmpty((String)fieldName)) {
            return new NoOpFilter();
        }
        return new QueryStringFilter(fieldName, value);
    }

    public static Filter rangeFilter(String fieldName, String from, String to) {
        if (StringUtils.isEmpty((String)from) && StringUtils.isEmpty((String)to) || StringUtils.isEmpty((String)fieldName)) {
            return new NoOpFilter();
        }
        return new RangeFilter(fieldName, from, to);
    }

    public static Filter rangeFilterFrom(String fieldName, String from) {
        if (StringUtils.isEmpty((String)fieldName) || StringUtils.isEmpty((String)from)) {
            return new NoOpFilter();
        }
        return Filter.rangeFilter(fieldName, from, null);
    }

    public static Filter rangeFilterTo(String fieldName, String to) {
        if (StringUtils.isEmpty((String)fieldName) || StringUtils.isEmpty((String)to)) {
            return new NoOpFilter();
        }
        return Filter.rangeFilter(fieldName, null, to);
    }

    public static Filter termsStringFilter(String fieldName, String ... values) {
        ArrayList<String> valuesList = new ArrayList<String>(0);
        for (String value : values) {
            if (value == null) continue;
            valuesList.add(value);
        }
        if (StringUtils.isEmpty((String)fieldName) || valuesList.size() == 0) {
            return new NoOpFilter();
        }
        return new TermsStringFilter(fieldName, (String[])valuesList.stream().toArray(String[]::new));
    }
}

