/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search.config;

import java.util.Properties;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class SearchConfig {
    private Properties properties;

    @Autowired
    public SearchConfig(@Qualifier(value="egovSearchProperties") Properties properties) {
        this.properties = properties;
    }

    public String[] searchHosts() {
        return this.properties.getProperty("search.hosts").split(",");
    }

    public int searchPort() {
        return Integer.parseInt(this.properties.getProperty("search.port"));
    }

    public String searchClusterName() {
        return this.properties.getProperty("search.clusterName");
    }

    public int searchShardsFor(String indexName) {
        return Integer.parseInt(this.properties.getProperty(String.format("search.%s.shards", indexName)));
    }

    public int searchReplicasFor(String indexName) {
        return Integer.parseInt(this.properties.getProperty(String.format("search.%s.replicas", indexName)));
    }
}

