/*
 * Decompiled with CFR 0.152.
 */
package org.egov.search;

import java.util.Arrays;
import org.egov.search.config.SearchConfig;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SearchBeans {
    @Bean
    @Autowired
    public Client transportClient(SearchConfig searchConfig) {
        ImmutableSettings.Builder settingsBuilder = ImmutableSettings.builder();
        settingsBuilder.put("cluster.name", searchConfig.searchClusterName());
        TransportClient client = new TransportClient((Settings.Builder)settingsBuilder);
        Arrays.asList(searchConfig.searchHosts()).stream().forEach(host -> this.addTransportClient((Client)client, (String)host, searchConfig.searchPort()));
        return client;
    }

    private TransportClient addTransportClient(Client client, String host, int port) {
        return ((TransportClient)client).addTransportAddress((TransportAddress)new InetSocketTransportAddress(host, port));
    }
}

