/*
 * Decompiled with CFR 0.152.
 */
package org.egov.models;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.ConstructorProperties;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.egov.enums.ChannelEnum;
import org.egov.enums.CreationReasonEnum;
import org.egov.models.Address;
import org.egov.models.AuditDetails;
import org.egov.models.Demand;
import org.egov.models.PropertyDetail;
import org.egov.models.PropertyLocation;
import org.egov.models.User;
import org.egov.models.VacantLandDetail;
import org.hibernate.validator.constraints.NotEmpty;
import org.postgresql.util.PGobject;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Property {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="tenantId")
    @NotNull
    @Size(min=4, max=128)
    private String tenantId = null;
    @JsonProperty(value="upicNumber")
    @Size(min=6, max=128)
    private String upicNumber = null;
    @JsonProperty(value="oldUpicNumber")
    @Size(min=4, max=128)
    private String oldUpicNumber = null;
    @JsonProperty(value="vltUpicNumber")
    @Size(min=4, max=128)
    private String vltUpicNumber = null;
    @JsonProperty(value="creationReason")
    @NotNull
    private CreationReasonEnum creationReason = null;
    @JsonProperty(value="address")
    @NotNull
    private Address address = null;
    @JsonProperty(value="owners")
    @Valid
    @NotNull
    @NotEmpty(message="property.MIN_ONE_OWNER_REQUIRED")
    private List<User> owners = new ArrayList<User>();
    @JsonProperty(value="propertyDetail")
    @Valid
    @NotNull
    private PropertyDetail propertyDetail = null;
    @JsonProperty(value="vacantLand")
    private VacantLandDetail vacantLand = null;
    @JsonProperty(value="assessmentDate")
    private String assessmentDate = null;
    @JsonProperty(value="occupancyDate")
    @NotNull
    private String occupancyDate = null;
    @JsonProperty(value="gisRefNo")
    @Size(min=4, max=32)
    private String gisRefNo = null;
    @JsonProperty(value="isAuthorised")
    private Boolean isAuthorised = true;
    @JsonProperty(value="isUnderWorkflow")
    private Boolean isUnderWorkflow = false;
    @JsonProperty(value="boundary")
    @NotNull
    private PropertyLocation boundary = null;
    @JsonProperty(value="active")
    private Boolean active = true;
    @JsonProperty(value="channel")
    @NotNull
    private ChannelEnum channel = null;
    @JsonProperty(value="auditDetails")
    private AuditDetails auditDetails = null;
    @JsonProperty(value="demands")
    private List<Demand> demands = null;
    @JsonProperty(value="sequenceNo")
    @NotNull
    private Integer sequenceNo = null;
    @JsonProperty(value="oldestUpicNumber")
    @Size(min=1, max=128)
    private String oldestUpicNumber = null;
    @JsonProperty(value="propertyAddress")
    private String propertyAddress = null;
    @JsonProperty(value="propertyOwner")
    private String propertyOwner = null;
    @JsonProperty(value="demandsJsonObject")
    private PGobject demandsJsonObject = null;

    @ConstructorProperties(value={"id", "tenantId", "upicNumber", "oldUpicNumber", "vltUpicNumber", "creationReason", "address", "owners", "propertyDetail", "vacantLand", "assessmentDate", "occupancyDate", "gisRefNo", "isAuthorised", "isUnderWorkflow", "boundary", "active", "channel", "auditDetails", "demands", "sequenceNo", "oldestUpicNumber", "propertyAddress", "propertyOwner", "demandsJsonObject"})
    public Property(Long id, String tenantId, String upicNumber, String oldUpicNumber, String vltUpicNumber, CreationReasonEnum creationReason, Address address, List<User> owners, PropertyDetail propertyDetail, VacantLandDetail vacantLand, String assessmentDate, String occupancyDate, String gisRefNo, Boolean isAuthorised, Boolean isUnderWorkflow, PropertyLocation boundary, Boolean active, ChannelEnum channel, AuditDetails auditDetails, List<Demand> demands, Integer sequenceNo, String oldestUpicNumber, String propertyAddress, String propertyOwner, PGobject demandsJsonObject) {
        this.id = id;
        this.tenantId = tenantId;
        this.upicNumber = upicNumber;
        this.oldUpicNumber = oldUpicNumber;
        this.vltUpicNumber = vltUpicNumber;
        this.creationReason = creationReason;
        this.address = address;
        this.owners = owners;
        this.propertyDetail = propertyDetail;
        this.vacantLand = vacantLand;
        this.assessmentDate = assessmentDate;
        this.occupancyDate = occupancyDate;
        this.gisRefNo = gisRefNo;
        this.isAuthorised = isAuthorised;
        this.isUnderWorkflow = isUnderWorkflow;
        this.boundary = boundary;
        this.active = active;
        this.channel = channel;
        this.auditDetails = auditDetails;
        this.demands = demands;
        this.sequenceNo = sequenceNo;
        this.oldestUpicNumber = oldestUpicNumber;
        this.propertyAddress = propertyAddress;
        this.propertyOwner = propertyOwner;
        this.demandsJsonObject = demandsJsonObject;
    }

    public Property() {
    }

    public void setId(Long id) {
        this.id = id;
    }

    public void setTenantId(String tenantId) {
        this.tenantId = tenantId;
    }

    public void setUpicNumber(String upicNumber) {
        this.upicNumber = upicNumber;
    }

    public void setOldUpicNumber(String oldUpicNumber) {
        this.oldUpicNumber = oldUpicNumber;
    }

    public void setVltUpicNumber(String vltUpicNumber) {
        this.vltUpicNumber = vltUpicNumber;
    }

    public void setCreationReason(CreationReasonEnum creationReason) {
        this.creationReason = creationReason;
    }

    public void setAddress(Address address) {
        this.address = address;
    }

    public void setOwners(List<User> owners) {
        this.owners = owners;
    }

    public void setPropertyDetail(PropertyDetail propertyDetail) {
        this.propertyDetail = propertyDetail;
    }

    public void setVacantLand(VacantLandDetail vacantLand) {
        this.vacantLand = vacantLand;
    }

    public void setAssessmentDate(String assessmentDate) {
        this.assessmentDate = assessmentDate;
    }

    public void setOccupancyDate(String occupancyDate) {
        this.occupancyDate = occupancyDate;
    }

    public void setGisRefNo(String gisRefNo) {
        this.gisRefNo = gisRefNo;
    }

    public void setIsAuthorised(Boolean isAuthorised) {
        this.isAuthorised = isAuthorised;
    }

    public void setIsUnderWorkflow(Boolean isUnderWorkflow) {
        this.isUnderWorkflow = isUnderWorkflow;
    }

    public void setBoundary(PropertyLocation boundary) {
        this.boundary = boundary;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setChannel(ChannelEnum channel) {
        this.channel = channel;
    }

    public void setAuditDetails(AuditDetails auditDetails) {
        this.auditDetails = auditDetails;
    }

    public void setDemands(List<Demand> demands) {
        this.demands = demands;
    }

    public void setSequenceNo(Integer sequenceNo) {
        this.sequenceNo = sequenceNo;
    }

    public void setOldestUpicNumber(String oldestUpicNumber) {
        this.oldestUpicNumber = oldestUpicNumber;
    }

    public void setPropertyAddress(String propertyAddress) {
        this.propertyAddress = propertyAddress;
    }

    public void setPropertyOwner(String propertyOwner) {
        this.propertyOwner = propertyOwner;
    }

    public void setDemandsJsonObject(PGobject demandsJsonObject) {
        this.demandsJsonObject = demandsJsonObject;
    }

    public Long getId() {
        return this.id;
    }

    public String getTenantId() {
        return this.tenantId;
    }

    public String getUpicNumber() {
        return this.upicNumber;
    }

    public String getOldUpicNumber() {
        return this.oldUpicNumber;
    }

    public String getVltUpicNumber() {
        return this.vltUpicNumber;
    }

    public CreationReasonEnum getCreationReason() {
        return this.creationReason;
    }

    public Address getAddress() {
        return this.address;
    }

    public List<User> getOwners() {
        return this.owners;
    }

    public PropertyDetail getPropertyDetail() {
        return this.propertyDetail;
    }

    public VacantLandDetail getVacantLand() {
        return this.vacantLand;
    }

    public String getAssessmentDate() {
        return this.assessmentDate;
    }

    public String getOccupancyDate() {
        return this.occupancyDate;
    }

    public String getGisRefNo() {
        return this.gisRefNo;
    }

    public Boolean getIsAuthorised() {
        return this.isAuthorised;
    }

    public Boolean getIsUnderWorkflow() {
        return this.isUnderWorkflow;
    }

    public PropertyLocation getBoundary() {
        return this.boundary;
    }

    public Boolean getActive() {
        return this.active;
    }

    public ChannelEnum getChannel() {
        return this.channel;
    }

    public AuditDetails getAuditDetails() {
        return this.auditDetails;
    }

    public List<Demand> getDemands() {
        return this.demands;
    }

    public Integer getSequenceNo() {
        return this.sequenceNo;
    }

    public String getOldestUpicNumber() {
        return this.oldestUpicNumber;
    }

    public String getPropertyAddress() {
        return this.propertyAddress;
    }

    public String getPropertyOwner() {
        return this.propertyOwner;
    }

    public PGobject getDemandsJsonObject() {
        return this.demandsJsonObject;
    }
}

