/*
 * Decompiled with CFR 0.152.
 */
package org.egov.domain.service;

import java.io.Serializable;
import java.sql.SQLException;
import org.egov.persistence.util.DBSequenceGenerator;
import org.egov.persistence.util.SequenceNumberGenerator;
import org.egov.persistence.util.Utils;
import org.hibernate.exception.SQLGrammarException;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class CrnGeneratorService {
    private SequenceNumberGenerator sequenceNumberGenerator;
    private DBSequenceGenerator dbSequenceGenerator;
    private Utils utils;
    private final String APP_NUMBER_SEQ_PREFIX = "SEQ_APPLICATION_NUMBER%s";

    public CrnGeneratorService(SequenceNumberGenerator sequenceNumberGenerator, DBSequenceGenerator dbSequenceGenerator, Utils utils) {
        this.sequenceNumberGenerator = sequenceNumberGenerator;
        this.dbSequenceGenerator = dbSequenceGenerator;
        this.utils = utils;
    }

    @Transactional
    public String generate() {
        try {
            Serializable sequenceNumber;
            String currentYear = this.utils.currentDateToYearFormat();
            String sequenceName = String.format("SEQ_APPLICATION_NUMBER%s", currentYear);
            String randomAlphabets = this.utils.getRandomAlphabets();
            try {
                sequenceNumber = this.sequenceNumberGenerator.getNextSequence(sequenceName);
            }
            catch (SQLGrammarException e) {
                sequenceNumber = this.dbSequenceGenerator.createAndGetNextSequence(sequenceName);
            }
            return String.format("%05d-%s-%s", sequenceNumber, currentYear, randomAlphabets);
        }
        catch (SQLException e) {
            throw new RuntimeException("Error occurred while generating Application Number", e);
        }
    }
}

