/*
 * Decompiled with CFR 0.152.
 */
package org.egov.mdms.service;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.egov.common.contract.request.RequestInfo;
import org.egov.mdms.model.MasterDetail;
import org.egov.mdms.model.MdmsCriteria;
import org.egov.mdms.model.MdmsCriteriaReq;
import org.egov.mdms.model.MdmsResponse;
import org.egov.mdms.model.ModuleDetail;
import org.egov.tracer.model.CustomException;
import org.egov.tracer.model.ServiceCallException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestTemplate;

@Service
public class MdmsClientService {
    private static final Logger log = LoggerFactory.getLogger(MdmsClientService.class);
    @Autowired
    private RestTemplate restTemplate;
    @Value(value="${mdms.service.host:http://localhost:8080/}")
    private String mdmsHost;
    @Value(value="${mdms.service.search.uri:egov-mdms-service/v1/_search}")
    private String mdmsSearchUri;

    public MdmsResponse getMaster(RequestInfo requestInfo, String tenantId, Map<String, List<MasterDetail>> masterDetails) {
        log.info("MdmsClientService masterDetails:" + masterDetails);
        MdmsCriteriaReq mdmsCriteriaReq = new MdmsCriteriaReq();
        mdmsCriteriaReq.setRequestInfo(requestInfo);
        ArrayList<ModuleDetail> moduleDetails = new ArrayList<ModuleDetail>();
        for (Map.Entry<String, List<MasterDetail>> entry : masterDetails.entrySet()) {
            ModuleDetail moduleDetail = ModuleDetail.builder().moduleName(entry.getKey()).masterDetails(entry.getValue()).build();
            moduleDetails.add(moduleDetail);
            MdmsCriteria mdmsCriteria = MdmsCriteria.builder().tenantId(tenantId).moduleDetails(moduleDetails).build();
            mdmsCriteriaReq.setMdmsCriteria(mdmsCriteria);
        }
        return this.getMaster(mdmsCriteriaReq);
    }

    public MdmsResponse getMaster(MdmsCriteriaReq mdmsCriteriaReq) {
        log.info("mdmsCriteriaReq:" + mdmsCriteriaReq);
        MdmsResponse mdmsResponse = null;
        try {
            mdmsResponse = (MdmsResponse)this.restTemplate.postForObject(this.mdmsHost.concat(this.mdmsSearchUri), (Object)mdmsCriteriaReq, MdmsResponse.class, new Object[0]);
        }
        catch (HttpClientErrorException ex) {
            ex.printStackTrace();
            String excep = ex.getResponseBodyAsString();
            log.info("HttpClientErrorException:" + excep);
            throw new ServiceCallException(excep);
        }
        catch (Exception ex) {
            log.error("Exception: " + ex.getMessage());
            throw new CustomException("MDMS_RESPONSE_ERROR", "Error while fetching data from MDMS: " + ex.getMessage());
        }
        return mdmsResponse;
    }
}

