/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.config;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.minidev.json.JSONArray;
import org.egov.common.contract.request.RequestInfo;
import org.egov.encryption.config.EncProperties;
import org.egov.encryption.models.Attribute;
import org.egov.encryption.models.AttributeAccess;
import org.egov.encryption.models.RoleBasedDecryptionPolicy;
import org.egov.encryption.models.SecurityPolicy;
import org.egov.encryption.models.UniqueIdentifier;
import org.egov.encryption.models.Visibility;
import org.egov.encryption.util.MdmsFetcher;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.web.client.RestTemplate;

@Component
public class DecryptionPolicyConfiguration {
    private static final Logger log = LoggerFactory.getLogger(DecryptionPolicyConfiguration.class);
    @Autowired
    private EncProperties encProperties;
    @Autowired
    private MdmsFetcher mdmsFetcher;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ObjectMapper objectMapper;
    private Map<String, List<Attribute>> modelAttributeAccessMap;
    private Map<String, Map<String, List<AttributeAccess>>> modelRoleBasedDecryptionPolicyMap;
    private Map<String, UniqueIdentifier> uniqueIdentifierMap;

    void initializeModelAttributeAccessMap(String tenantId, List<SecurityPolicy> modelRoleAttributeAccessList) {
        this.modelAttributeAccessMap.putAll(modelRoleAttributeAccessList.stream().collect(Collectors.toMap(securityPolicy -> this.tenantModelKey(tenantId, securityPolicy.getModel()), SecurityPolicy::getAttributes)));
    }

    void initializeRoleBasedDecryptionPolicyMap(String tenantId, List<SecurityPolicy> modelRoleAttributeAccessList) {
        for (SecurityPolicy securityPolicy : modelRoleAttributeAccessList) {
            this.modelRoleBasedDecryptionPolicyMap.put(this.tenantModelKey(tenantId, securityPolicy.getModel()), this.makeRoleAttributeAccessMapping(securityPolicy.getRoleBasedDecryptionPolicy()));
        }
    }

    void initializeUniqueIdentifierMap(String tenantId, List<SecurityPolicy> modelRoleAttributeAccessList) {
        this.uniqueIdentifierMap.putAll(modelRoleAttributeAccessList.stream().collect(Collectors.toMap(securityPolicy -> this.tenantModelKey(tenantId, securityPolicy.getModel()), SecurityPolicy::getUniqueIdentifier)));
    }

    @PostConstruct
    void initializeModelAttributeAccessMapFromMdms() {
        this.modelAttributeAccessMap = new HashMap<String, List<Attribute>>();
        this.modelRoleBasedDecryptionPolicyMap = new HashMap<String, Map<String, List<AttributeAccess>>>();
        this.uniqueIdentifierMap = new HashMap<String, UniqueIdentifier>();
        if (!CollectionUtils.isEmpty(this.encProperties.getStateLevelTenantIds())) {
            for (String tenantId : this.encProperties.getStateLevelTenantIds()) {
                List securityPolicyList = null;
                try {
                    JSONArray securityPolicyJson = this.mdmsFetcher.getSecurityMdmsForFilter(tenantId, null);
                    ObjectReader reader = this.objectMapper.readerFor((JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, SecurityPolicy.class));
                    securityPolicyList = (List)reader.readValue(securityPolicyJson.toString());
                }
                catch (IOException e) {
                    log.error("Error occurred while reading Security Policy from MDMS Config", (Throwable)e);
                    throw new CustomException("SECURITY_POLICY_READING_ERROR", "Error occurred while reading Security Policy from MDMS Config");
                }
                this.initializeModelAttributeAccessMap(tenantId, securityPolicyList);
                this.initializeRoleBasedDecryptionPolicyMap(tenantId, securityPolicyList);
                this.initializeUniqueIdentifierMap(tenantId, securityPolicyList);
            }
        }
    }

    public UniqueIdentifier getUniqueIdentifierForModel(String tenantId, String model) {
        return this.uniqueIdentifierMap.get(this.tenantModelKey(tenantId, model));
    }

    public Map<Attribute, Visibility> getRoleAttributeAccessListForModel(RequestInfo requestInfo, String tenantId, String model, List<String> roles) {
        HashMap<Attribute, Visibility> mapping = new HashMap<Attribute, Visibility>();
        String modelKey = this.tenantModelKey(tenantId, model);
        try {
            List<Attribute> attributesList = this.modelAttributeAccessMap.get(modelKey);
            Map<String, List<AttributeAccess>> roleAttributeAccessMap = this.modelRoleBasedDecryptionPolicyMap.get(modelKey);
            boolean isAttributeListEmpty = CollectionUtils.isEmpty(attributesList);
            boolean isRoleAttributeAccessMapEmpty = CollectionUtils.isEmpty(roleAttributeAccessMap);
            if (isAttributeListEmpty) {
                throw new CustomException("DECRYPTION_NULL_ERROR", "Attribute list is empty");
            }
            if (!isAttributeListEmpty && !isRoleAttributeAccessMapEmpty) {
                Map<String, Attribute> attributesMap = this.makeAttributeMap(attributesList);
                ArrayList<String> secondLevelVisibility = new ArrayList<String>();
                for (String role : roles) {
                    if (!roleAttributeAccessMap.containsKey(role)) continue;
                    List<AttributeAccess> attributeList = roleAttributeAccessMap.get(role);
                    for (AttributeAccess attributeAccess : attributeList) {
                        String attributeName = attributeAccess.getAttribute();
                        Attribute attribute = attributesMap.get(attributeName);
                        if (requestInfo.getPlainAccessRequest() != null && !CollectionUtils.isEmpty((Collection)requestInfo.getPlainAccessRequest().getPlainRequestFields()) && requestInfo.getPlainAccessRequest().getPlainRequestFields().contains(attributeName) && attributeAccess.getSecondLevelVisibility() != null && !secondLevelVisibility.contains(attributeName)) {
                            secondLevelVisibility.add(attributeName);
                        }
                        String firstLevelVisibility = attributeAccess.getFirstLevelVisibility() != null ? String.valueOf((Object)attributeAccess.getFirstLevelVisibility()) : String.valueOf((Object)attribute.getDefaultVisibility());
                        Visibility visibility = Visibility.valueOf(firstLevelVisibility);
                        if (mapping.containsKey(attribute)) {
                            if (((Visibility)((Object)mapping.get(attribute))).ordinal() <= visibility.ordinal()) continue;
                            mapping.remove(attribute);
                            mapping.put(attribute, visibility);
                            continue;
                        }
                        mapping.put(attribute, visibility);
                    }
                }
                if (requestInfo.getPlainAccessRequest() != null) {
                    requestInfo.getPlainAccessRequest().setPlainRequestFields(secondLevelVisibility);
                }
            }
            ArrayList mappingAttributesList = new ArrayList(mapping.keySet());
            ArrayList<String> attributesToAvoidlist = new ArrayList<String>();
            for (Attribute attribute : mappingAttributesList) {
                attributesToAvoidlist.add(attribute.getName());
            }
            if (!isAttributeListEmpty) {
                this.getDefaultVisibilityMapping(attributesList, mapping, attributesToAvoidlist);
            }
            return mapping;
        }
        catch (Exception e) {
            throw new CustomException("DECRYPTION_NULL_ERROR", "Error in decryption process");
        }
    }

    private Map<String, List<AttributeAccess>> makeRoleAttributeAccessMapping(List<RoleBasedDecryptionPolicy> roleBasedDecryptionPolicyList) {
        HashMap<String, List<AttributeAccess>> roleAttributeAccessMap = new HashMap<String, List<AttributeAccess>>();
        for (RoleBasedDecryptionPolicy roleBasedDecryptionPolicy : roleBasedDecryptionPolicyList) {
            List<String> roles = roleBasedDecryptionPolicy.getRoles();
            List<AttributeAccess> attributeAccessList = roleBasedDecryptionPolicy.getAttributeAccessList();
            for (String role : roles) {
                roleAttributeAccessMap.put(role, attributeAccessList);
            }
        }
        return roleAttributeAccessMap;
    }

    private Map<String, Attribute> makeAttributeMap(List<Attribute> attributesList) {
        HashMap<String, Attribute> atrributesMap = new HashMap<String, Attribute>();
        for (Attribute attribute : attributesList) {
            String filedName = attribute.getName();
            atrributesMap.put(filedName, attribute);
        }
        return atrributesMap;
    }

    public UniqueIdentifier getSecurityPolicyUniqueIdentifier(String tenantId, String model) {
        return this.uniqueIdentifierMap.get(this.tenantModelKey(tenantId, model));
    }

    private void getDefaultVisibilityMapping(List<Attribute> attributesList, Map<Attribute, Visibility> mapping, List<String> attributesToAvoidlist) {
        for (Attribute attribute : attributesList) {
            String defaultVisibility = String.valueOf((Object)attribute.getDefaultVisibility());
            Visibility visibility = Visibility.valueOf(defaultVisibility);
            if (attributesToAvoidlist.contains(attribute.getName())) continue;
            if (mapping.containsKey(attribute)) {
                if (mapping.get(attribute).ordinal() <= visibility.ordinal()) continue;
                mapping.remove(attribute);
                mapping.put(attribute, visibility);
                continue;
            }
            mapping.put(attribute, visibility);
        }
    }

    private String tenantModelKey(String tenantId, String model) {
        return tenantId + "_" + model;
    }
}

