/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.util;

import java.util.Arrays;
import java.util.Map;
import net.minidev.json.JSONArray;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.utils.MultiStateInstanceUtil;
import org.egov.encryption.config.EncProperties;
import org.egov.mdms.model.MasterDetail;
import org.egov.mdms.model.MdmsCriteria;
import org.egov.mdms.model.MdmsCriteriaReq;
import org.egov.mdms.model.MdmsResponse;
import org.egov.mdms.model.ModuleDetail;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class MdmsFetcher {
    private static final Logger log = LoggerFactory.getLogger(MdmsFetcher.class);
    @Autowired
    private EncProperties encProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private MultiStateInstanceUtil multiStateInstanceUtil;
    public static final String TENANTID_MDC_STRING = "TENANTID";

    public JSONArray getSecurityMdmsForFilter(String filter) {
        return this.getMdmsForFilter(filter, "SecurityPolicy");
    }

    public JSONArray getMaskingMdmsForFilter(String filter) {
        return this.getMdmsForFilter(filter, "MaskingPatterns");
    }

    public JSONArray getMdmsForFilter(String filter, String masterName) {
        MasterDetail masterDetail = MasterDetail.builder().name(masterName).filter(filter).build();
        ModuleDetail moduleDetail = ModuleDetail.builder().moduleName("DataSecurity").masterDetails(Arrays.asList(masterDetail)).build();
        MdmsCriteria mdmsCriteria = MdmsCriteria.builder().tenantId(this.encProperties.getStateLevelTenantId()).moduleDetails(Arrays.asList(moduleDetail)).build();
        MdmsCriteriaReq mdmsCriteriaReq = MdmsCriteriaReq.builder().requestInfo(RequestInfo.builder().build()).mdmsCriteria(mdmsCriteria).build();
        if (this.multiStateInstanceUtil.getIsEnvironmentCentralInstance().booleanValue()) {
            MDC.put((String)TENANTID_MDC_STRING, (String)this.encProperties.getStateLevelTenantId());
        }
        MDC.put((String)TENANTID_MDC_STRING, (String)this.encProperties.getStateLevelTenantId());
        try {
            ResponseEntity response = this.restTemplate.postForEntity(this.encProperties.getEgovMdmsHost() + this.encProperties.getEgovMdmsSearchEndpoint(), (Object)mdmsCriteriaReq, MdmsResponse.class, new Object[0]);
            return (JSONArray)((Map)((MdmsResponse)response.getBody()).getMdmsRes().get("DataSecurity")).get(masterName);
        }
        catch (Exception e) {
            log.error("Error occurred while fetching MDMS Configs", (Throwable)e);
            throw new CustomException("MDMS_FETCH_ERROR", "Error occurred while fetching MDMS Configs");
        }
    }
}

