/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.config;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
@ConfigurationProperties(prefix="egov.enc.tenant")
public class EncTenantSpecificProperties {
    private boolean useDefaultValues;
    private Map<String, String> host = new HashMap<String, String>();
    private Map<String, String> defaultEncryptDataType = new HashMap<String, String>();
    private Map<String, String> encryptEndpoint = new HashMap<String, String>();
    private Map<String, String> decryptEndpoint = new HashMap<String, String>();
    private Map<String, String> auditTopicName = new HashMap<String, String>();
    private Map<String, String> mdmsHost = new HashMap<String, String>();
    private Map<String, String> mdmsSearchEndpoint = new HashMap<String, String>();

    private String getValue(Map<String, String> map, String tenantId, String defaultValue) {
        String value = map.get(tenantId.toLowerCase(Locale.ROOT));
        if (!StringUtils.isEmpty((Object)value)) {
            return value;
        }
        value = map.get(tenantId.toUpperCase(Locale.ROOT));
        if (!StringUtils.isEmpty((Object)value)) {
            return value;
        }
        return this.useDefaultValues ? defaultValue : value;
    }

    public String getHost(String tenantId, String defaultValue) {
        return this.getValue(this.host, tenantId, defaultValue);
    }

    public String getDefaultEncryptDataType(String tenantId, String defaultValue) {
        return this.getValue(this.defaultEncryptDataType, tenantId, defaultValue);
    }

    public String getEncryptEndpoint(String tenantId, String defaultValue) {
        return this.getValue(this.encryptEndpoint, tenantId, defaultValue);
    }

    public String getDecryptEndpoint(String tenantId, String defaultValue) {
        return this.getValue(this.decryptEndpoint, tenantId, defaultValue);
    }

    public String getAuditTopicName(String tenantId, String defaultValue) {
        return this.getValue(this.auditTopicName, tenantId, defaultValue);
    }

    public String getMdmsHost(String tenantId, String defaultValue) {
        return this.getValue(this.mdmsHost, tenantId, defaultValue);
    }

    public String getMdmsSearchEndpoint(String tenantId, String defaultValue) {
        return this.getValue(this.mdmsSearchEndpoint, tenantId, defaultValue);
    }

    public void setUseDefaultValues(boolean useDefaultValues) {
        this.useDefaultValues = useDefaultValues;
    }

    public void setHost(Map<String, String> host) {
        this.host = host;
    }

    public void setDefaultEncryptDataType(Map<String, String> defaultEncryptDataType) {
        this.defaultEncryptDataType = defaultEncryptDataType;
    }

    public void setEncryptEndpoint(Map<String, String> encryptEndpoint) {
        this.encryptEndpoint = encryptEndpoint;
    }

    public void setDecryptEndpoint(Map<String, String> decryptEndpoint) {
        this.decryptEndpoint = decryptEndpoint;
    }

    public void setAuditTopicName(Map<String, String> auditTopicName) {
        this.auditTopicName = auditTopicName;
    }

    public void setMdmsHost(Map<String, String> mdmsHost) {
        this.mdmsHost = mdmsHost;
    }

    public void setMdmsSearchEndpoint(Map<String, String> mdmsSearchEndpoint) {
        this.mdmsSearchEndpoint = mdmsSearchEndpoint;
    }

    public boolean isUseDefaultValues() {
        return this.useDefaultValues;
    }

    public Map<String, String> getHost() {
        return this.host;
    }

    public Map<String, String> getDefaultEncryptDataType() {
        return this.defaultEncryptDataType;
    }

    public Map<String, String> getEncryptEndpoint() {
        return this.encryptEndpoint;
    }

    public Map<String, String> getDecryptEndpoint() {
        return this.decryptEndpoint;
    }

    public Map<String, String> getAuditTopicName() {
        return this.auditTopicName;
    }

    public Map<String, String> getMdmsHost() {
        return this.mdmsHost;
    }

    public Map<String, String> getMdmsSearchEndpoint() {
        return this.mdmsSearchEndpoint;
    }
}

