/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import org.egov.encryption.config.EncProperties;
import org.egov.encryption.config.EncTenantSpecificProperties;
import org.egov.encryption.web.contract.EncReqObject;
import org.egov.encryption.web.contract.EncryptionRequest;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
class EncryptionServiceRestConnection {
    private static final Logger log = LoggerFactory.getLogger(EncryptionServiceRestConnection.class);
    @Autowired
    private EncProperties encProperties;
    @Autowired
    private EncTenantSpecificProperties encTenantSpecificProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ObjectMapper objectMapper;

    EncryptionServiceRestConnection() {
    }

    Object callEncrypt(String tenantId, String type, Object value) throws IOException {
        EncReqObject encReqObject = new EncReqObject(tenantId, type, value);
        EncryptionRequest encryptionRequest = new EncryptionRequest();
        encryptionRequest.setEncryptionRequests(new ArrayList<EncReqObject>(Collections.singleton(encReqObject)));
        String encryptionHost = this.encTenantSpecificProperties.getHost(tenantId, this.encProperties.getEgovEncHost());
        String encryptEndpoint = this.encTenantSpecificProperties.getEncryptEndpoint(tenantId, this.encProperties.getEgovEncEncryptPath());
        log.info("Using encryption host for tenantId: {} is {} with endpoint {}", new Object[]{tenantId, encryptionHost, encryptEndpoint});
        try {
            ResponseEntity response = this.restTemplate.postForEntity(encryptionHost + encryptEndpoint, (Object)encryptionRequest, String.class, new Object[0]);
            return this.objectMapper.readTree((String)response.getBody()).get(0);
        }
        catch (Exception e) {
            log.error("Error occurred while calling Encryption Service", (Throwable)e);
            throw new CustomException("ENCRYPTION_SERVICE_ERROR", "Error occurred while calling Encryption Service");
        }
    }

    JsonNode callDecrypt(String tenantId, Object ciphertext) {
        String encryptionHost = this.encTenantSpecificProperties.getHost(tenantId, this.encProperties.getEgovEncHost());
        String decryptEndpoint = this.encTenantSpecificProperties.getDecryptEndpoint(tenantId, this.encProperties.getEgovEncDecryptPath());
        log.info("Using encryption host for tenantId: {} is {} with endpoint {}", new Object[]{tenantId, encryptionHost, decryptEndpoint});
        try {
            ResponseEntity response = this.restTemplate.postForEntity(encryptionHost + decryptEndpoint, ciphertext, JsonNode.class, new Object[0]);
            return (JsonNode)response.getBody();
        }
        catch (Exception e) {
            throw new CustomException("ENCRYPTION_SERVICE_ERROR", "Error occurred while calling Encryption Service");
        }
    }
}

