/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.audit;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.ArrayList;
import java.util.UUID;
import org.egov.common.contract.request.RequestInfo;
import org.egov.common.contract.request.User;
import org.egov.encryption.config.DecryptionPolicyConfiguration;
import org.egov.encryption.config.EncProperties;
import org.egov.encryption.config.EncTenantSpecificProperties;
import org.egov.encryption.models.AuditObject;
import org.egov.encryption.models.UniqueIdentifier;
import org.egov.encryption.producer.Producer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditService {
    @Autowired
    private Producer producer;
    @Autowired
    private EncProperties encProperties;
    @Autowired
    private EncTenantSpecificProperties encTenantSpecificProperties;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private DecryptionPolicyConfiguration decryptionPolicyConfiguration;

    public void audit(JsonNode json, String tenantId, String model, String purpose, RequestInfo requestInfo) {
        User user = requestInfo.getUserInfo();
        AuditObject auditObject = AuditObject.builder().build();
        auditObject.setId(UUID.randomUUID().toString());
        auditObject.setTimestamp(System.currentTimeMillis());
        auditObject.setUserId(user.getUuid());
        auditObject.setModel(model);
        auditObject.setPurpose(purpose);
        if (requestInfo.getPlainAccessRequest() != null) {
            auditObject.setPlainAccessRequest(requestInfo.getPlainAccessRequest());
        }
        UniqueIdentifier uniqueIdentifier = this.decryptionPolicyConfiguration.getUniqueIdentifierForModel(tenantId, model);
        ArrayList<String> entityIds = new ArrayList<String>();
        for (JsonNode node : json) {
            String nodeUuid = node.at(uniqueIdentifier.getJsonPath()).asText();
            entityIds.add(nodeUuid);
        }
        auditObject.setEntityIds(entityIds);
        String auditTopicName = this.encTenantSpecificProperties.getAuditTopicName(tenantId, this.encProperties.getAuditTopicName());
        this.producer.push(auditTopicName, auditObject.getId(), auditObject);
    }
}

