/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.util;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JacksonUtils {
    private static final Logger log = LoggerFactory.getLogger(JacksonUtils.class);

    public static JsonNode merge(JsonNode newNode, JsonNode originalNode) {
        if (newNode == null || newNode.isNull()) {
            return originalNode;
        }
        if (originalNode == null || originalNode.isNull()) {
            return newNode;
        }
        if (newNode.isObject()) {
            newNode = JacksonUtils.mergeObjectNodes((ObjectNode)newNode, (ObjectNode)originalNode);
        } else if (newNode.isArray()) {
            newNode = JacksonUtils.mergeArrayNode((ArrayNode)newNode, (ArrayNode)originalNode);
        }
        return newNode;
    }

    static ArrayNode mergeArrayNode(ArrayNode newNode, ArrayNode originalNode) {
        int size = newNode.size();
        if (newNode.size() < originalNode.size()) {
            size = originalNode.size();
        }
        for (int i = 0; i < size; ++i) {
            JsonNode jsonNode = JacksonUtils.merge(newNode.get(i), originalNode.get(i));
            if (i < newNode.size()) {
                newNode.set(i, jsonNode);
                continue;
            }
            newNode.add(jsonNode);
        }
        return newNode;
    }

    static ObjectNode mergeObjectNodes(ObjectNode newNode, ObjectNode originalNode) {
        Iterator fieldNames = originalNode.fieldNames();
        while (fieldNames.hasNext()) {
            String fieldName = (String)fieldNames.next();
            JsonNode jsonNode = newNode.get(fieldName);
            if (jsonNode != null) {
                JacksonUtils.merge(jsonNode, originalNode.get(fieldName));
                continue;
            }
            if (!(newNode instanceof ObjectNode)) continue;
            JsonNode value = originalNode.get(fieldName);
            newNode.set(fieldName, value);
        }
        return newNode;
    }

    public static JsonNode filterJsonNodeForPaths(JsonNode jsonNode, List<String> filterPaths) {
        ArrayNode filteredNode;
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        if (jsonNode instanceof ArrayNode) {
            filteredNode = mapper.createArrayNode();
        } else if (jsonNode instanceof ObjectNode) {
            filteredNode = mapper.createObjectNode();
        } else {
            return null;
        }
        for (String path : filterPaths) {
            JsonNode singlePathFilterNode = JacksonUtils.filterJsonNodeForPath(jsonNode, path);
            filteredNode = JacksonUtils.merge(singlePathFilterNode, (JsonNode)filteredNode);
        }
        return filteredNode;
    }

    static JsonNode filterJsonNodeForPath(JsonNode jsonNode, String filterPath) {
        ObjectMapper objectMapper = new ObjectMapper(new JsonFactory());
        if (filterPath == null) {
            return jsonNode;
        }
        if (jsonNode == null) {
            return null;
        }
        String key = JacksonUtils.getFirstJsonKeyForPath(filterPath);
        ArrayNode newNode = null;
        try {
            if (key.contains("*")) {
                ArrayNode arrayNode = (ArrayNode)jsonNode;
                newNode = objectMapper.createArrayNode();
                for (JsonNode value : arrayNode) {
                    JsonNode filteredNode = JacksonUtils.filterJsonNodeForPath(value, JacksonUtils.getRemainingJsonKeyForPath(filterPath));
                    if (filteredNode == null || filteredNode.isNull()) continue;
                    newNode.add(filteredNode);
                }
            } else {
                ObjectNode objectNode = (ObjectNode)jsonNode;
                newNode = objectMapper.createObjectNode();
                JsonNode value = objectNode.get(key);
                JsonNode filteredNode = JacksonUtils.filterJsonNodeForPath(value, JacksonUtils.getRemainingJsonKeyForPath(filterPath));
                if (filteredNode != null && !filteredNode.isNull()) {
                    ((ObjectNode)newNode).set(key, filteredNode);
                }
            }
        }
        catch (ClassCastException e) {
            log.info("Cannot find value for path : " + filterPath);
        }
        return newNode;
    }

    static String getFirstJsonKeyForPath(String path) {
        String[] keys = path.split("/", 2);
        return keys[0];
    }

    static String getRemainingJsonKeyForPath(String path) {
        String[] keys = path.split("/", 2);
        if (keys.length == 1) {
            return null;
        }
        return keys[1];
    }

    public static JsonNode filterJsonNodeWithFields(JsonNode jsonNode, List<String> filterFields) {
        if (JacksonUtils.checkIfNoFieldExistsInJsonNode(jsonNode, filterFields)) {
            return null;
        }
        ObjectMapper mapper = new ObjectMapper(new JsonFactory());
        if (jsonNode.isObject()) {
            ObjectNode objectNode = (ObjectNode)jsonNode;
            ObjectNode filteredObjectNode = mapper.createObjectNode();
            Iterator fieldIterator = objectNode.fieldNames();
            while (fieldIterator.hasNext()) {
                String field = (String)fieldIterator.next();
                if (filterFields.contains(field) && !objectNode.get(field).isNull()) {
                    filteredObjectNode.set(field, objectNode.get(field));
                    continue;
                }
                JsonNode filteredJsonNode = JacksonUtils.filterJsonNodeWithFields(objectNode.get(field), filterFields);
                if (filteredJsonNode == null) continue;
                filteredObjectNode.set(field, filteredJsonNode);
            }
            if (filteredObjectNode.isEmpty(mapper.getSerializerProvider())) {
                return null;
            }
            return filteredObjectNode;
        }
        if (jsonNode.isArray()) {
            ArrayNode arrayNode = (ArrayNode)jsonNode;
            ArrayNode filteredArrayNode = mapper.createArrayNode();
            for (int i = 0; i < arrayNode.size(); ++i) {
                Object filteredJsonNode = JacksonUtils.filterJsonNodeWithFields(arrayNode.get(i), filterFields);
                if (filteredJsonNode == null) {
                    filteredJsonNode = arrayNode.get(i).isArray() ? mapper.createArrayNode() : (arrayNode.get(i).isObject() ? mapper.createObjectNode() : NullNode.getInstance());
                }
                filteredArrayNode.add(filteredJsonNode);
            }
            return filteredArrayNode;
        }
        return null;
    }

    static boolean checkIfNoFieldExistsInJsonNode(JsonNode jsonNode, List<String> fields) {
        for (String field : fields) {
            if (String.valueOf(jsonNode.findPath(field)).isEmpty()) continue;
            return false;
        }
        return true;
    }
}

