/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.config;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import net.minidev.json.JSONArray;
import org.egov.encryption.models.Attribute;
import org.egov.encryption.models.SecurityPolicy;
import org.egov.encryption.util.MdmsFetcher;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class EncryptionPolicyConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EncryptionPolicyConfiguration.class);
    @Autowired
    private MdmsFetcher mdmsFetcher;
    @Autowired
    private ObjectMapper objectMapper;
    private Map<String, List<Attribute>> encryptionPolicyAttributesMap;

    @PostConstruct
    void initializeEncryptionPolicyAttributesMapFromMdms() throws JsonProcessingException {
        try {
            JSONArray attributesDetailsJSON = this.mdmsFetcher.getSecurityMdmsForFilter(null);
            ObjectReader reader = this.objectMapper.readerFor((JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, SecurityPolicy.class));
            List securityPolicies = (List)reader.readValue(attributesDetailsJSON.toString());
            this.encryptionPolicyAttributesMap = securityPolicies.stream().collect(Collectors.toMap(SecurityPolicy::getModel, SecurityPolicy::getAttributes));
        }
        catch (IOException e) {
            log.error("Error occurred while reading Security Policy from MDMS Config", (Throwable)e);
            throw new CustomException("SECURITY_POLICY_READING_ERROR", "Error occurred while reading Security Policy from MDMS Config");
        }
    }

    public List<Attribute> getAttributeDetailsForModel(String modelName) {
        try {
            return this.encryptionPolicyAttributesMap.get(modelName);
        }
        catch (Exception e) {
            throw new CustomException("DECRYPTION_ERROR", "Error in retrieving MDMS data");
        }
    }
}

