/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.masking;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import net.minidev.json.JSONArray;
import org.egov.common.contract.request.RequestInfo;
import org.egov.encryption.config.EncProperties;
import org.egov.encryption.models.Attribute;
import org.egov.encryption.models.UniqueIdentifier;
import org.egov.encryption.util.JSONBrowseUtil;
import org.egov.encryption.util.JacksonUtils;
import org.egov.encryption.util.JsonPathConverter;
import org.egov.encryption.util.MdmsFetcher;
import org.egov.tracer.model.CustomException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
public class MaskingService {
    private static final Logger log = LoggerFactory.getLogger(MaskingService.class);
    Map<String, String> maskingPatternMap = new HashMap<String, String>();
    @Autowired
    private EncProperties encProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ObjectMapper objectMapper;
    @Autowired
    private MdmsFetcher mdmsFetcher;

    @PostConstruct
    private void initMaskingPatternMap() {
        try {
            JSONArray maskingPatternListJSON = this.mdmsFetcher.getMaskingMdmsForFilter(null);
            for (int i = 0; i < maskingPatternListJSON.size(); ++i) {
                Map obj = (Map)this.objectMapper.convertValue(maskingPatternListJSON.get(i), Map.class);
                this.maskingPatternMap.put((String)obj.get("patternId"), (String)obj.get("pattern"));
            }
        }
        catch (Exception e) {
            log.error("Error occurred while reading Masking Pattern from MDMS Config", (Throwable)e);
            throw new CustomException("MASKING_PATTER_READING_ERROR", "Error occurred while reading Masking Pattern from MDMS Config");
        }
    }

    public <T> T maskData(T data, Attribute attribute) {
        String value = String.valueOf(data);
        String patternId = attribute.getPatternId();
        String maskingRegex = this.maskingPatternMap.get(patternId);
        value = value.replaceAll(maskingRegex, "*");
        return (T)value;
    }

    public JsonNode maskData(JsonNode decryptedNode, List<Attribute> attributes, UniqueIdentifier uniqueIdentifier, RequestInfo requestInfo) {
        JsonNode maskedNode = decryptedNode.deepCopy();
        for (Attribute attribute : attributes) {
            JsonNode jsonNode = JacksonUtils.filterJsonNodeForPaths(maskedNode, JsonPathConverter.convertToArrayJsonPaths(Arrays.asList(attribute.getJsonPath())));
            jsonNode = JSONBrowseUtil.mapValues(jsonNode, value -> this.maskData(value, attribute));
            maskedNode = JacksonUtils.merge(jsonNode, maskedNode);
        }
        if (requestInfo.getPlainAccessRequest() != null && requestInfo.getPlainAccessRequest().getRecordId() != null) {
            maskedNode = this.addPlainRequestAccessValues((ArrayNode)maskedNode, (ArrayNode)decryptedNode, attributes, uniqueIdentifier, requestInfo);
        }
        return maskedNode;
    }

    private JsonNode addPlainRequestAccessValues(ArrayNode maskedArray, ArrayNode decryptedArray, List<Attribute> attributes, UniqueIdentifier uniqueIdentifier, RequestInfo requestInfo) {
        String recordId = requestInfo.getPlainAccessRequest().getRecordId();
        List plainRequestFields = requestInfo.getPlainAccessRequest().getPlainRequestFields();
        for (int i = 0; i < maskedArray.size(); ++i) {
            JsonNode maskedNode = maskedArray.get(i);
            JsonNode decryptedNode = decryptedArray.get(i);
            if (!recordId.equals(maskedNode.get(uniqueIdentifier.getJsonPath()).asText())) continue;
            JsonNode plainNode = this.createPlainNode(decryptedNode, plainRequestFields, attributes);
            plainNode = JacksonUtils.merge(plainNode, maskedNode);
            maskedArray.remove(i);
            maskedArray.insert(i, plainNode);
        }
        return maskedArray;
    }

    private JsonNode createPlainNode(JsonNode decryptedNode, List<String> plainRequestFields, List<Attribute> attributes) {
        JsonNode plainNode = decryptedNode.deepCopy();
        ArrayList<String> plainPaths = new ArrayList<String>();
        for (Attribute attribute : attributes) {
            if (!plainRequestFields.contains(attribute.getName())) continue;
            plainPaths.add(attribute.getJsonPath());
        }
        plainNode = JacksonUtils.filterJsonNodeForPaths(plainNode, plainPaths);
        return plainNode;
    }
}

