/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.audit;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.LongNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.util.UUID;
import org.egov.common.contract.request.User;
import org.egov.encryption.config.EncProperties;
import org.egov.encryption.models.AuditObject;
import org.egov.encryption.producer.Producer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AuditService {
    @Autowired
    private Producer producer;
    @Autowired
    private EncProperties encProperties;
    @Autowired
    private ObjectMapper objectMapper;

    public void audit(JsonNode data, User user) {
        AuditObject auditObject = AuditObject.builder().build();
        auditObject.setData(data);
        auditObject.setTimestamp(System.currentTimeMillis());
        auditObject.setUserId(user.getUuid());
        auditObject.setId(UUID.randomUUID().toString());
        this.producer.push(this.encProperties.getAuditTopicName(), auditObject.getId(), this.objectMapper.valueToTree((Object)auditObject).toString());
    }

    public void audit(String userId, Long timestamp, String purpose, JsonNode abacParams, JsonNode data) {
        ObjectNode auditObject = this.objectMapper.createObjectNode();
        auditObject.set("id", (JsonNode)TextNode.valueOf((String)UUID.randomUUID().toString()));
        auditObject.set("userId", (JsonNode)TextNode.valueOf((String)userId));
        auditObject.set("timestamp", (JsonNode)LongNode.valueOf((long)timestamp));
        auditObject.set("purpose", (JsonNode)TextNode.valueOf((String)purpose));
        auditObject.set("abacParams", abacParams);
        auditObject.set("data", data);
        this.producer.push(this.encProperties.getAuditTopicName(), auditObject.get("id").asText(), auditObject);
    }
}

