/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.egov.common.contract.request.Role;
import org.egov.common.contract.request.User;
import org.egov.encryption.EncryptionService;
import org.egov.encryption.EncryptionServiceRestConnection;
import org.egov.encryption.accesscontrol.AbacFilter;
import org.egov.encryption.config.AbacConfiguration;
import org.egov.encryption.config.EncryptionPolicyConfiguration;
import org.egov.encryption.masking.MaskingService;
import org.egov.encryption.models.AccessType;
import org.egov.encryption.models.Attribute;
import org.egov.encryption.util.ConvertClass;
import org.egov.encryption.util.JSONBrowseUtil;
import org.egov.encryption.util.JacksonUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class EncryptionServiceImpl
implements EncryptionService {
    private static final Logger log = LoggerFactory.getLogger(EncryptionServiceImpl.class);
    @Autowired
    private EncryptionServiceRestConnection encryptionServiceRestConnection;
    @Autowired
    private EncryptionPolicyConfiguration encryptionPolicyConfiguration;
    @Autowired
    private AbacConfiguration abacConfiguration;
    @Autowired
    private AbacFilter abacFilter;
    @Autowired
    private MaskingService maskingService;
    @Autowired
    private ObjectMapper objectMapper;

    @Override
    public JsonNode encryptJson(Object plaintextJson, String key, String tenantId) throws IOException {
        JsonNode plaintextNode = this.createJsonNode(plaintextJson);
        JsonNode encryptNode = plaintextNode.deepCopy();
        List<Attribute> attributesToEncrypt = this.encryptionPolicyConfiguration.getAttributesForKey(key);
        Map<String, List<Attribute>> typeAttributeMap = this.encryptionPolicyConfiguration.getTypeAttributeMap(attributesToEncrypt);
        for (String type : typeAttributeMap.keySet()) {
            List<Attribute> attributes = typeAttributeMap.get(type);
            List<String> paths = attributes.stream().map(Attribute::getJsonPath).collect(Collectors.toList());
            JsonNode jsonNode = JacksonUtils.filterJsonNodeForPaths(plaintextNode, paths);
            if (jsonNode.isEmpty(this.objectMapper.getSerializerProvider())) continue;
            JsonNode returnedEncryptedNode = this.objectMapper.valueToTree(this.encryptionServiceRestConnection.callEncrypt(tenantId, type, jsonNode));
            encryptNode = JacksonUtils.merge(returnedEncryptedNode, encryptNode);
        }
        return encryptNode;
    }

    @Override
    public <E, P> P encryptJson(Object plaintextJson, String key, String tenantId, Class<E> valueType) throws IOException {
        return ConvertClass.convertTo(this.encryptJson(plaintextJson, key, tenantId), valueType);
    }

    public JsonNode decryptJson(Object ciphertextJson, Map<Attribute, AccessType> attributeAccessTypeMap, User user) throws IOException {
        List attributesToBeDecrypted;
        List<String> pathsToBeDecrypted;
        JsonNode jsonNode;
        JsonNode ciphertextNode = this.createJsonNode(ciphertextJson);
        JsonNode decryptNode = ciphertextNode.deepCopy();
        if (attributeAccessTypeMap.containsValue((Object)AccessType.NONE)) {
            List attributesToBeRemoved = attributeAccessTypeMap.keySet().stream().filter(attribute -> attributeAccessTypeMap.get(attribute) == AccessType.NONE).collect(Collectors.toList());
            List<String> pathsToBeRemoved = attributesToBeRemoved.stream().map(Attribute::getJsonPath).collect(Collectors.toList());
            JsonNode nodeToBeEmptied = JacksonUtils.filterJsonNodeForPaths(decryptNode, pathsToBeRemoved);
            JsonNode emptyNode = JSONBrowseUtil.mapValues(nodeToBeEmptied, __ -> "Confidential Information");
            decryptNode = JacksonUtils.merge(emptyNode, decryptNode);
        }
        if (!(jsonNode = JacksonUtils.filterJsonNodeForPaths(ciphertextNode, pathsToBeDecrypted = (attributesToBeDecrypted = attributeAccessTypeMap.keySet().stream().filter(attribute -> attributeAccessTypeMap.get(attribute) != AccessType.NONE).collect(Collectors.toList())).stream().map(Attribute::getJsonPath).collect(Collectors.toList()))).isEmpty(this.objectMapper.getSerializerProvider())) {
            JsonNode returnedDecryptedNode = this.encryptionServiceRestConnection.callDecrypt(jsonNode);
            decryptNode = JacksonUtils.merge(returnedDecryptedNode, decryptNode);
        }
        if (attributeAccessTypeMap.containsValue((Object)AccessType.MASK)) {
            List<Attribute> attributesToBeMasked = attributeAccessTypeMap.keySet().stream().filter(attribute -> attributeAccessTypeMap.get(attribute) == AccessType.MASK).collect(Collectors.toList());
            decryptNode = this.maskingService.maskData(decryptNode, attributesToBeMasked);
        }
        return decryptNode;
    }

    @Override
    public JsonNode decryptJson(Object ciphertextJson, String key, User user) throws IOException {
        List<String> roles = user.getRoles().stream().map(Role::getCode).collect(Collectors.toList());
        Map<Attribute, AccessType> attributeAccessTypeMap = this.abacFilter.getAttributeAccessForRoles(roles, this.abacConfiguration.getRoleAttributeAccessListForKey(key));
        JsonNode decryptedNode = this.decryptJson(ciphertextJson, attributeAccessTypeMap, user);
        return decryptedNode;
    }

    @Override
    public <E, P> P decryptJson(Object ciphertextJson, String key, User user, Class<E> valueType) throws IOException {
        return ConvertClass.convertTo(this.decryptJson(ciphertextJson, key, user), valueType);
    }

    JsonNode createJsonNode(Object json) throws IOException {
        JsonNode jsonNode = json instanceof JsonNode ? (JsonNode)json : (json instanceof String ? this.objectMapper.readTree((String)json) : this.objectMapper.valueToTree(json));
        return jsonNode;
    }

    @Override
    public String encryptValue(Object plaintext, String tenantId, String type) throws IOException {
        return this.encryptValue(new ArrayList<Object>(Collections.singleton(plaintext)), tenantId, type).get(0);
    }

    @Override
    public List<String> encryptValue(List<Object> plaintext, String tenantId, String type) throws IOException {
        Object encryptionResponse = this.encryptionServiceRestConnection.callEncrypt(tenantId, type, plaintext);
        return (List)ConvertClass.convertTo(this.objectMapper.valueToTree(encryptionResponse), List.class);
    }
}

