/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.masking;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.egov.encryption.masking.Masking;
import org.egov.encryption.models.Attribute;
import org.egov.encryption.util.JSONBrowseUtil;
import org.egov.encryption.util.JacksonUtils;
import org.reflections.Reflections;
import org.reflections.scanners.Scanner;
import org.springframework.stereotype.Service;

@Service
public class MaskingService {
    Map<String, Masking> maskingTechniqueMap;

    @PostConstruct
    private void init() throws IllegalAccessException, InstantiationException {
        this.maskingTechniqueMap = new HashMap<String, Masking>();
        Reflections reflections = new Reflections(this.getClass().getPackage().getName(), new Scanner[0]);
        Set maskingTechniques = reflections.getSubTypesOf(Masking.class);
        for (Class maskingTechnique : maskingTechniques) {
            Masking masking = (Masking)maskingTechnique.newInstance();
            this.maskingTechniqueMap.put(masking.getMaskingTechnique(), masking);
        }
    }

    public <T> T maskData(T data, Attribute attribute) {
        Masking masking = this.maskingTechniqueMap.get(attribute.getMaskingTechnique());
        return masking.maskData(data);
    }

    public JsonNode maskData(JsonNode decryptedNode, List<Attribute> attributes) {
        JsonNode maskedNode = decryptedNode.deepCopy();
        for (Attribute attribute : attributes) {
            JsonNode jsonNode = JacksonUtils.filterJsonNodeForPaths(maskedNode, Arrays.asList(attribute.getJsonPath()));
            jsonNode = JSONBrowseUtil.mapValues(jsonNode, value -> this.maskData(value, attribute));
            maskedNode = JacksonUtils.merge(jsonNode, maskedNode);
        }
        return maskedNode;
    }
}

