/*
 * Decompiled with CFR 0.152.
 */
package org.egov.encryption.config;

import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import net.minidev.json.JSONArray;
import org.egov.common.contract.request.RequestInfo;
import org.egov.encryption.config.EncProperties;
import org.egov.encryption.models.KeyRoleAttributeAccess;
import org.egov.encryption.models.RoleAttributeAccess;
import org.egov.mdms.model.MasterDetail;
import org.egov.mdms.model.MdmsCriteria;
import org.egov.mdms.model.MdmsCriteriaReq;
import org.egov.mdms.model.MdmsResponse;
import org.egov.mdms.model.ModuleDetail;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Component;
import org.springframework.web.client.RestTemplate;

@Component
public class AbacConfiguration {
    @Autowired
    private EncProperties encProperties;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    private ObjectMapper objectMapper;
    private Map<String, List<RoleAttributeAccess>> keyRoleAttributeAccessMap;

    void initializeKeyRoleAttributeAccessMap(List<KeyRoleAttributeAccess> keyRoleAttributeAccessList) {
        this.keyRoleAttributeAccessMap = keyRoleAttributeAccessList.stream().collect(Collectors.toMap(KeyRoleAttributeAccess::getKey, KeyRoleAttributeAccess::getRoleAttributeAccessList));
    }

    @PostConstruct
    void initializeKeyRoleAttributeAccessMapFromMdms() {
        List keyRoleAttributeAccessList = null;
        try {
            MasterDetail masterDetail = MasterDetail.builder().name("DecryptionABAC").build();
            ModuleDetail moduleDetail = ModuleDetail.builder().moduleName("DataSecurity").masterDetails(Arrays.asList(masterDetail)).build();
            MdmsCriteria mdmsCriteria = MdmsCriteria.builder().tenantId(this.encProperties.getStateLevelTenantId()).moduleDetails(Arrays.asList(moduleDetail)).build();
            MdmsCriteriaReq mdmsCriteriaReq = MdmsCriteriaReq.builder().requestInfo(RequestInfo.builder().build()).mdmsCriteria(mdmsCriteria).build();
            ResponseEntity response = this.restTemplate.postForEntity(this.encProperties.getEgovMdmsHost() + this.encProperties.getEgovMdmsSearchEndpoint(), (Object)mdmsCriteriaReq, MdmsResponse.class, new Object[0]);
            JSONArray keyRoleAttributeAccessListJSON = (JSONArray)((Map)((MdmsResponse)response.getBody()).getMdmsRes().get("DataSecurity")).get("DecryptionABAC");
            ObjectReader reader = this.objectMapper.readerFor((JavaType)this.objectMapper.getTypeFactory().constructCollectionType(List.class, KeyRoleAttributeAccess.class));
            keyRoleAttributeAccessList = (List)reader.readValue(keyRoleAttributeAccessListJSON.toString());
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.initializeKeyRoleAttributeAccessMap(keyRoleAttributeAccessList);
    }

    public List<RoleAttributeAccess> getRoleAttributeAccessListForKey(String keyId) {
        return this.keyRoleAttributeAccessMap.get(keyId);
    }
}

