/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.search;

import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.entity.es.ConnectionSearchRequest;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/search/waterSearch/"})
public class CommonWaterTaxSearchController {
    private static final String COMMON_FORM_SEARCH = "waterTaxSearch-commonForm";
    private static final String INVALID_CONSUMERNUMBER = "invalid.consumernumber";
    private static final String APPLICATION_NUMBER = "applicationNo";
    private static final String MEESEVA_APPLICATION_NUMBER = "meesevaApplicationNumber";
    private static final String ERROR_MODE = "errorMode";
    private static final String CONNECTION_CLOSED = "connection.closed";
    private static final String MODE = "mode";
    private static final String APPLICATIONTYPE = "applicationType";
    private static final String ERR_MIGRATED_CONN = "err.migratedconnection.modify.notallowed";
    private static final String ERR_DATAENTRY_MODIFY = "err.modifynotallowed.collectiondone";
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDtlsService;

    @ModelAttribute
    public ConnectionSearchRequest searchRequest() {
        return new ConnectionSearchRequest();
    }

    @RequestMapping(value={"commonSearch/meterentry"}, method={RequestMethod.GET})
    public String addMeterEntry(Model model, HttpServletRequest request) {
        String meesevaApplicationNumber = request.getParameter(APPLICATION_NUMBER);
        return this.commonSearchForm(model, "METERENTRY", meesevaApplicationNumber);
    }

    @RequestMapping(value={"commonSearch/closureconnection"}, method={RequestMethod.GET})
    public String closeWaterConnection(Model model, HttpServletRequest request) {
        String meesevaApplicationNumber = request.getParameter(APPLICATION_NUMBER);
        return this.commonSearchForm(model, "CLOSURECONNECTION", meesevaApplicationNumber);
    }

    @RequestMapping(value={"commonSearch/changeofuse"}, method={RequestMethod.GET})
    public String waterConnectionChangeOfUsage(Model model, HttpServletRequest request) {
        String meesevaApplicationNumber = request.getParameter(APPLICATION_NUMBER);
        return this.commonSearchForm(model, "CHANGEOFUSE", meesevaApplicationNumber);
    }

    @RequestMapping(value={"commonSearch/additionalconnection"}, method={RequestMethod.GET})
    public String getAdditionalWaterConnection(Model model, HttpServletRequest request) {
        String meesevaApplicationNumber = request.getParameter(APPLICATION_NUMBER);
        return this.commonSearchForm(model, "ADDNLCONNECTION", meesevaApplicationNumber);
    }

    @RequestMapping(value={"commonSearch/collecttax"}, method={RequestMethod.GET})
    public String collectTax(Model model, HttpServletRequest request) {
        String meesevaApplicationNumber = request.getParameter(APPLICATION_NUMBER);
        return this.commonSearchForm(model, "COLLECTTAX", meesevaApplicationNumber);
    }

    @RequestMapping(value={"commonSearch/reconnection"}, method={RequestMethod.GET})
    public String getReconnectionForm(Model model, HttpServletRequest request) {
        String meesevaApplicationNumber = request.getParameter(APPLICATION_NUMBER);
        return this.commonSearchForm(model, "RECONNECTION", meesevaApplicationNumber);
    }

    @RequestMapping(value={"commonSearch/editcollection"}, method={RequestMethod.GET})
    public String editCollection(Model model, HttpServletRequest request) {
        String meesevaApplicationNumber = request.getParameter(APPLICATION_NUMBER);
        return this.commonSearchForm(model, "EDITCOLLECTION", meesevaApplicationNumber);
    }

    @RequestMapping(value={"commonSearch/dataentryedit"}, method={RequestMethod.GET})
    public String editDataEntry(Model model, HttpServletRequest request) {
        String meesevaApplicationNumber = request.getParameter(APPLICATION_NUMBER);
        return this.commonSearchForm(model, "DATAENTRYEDIT", meesevaApplicationNumber);
    }

    @RequestMapping(value={"commonSearch/generatebill"}, method={RequestMethod.GET})
    public String generateBill(Model model, HttpServletRequest request) {
        String meesevaApplicationNumber = request.getParameter(APPLICATION_NUMBER);
        return this.commonSearchForm(model, "GENERATEBILL", meesevaApplicationNumber);
    }

    @RequestMapping(value={"commonSearch/editdemand"}, method={RequestMethod.GET})
    public String editDemand(Model model, HttpServletRequest request) {
        String meesevaApplicationNumber = request.getParameter(APPLICATION_NUMBER);
        return this.commonSearchForm(model, "EDITDEMAND", meesevaApplicationNumber);
    }

    public String commonSearchForm(Model model, String applicationType, String meesevaApplicationNumber) {
        model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
        model.addAttribute(MEESEVA_APPLICATION_NUMBER, (Object)meesevaApplicationNumber);
        return COMMON_FORM_SEARCH;
    }

    @RequestMapping(value={"commonSearch-form/"}, method={RequestMethod.POST})
    public String searchConnectionSubmit(@ModelAttribute ConnectionSearchRequest searchRequest, BindingResult resultBinder, Model model, HttpServletRequest request) {
        WaterConnectionDetails waterConnectionDetails = null;
        String applicationType = request.getParameter(APPLICATIONTYPE);
        if (searchRequest.getMeesevaApplicationNumber() != null) {
            model.addAttribute(MEESEVA_APPLICATION_NUMBER, (Object)searchRequest.getMeesevaApplicationNumber());
        }
        if ((waterConnectionDetails = applicationType != null && applicationType.equals("RECONNECTION") ? this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(searchRequest.getConsumerCode(), ConnectionStatus.CLOSED) : this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(searchRequest.getConsumerCode(), ConnectionStatus.ACTIVE)) == null) {
            resultBinder.rejectValue("consumerCode", INVALID_CONSUMERNUMBER);
            model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("ADDNLCONNECTION")) {
            if (waterConnectionDetails.getCloseConnectionType() != null && waterConnectionDetails.getCloseConnectionType().equals("P")) {
                model.addAttribute(MODE, (Object)ERROR_MODE);
                model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
                resultBinder.rejectValue("consumerCode", CONNECTION_CLOSED);
                return COMMON_FORM_SEARCH;
            }
            if (("CHANGEOFUSE".equals(waterConnectionDetails.getApplicationType().getCode()) || "NEWCONNECTION".equals(waterConnectionDetails.getApplicationType().getCode()) || "RECONNECTION".equals(waterConnectionDetails.getApplicationType().getCode())) && ConnectionStatus.ACTIVE.equals((Object)waterConnectionDetails.getConnectionStatus())) {
                return "redirect:/application/addconnection/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute(MODE, (Object)ERROR_MODE);
            model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
            resultBinder.rejectValue("consumerCode", INVALID_CONSUMERNUMBER);
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("CHANGEOFUSE")) {
            if (waterConnectionDetails.getCloseConnectionType() != null && waterConnectionDetails.getCloseConnectionType().equals("P")) {
                model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
                model.addAttribute(MODE, (Object)ERROR_MODE);
                resultBinder.rejectValue("consumerCode", CONNECTION_CLOSED);
                return COMMON_FORM_SEARCH;
            }
            if ((waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE") || "RECONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE)) {
                return "redirect:/application/changeOfUse/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
            model.addAttribute(MODE, (Object)ERROR_MODE);
            resultBinder.rejectValue("consumerCode", INVALID_CONSUMERNUMBER);
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("CLOSURECONNECTION")) {
            if (waterConnectionDetails.getCloseConnectionType() != null && waterConnectionDetails.getCloseConnectionType().equals("P")) {
                model.addAttribute(MODE, (Object)ERROR_MODE);
                model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
                resultBinder.rejectValue("consumerCode", CONNECTION_CLOSED);
                return COMMON_FORM_SEARCH;
            }
            if ((waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE") || waterConnectionDetails.getApplicationType().getCode().equals("RECONNECTION")) && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE)) {
                return "redirect:/application/close/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute(MODE, (Object)ERROR_MODE);
            model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
            resultBinder.rejectValue("consumerCode", INVALID_CONSUMERNUMBER);
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("RECONNECTION")) {
            if (waterConnectionDetails.getCloseConnectionType() != null && waterConnectionDetails.getCloseConnectionType().equals("P")) {
                model.addAttribute(MODE, (Object)ERROR_MODE);
                model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
                resultBinder.rejectValue("consumerCode", CONNECTION_CLOSED);
                return COMMON_FORM_SEARCH;
            }
            if (waterConnectionDetails.getApplicationType().getCode().equals("CLOSINGCONNECTION") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.CLOSED) && waterConnectionDetails.getStatus().getCode().equals("CLOSERSANCTIONED") && waterConnectionDetails.getCloseConnectionType().equals("T")) {
                return "redirect:/application/reconnection/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute(MODE, (Object)ERROR_MODE);
            model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
            resultBinder.rejectValue("consumerCode", INVALID_CONSUMERNUMBER);
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("METERENTRY")) {
            if ((waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE")) && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE) && waterConnectionDetails.getConnectionType().name().equals("METERED")) {
                return "redirect:/application/meterentry/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute(MODE, (Object)ERROR_MODE);
            model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
            resultBinder.rejectValue("consumerCode", INVALID_CONSUMERNUMBER);
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("DATAENTRYEDIT")) {
            if ((waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION")) && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE) && waterConnectionDetails.getLegacy().booleanValue()) {
                WaterConnectionDetails connectionDetails = this.waterConnectionDtlsService.findByApplicationNumberOrConsumerCode(waterConnectionDetails.getConnection().getConsumerCode());
                if (connectionDetails != null) {
                    BigDecimal arrearBalance;
                    if ("Migrated Connection".equalsIgnoreCase(connectionDetails.getConnectionReason())) {
                        model.addAttribute(MODE, (Object)ERROR_MODE);
                        model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
                        resultBinder.rejectValue("consumerCode", ERR_MIGRATED_CONN);
                        return COMMON_FORM_SEARCH;
                    }
                    BigDecimal demand = this.waterConnectionDetailsService.getTotalDemandTillCurrentFinYear(connectionDetails);
                    if (demand.compareTo(arrearBalance = this.waterConnectionDetailsService.getTotalAmount(connectionDetails)) > 0) {
                        model.addAttribute(MODE, (Object)ERROR_MODE);
                        model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
                        resultBinder.rejectValue("consumerCode", ERR_DATAENTRY_MODIFY);
                        return COMMON_FORM_SEARCH;
                    }
                }
                return "redirect:/application/newConnection-editExisting/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute(MODE, (Object)ERROR_MODE);
            model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
            resultBinder.rejectValue("consumerCode", INVALID_CONSUMERNUMBER);
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("COLLECTTAX")) {
            AssessmentDetails assessmentDetails;
            BigDecimal amoutToBeCollected = BigDecimal.ZERO;
            if (null != this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand()) {
                amoutToBeCollected = this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails);
            }
            if ((assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL)) != null) {
                if (amoutToBeCollected.doubleValue() == 0.0) {
                    throw new ApplicationRuntimeException("invalid.collecttax");
                }
                if ((amoutToBeCollected.doubleValue() > 0.0 && waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.METERED) || waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.NON_METERED)) && (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE") || waterConnectionDetails.getApplicationType().getCode().equals("RECONNECTION")) && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE)) {
                    return "redirect:/application/generatebill/" + waterConnectionDetails.getConnection().getConsumerCode();
                }
                model.addAttribute(MODE, (Object)ERROR_MODE);
                model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
                resultBinder.rejectValue("consumerCode", INVALID_CONSUMERNUMBER);
                return COMMON_FORM_SEARCH;
            }
        }
        if (applicationType != null && applicationType.equals("EDITCOLLECTION")) {
            if (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE) && waterConnectionDetails.getLegacy().booleanValue()) {
                return "redirect:/application/editCollection/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute(MODE, (Object)ERROR_MODE);
            model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
            resultBinder.rejectValue("consumerCode", INVALID_CONSUMERNUMBER);
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("GENERATEBILL")) {
            if (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE) && waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.NON_METERED)) {
                return "redirect:/report/generateBillForHSCNo/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute(MODE, (Object)ERROR_MODE);
            model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
            resultBinder.rejectValue("consumerCode", INVALID_CONSUMERNUMBER);
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("EDITDEMAND")) {
            if (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE) && waterConnectionDetails.getLegacy().booleanValue()) {
                return "redirect:/application/editDemand/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute(MODE, (Object)ERROR_MODE);
            model.addAttribute(APPLICATIONTYPE, (Object)applicationType);
            resultBinder.rejectValue("consumerCode", INVALID_CONSUMERNUMBER);
            return COMMON_FORM_SEARCH;
        }
        return "";
    }
}

