/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.egov.wtms.application.entity.DonationChargesDCBReportSearch;
import org.egov.wtms.application.service.CurrentDcbService;
import org.egov.wtms.reports.entity.DonationChargeDCBReportAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class ViewWaterTaxDonationController {
    @Autowired
    private CurrentDcbService currentDcbService;
    @Autowired
    private DonationChargeDCBReportAdaptor donationChargeDCBReportAdaptor;

    @GetMapping(value={"/search-donation"})
    public String searchDonation(@ModelAttribute DonationChargesDCBReportSearch donationChargesDCBReportSearch) {
        return "search-donation";
    }

    @PostMapping(value={"/view-donation"}, produces={"text/plain"})
    @ResponseBody
    public String getDonationResult(@ModelAttribute DonationChargesDCBReportSearch donationChargesDCBReportSearch, HttpServletResponse response) throws IOException {
        ArrayList<DonationChargesDCBReportSearch> resultList = new ArrayList<DonationChargesDCBReportSearch>();
        List dcbList = new ArrayList();
        dcbList = this.currentDcbService.getDonationDCBReportDetails(donationChargesDCBReportSearch);
        for (Object[] object : dcbList) {
            DonationChargesDCBReportSearch dcbObject = new DonationChargesDCBReportSearch();
            if (object[0] != null) {
                dcbObject.setConsumerCode(object[0].toString());
            }
            if (object[1] != null) {
                dcbObject.setAssessmentNumber(object[1].toString());
            }
            if (object[2] != null) {
                dcbObject.setOwnerName(object[2].toString());
            }
            if (object[3] != null) {
                dcbObject.setMobileNumber(object[3].toString());
            }
            if (object[4] != null) {
                dcbObject.setPropertyAddress(object[4].toString());
            }
            if (object[5] != null) {
                dcbObject.setTotalDonationAmount(new BigDecimal(object[5].toString()));
            }
            if (object[6] != null) {
                dcbObject.setPaidDonationAmount(new BigDecimal(object[6].toString()));
            }
            if (object[7] != null) {
                dcbObject.setBalanceDonationAmount(new BigDecimal(object[7].toString()));
            }
            resultList.add(dcbObject);
        }
        String result = "{ \"data\":" + this.toSearchLineEstimatesToCancelJson(resultList) + "}";
        return result;
    }

    public Object toSearchLineEstimatesToCancelJson(Object object) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        Gson gson = gsonBuilder.registerTypeAdapter(DonationChargesDCBReportSearch.class, (Object)this.donationChargeDCBReportAdaptor).create();
        String json = gson.toJson(object);
        return json;
    }
}

