/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ValidationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.repository.FileStoreMapperRepository;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.JsonUtils;
import org.egov.wtms.application.entity.SearchNoticeDetails;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.SearchNoticeService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.ApplicationType;
import org.egov.wtms.masters.entity.PropertyType;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.masters.service.PropertyTypeService;
import org.egov.wtms.reports.entity.SearchNoticeAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/notice/search"})
public class SearchNoticeController {
    private static final String REVENUEWARD = "revenueWard";
    private static final String APPLICATION_TYPE = "applicationType";
    private static final String PROPERTY_TYPE = "propertyType";
    private static final String CONNECTION_TYPE = "connectionType";
    private static final String ASSESSMENT_NUMBER = "assessmentNumber";
    private static final String HOUSE_NUMBER = "houseNumber";
    private static final String EXCEPTION_IN_ADDFILESTOZIP = "Exception in addFilesToZip : ";
    private static final String NOTICE_TYPE = "noticeType";
    private static final String FROMDATE = "fromDate";
    private static final String TODATE = "toDate";
    private static final String SANCTION_ORDER = "Sanction Order";
    private static final String DEMAND_BILL = "Demand Bill";
    @Autowired
    private PropertyTypeService propertyTypeService;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private SearchNoticeService searchNoticeService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private FileStoreMapperRepository fileStoreMapperRepository;
    private static final Logger LOGGER = Logger.getLogger(SearchNoticeController.class);

    @RequestMapping(method={RequestMethod.GET})
    public String search(Model model) {
        return "searchnotice-report";
    }

    @ModelAttribute
    public SearchNoticeDetails reportModel() {
        return new SearchNoticeDetails();
    }

    @ModelAttribute(value="zones")
    public List<Boundary> zones() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
    }

    @ModelAttribute(value="revenueWards")
    public List<Boundary> revenueWardList() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE");
    }

    @ModelAttribute(value="connectionTypes")
    public Map<String, String> connectionTypes() {
        return this.waterConnectionDetailsService.getNonMeteredConnectionTypesMap();
    }

    @ModelAttribute(value="propertyTypes")
    public List<PropertyType> propertyTypes() {
        return this.propertyTypeService.getAllActivePropertyTypes();
    }

    @ModelAttribute(value="applicationTypes")
    public List<ApplicationType> applicationTypes() {
        return this.applicationTypeService.findAll();
    }

    @ModelAttribute(value="noticetypeList")
    public List<String> getNoticeTypes() {
        ArrayList<String> noticeList = new ArrayList<String>();
        noticeList.add(DEMAND_BILL);
        noticeList.add(SANCTION_ORDER);
        return noticeList;
    }

    @RequestMapping(value={"/result"}, method={RequestMethod.POST}, produces={"application/json"})
    @ResponseBody
    public void searchResult(SearchNoticeDetails searchNoticeDetails, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String result = null;
        List generateConnectionBillList = new ArrayList();
        if (request.getParameter(NOTICE_TYPE) != null) {
            if (DEMAND_BILL.equals(request.getParameter(NOTICE_TYPE))) {
                generateConnectionBillList = this.searchNoticeService.getBillReportDetails(searchNoticeDetails, request.getParameter("zone"), request.getParameter(REVENUEWARD), request.getParameter(PROPERTY_TYPE), request.getParameter(APPLICATION_TYPE), request.getParameter(CONNECTION_TYPE), request.getParameter("consumerCode"), request.getParameter(HOUSE_NUMBER), request.getParameter(ASSESSMENT_NUMBER), request.getParameter(FROMDATE), request.getParameter(TODATE));
            } else if (SANCTION_ORDER.equals(request.getParameter(NOTICE_TYPE))) {
                generateConnectionBillList = this.searchNoticeService.getSanctionOrderDetails(searchNoticeDetails, request.getParameter("zone"), request.getParameter(REVENUEWARD), request.getParameter(PROPERTY_TYPE), request.getParameter(APPLICATION_TYPE), request.getParameter(CONNECTION_TYPE), request.getParameter("consumerCode"), request.getParameter(HOUSE_NUMBER), request.getParameter(ASSESSMENT_NUMBER), request.getParameter(FROMDATE), request.getParameter(TODATE));
            }
        }
        long foundRows = this.searchNoticeService.getTotalCountofBills(request.getParameter("zone"), request.getParameter(REVENUEWARD), request.getParameter(PROPERTY_TYPE), request.getParameter(APPLICATION_TYPE), request.getParameter(CONNECTION_TYPE), request.getParameter("consumerCode"), request.getParameter(HOUSE_NUMBER), request.getParameter(ASSESSMENT_NUMBER));
        int count = generateConnectionBillList.size();
        LOGGER.info((Object)("Total count of records-->" + Long.valueOf(count)));
        result = "{ \"draw\":" + request.getParameter("draw") + ", \"recordsTotal\":" + foundRows + ", \"recordsFiltered\":" + foundRows + ", \"data\":" + JsonUtils.toJSON(generateConnectionBillList, SearchNoticeDetails.class, SearchNoticeAdaptor.class) + ", \"recordsCount\":" + Long.valueOf(count) + "}";
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }

    @RequestMapping(value={"/result"}, method={RequestMethod.GET})
    public void getBillBySearchParameter(HttpServletRequest request, HttpServletResponse response, @RequestParam(value="consumerCode") String consumerCode, @RequestParam(value="noticeType") String noticeType, @RequestParam(value="billNo") String billNo, @RequestParam(value="workOrderNumber") String workOrderNumber) {
        ArrayList<String> waterChargesFileStoreId = new ArrayList<String>();
        if (SANCTION_ORDER.equals(noticeType)) {
            WaterConnectionDetails waterConnectionDetails = this.getWaterConnectionDetails(consumerCode);
            if (waterConnectionDetails != null) {
                waterChargesFileStoreId.add(waterConnectionDetails.getFileStore() != null ? waterConnectionDetails.getFileStore().getFileStoreId() : null);
            }
        } else {
            List waterChargesDocumentslist = this.searchNoticeService.getDocuments(consumerCode, this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(consumerCode).getApplicationType().getName());
            waterChargesFileStoreId.add(waterChargesDocumentslist.get(0) + "");
        }
        this.getDemandBillByFileStoreId(waterChargesFileStoreId, consumerCode, response);
    }

    @RequestMapping(value={"/mergeAndDownload"}, method={RequestMethod.GET})
    public String mergeAndDownload(SearchNoticeDetails searchNoticeDetails, HttpServletRequest request, HttpServletResponse response) {
        long startTime = System.currentTimeMillis();
        String noticeType = request.getParameter(NOTICE_TYPE);
        List searchResultList = noticeType != null && DEMAND_BILL.equalsIgnoreCase(noticeType) ? this.searchNoticeService.getBillReportDetails(searchNoticeDetails, request.getParameter("zone"), request.getParameter(REVENUEWARD), request.getParameter(PROPERTY_TYPE), request.getParameter(APPLICATION_TYPE), request.getParameter(CONNECTION_TYPE), request.getParameter("consumerCode"), request.getParameter(HOUSE_NUMBER), request.getParameter(ASSESSMENT_NUMBER), request.getParameter(FROMDATE), request.getParameter(TODATE)) : this.searchNoticeService.getSanctionOrderDetails(searchNoticeDetails, request.getParameter("zone"), request.getParameter(REVENUEWARD), request.getParameter(PROPERTY_TYPE), request.getParameter(APPLICATION_TYPE), request.getParameter(CONNECTION_TYPE), request.getParameter("consumerCode"), request.getParameter(HOUSE_NUMBER), request.getParameter(ASSESSMENT_NUMBER), request.getParameter(FROMDATE), request.getParameter(TODATE));
        this.mergeAndDownloadNotice(searchResultList, response);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of Bills : " + (searchResultList != null ? Integer.valueOf(searchResultList.size()) : BigDecimal.ZERO)));
        }
        long endTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("GenerateBill | mergeAndDownload | Time taken(ms) " + (endTime - startTime)));
            LOGGER.debug((Object)"Exit from mergeAndDownload method");
        }
        return null;
    }

    private HttpServletResponse getServletResponse(HttpServletResponse response, List<InputStream> pdfs, String filename) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] data = this.concatPDFs(pdfs, output);
            response.setHeader("Content-disposition", "attachment;filename=" + filename + ".pdf");
            response.setContentType("application/pdf");
            response.setContentLength(data.length);
            response.getOutputStream().write(data);
            return response;
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] concatPDFs(List<InputStream> streamOfPDFFiles, ByteArrayOutputStream outputStream) {
        Document document = null;
        try {
            List<InputStream> pdfs = streamOfPDFFiles;
            ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
            for (InputStream pdf : pdfs) {
                PdfReader pdfReader = new PdfReader(pdf);
                readers.add(pdfReader);
                if (null != document) continue;
                document = new Document(pdfReader.getPageSize(1));
            }
            PdfWriter writer = PdfWriter.getInstance(document, (OutputStream)outputStream);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            int pageOfCurrentReaderPDF = 0;
            for (PdfReader pdfReader : readers) {
                while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
                    document.newPage();
                    PdfImportedPage page = writer.getImportedPage(pdfReader, ++pageOfCurrentReaderPDF);
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                }
                pageOfCurrentReaderPDF = 0;
            }
            outputStream.flush();
            document.close();
            outputStream.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception in concat PDFs : ", (Throwable)e);
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ioe) {
                LOGGER.error((Object)"Exception in concat PDFs : ", (Throwable)ioe);
            }
        }
        return outputStream != null ? outputStream.toByteArray() : null;
    }

    @RequestMapping(value={"/zipAndDownload"}, method={RequestMethod.GET})
    public String zipAndDownload(SearchNoticeDetails searchNoticeDetails, HttpServletRequest request, HttpServletResponse response) throws IOException {
        String noticeType = request.getParameter(NOTICE_TYPE);
        long startTime = System.currentTimeMillis();
        List noticeList = DEMAND_BILL.equalsIgnoreCase(noticeType) ? this.searchNoticeService.getBillReportDetails(searchNoticeDetails, request.getParameter("zone"), request.getParameter(REVENUEWARD), request.getParameter(PROPERTY_TYPE), request.getParameter(APPLICATION_TYPE), request.getParameter(CONNECTION_TYPE), request.getParameter("consumerCode"), request.getParameter(HOUSE_NUMBER), request.getParameter(ASSESSMENT_NUMBER), request.getParameter(FROMDATE), request.getParameter(TODATE)) : this.searchNoticeService.getSanctionOrderDetails(searchNoticeDetails, request.getParameter("zone"), request.getParameter(REVENUEWARD), request.getParameter(PROPERTY_TYPE), request.getParameter(APPLICATION_TYPE), request.getParameter(CONNECTION_TYPE), request.getParameter("consumerCode"), request.getParameter(HOUSE_NUMBER), request.getParameter(ASSESSMENT_NUMBER), request.getParameter(FROMDATE), request.getParameter(TODATE));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of Bills : " + (noticeList != null ? Integer.valueOf(noticeList.size()) : BigDecimal.ZERO)));
        }
        try {
            this.zipAndDownloadNotice(noticeList, response);
        }
        catch (IOException e) {
            LOGGER.error((Object)"Exception in Zip and Download : ", (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("GenerateBill | zipAndDownload | Time taken(ms) " + (endTime - startTime)));
            LOGGER.debug((Object)"Exit from zipAndDownload method");
        }
        return null;
    }

    public void zipAndDownloadNotice(List<SearchNoticeDetails> noticeList, HttpServletResponse response) throws IOException {
        ZipOutputStream zipOutputStream = null;
        if (null != noticeList && noticeList.size() >= 0) {
            zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
            response.setHeader("Content-disposition", "attachment;filename=searchbill.zip");
            response.setContentType("application/zip");
        }
        for (SearchNoticeDetails connectionbill : noticeList) {
            try {
                WaterConnectionDetails waterConnectionDetails = this.getWaterConnectionDetails(connectionbill.getHscNo());
                if (waterConnectionDetails == null || waterConnectionDetails.getFileStore() == null) continue;
                FileStoreMapper fsm = this.fileStoreMapperRepository.findByFileStoreId(waterConnectionDetails.getFileStore().getFileStoreId());
                File file = this.fileStoreService.fetch(fsm, "WTMS");
                byte[] bFile = FileUtils.readFileToByteArray((File)file);
                zipOutputStream = this.addFilesToZip((InputStream)new ByteArrayInputStream(bFile), file.getName(), zipOutputStream);
            }
            catch (Exception e) {
                LOGGER.error((Object)"zipAndDownload : Getting demand notice failed ", (Throwable)e);
            }
        }
        if (zipOutputStream != null) {
            zipOutputStream.closeEntry();
            zipOutputStream.close();
        }
    }

    public void mergeAndDownloadNotice(List<SearchNoticeDetails> searchResultList, HttpServletResponse response) {
        ArrayList<ByteArrayInputStream> pdfs = new ArrayList<ByteArrayInputStream>();
        for (SearchNoticeDetails connectionbill : searchResultList) {
            if (connectionbill == null) continue;
            try {
                WaterConnectionDetails waterConnectionDetails = this.getWaterConnectionDetails(connectionbill.getHscNo());
                if (waterConnectionDetails == null || waterConnectionDetails.getFileStore() == null) continue;
                FileStoreMapper fsm = this.fileStoreMapperRepository.findByFileStoreId(waterConnectionDetails.getFileStore().getFileStoreId());
                File file = this.fileStoreService.fetch(fsm, "WTMS");
                byte[] bFile = FileUtils.readFileToByteArray((File)file);
                pdfs.add(new ByteArrayInputStream(bFile));
            }
            catch (Exception e) {
                LOGGER.debug((Object)("Entered into executeJob" + e));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of pdfs : " + (pdfs != null ? Integer.valueOf(pdfs.size()) : BigDecimal.ZERO)));
        }
        if (pdfs.isEmpty()) {
            throw new ValidationException("err.demand.notice");
        }
        this.getServletResponse(response, pdfs, "search_bill");
    }

    private ZipOutputStream addFilesToZip(InputStream inputStream, String noticeNo, ZipOutputStream out) {
        byte[] buffer = new byte[1024];
        try {
            int len;
            out.setLevel(-1);
            out.putNextEntry(new ZipEntry(noticeNo.replaceAll("/", "_")));
            while ((len = inputStream.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            inputStream.close();
        }
        catch (IllegalArgumentException iae) {
            LOGGER.error((Object)EXCEPTION_IN_ADDFILESTOZIP, (Throwable)iae);
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.error((Object)EXCEPTION_IN_ADDFILESTOZIP, (Throwable)fnfe);
        }
        catch (IOException ioe) {
            LOGGER.error((Object)EXCEPTION_IN_ADDFILESTOZIP, (Throwable)ioe);
        }
        return out;
    }

    public void getDemandBillByFileStoreId(List<String> waterChargesFileStoreId, String consumerCode, HttpServletResponse response) {
        if (!waterChargesFileStoreId.isEmpty() && waterChargesFileStoreId.get(0) != null) {
            try {
                FileStoreMapper fsm = this.fileStoreMapperRepository.findByFileStoreId(waterChargesFileStoreId.get(0) + "");
                ArrayList<ByteArrayInputStream> pdfs = new ArrayList<ByteArrayInputStream>();
                File file = this.fileStoreService.fetch(fsm, "WTMS");
                byte[] bFile = FileUtils.readFileToByteArray((File)file);
                pdfs.add(new ByteArrayInputStream(bFile));
                this.getServletResponse(response, pdfs, consumerCode);
            }
            catch (Exception e) {
                throw new ValidationException(e.getMessage());
            }
        } else {
            throw new ValidationException("err.demand.notice");
        }
    }

    public WaterConnectionDetails getWaterConnectionDetails(String consumerCode) {
        WaterConnectionDetails waterConnectionDetails = null;
        waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.INPROGRESS);
        if (waterConnectionDetails == null) {
            waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
        }
        if (waterConnectionDetails != null && (waterConnectionDetails.getStatus().getCode().equals("APPROVED") || waterConnectionDetails.getStatus().getCode().equals("SANCTIONED"))) {
            return waterConnectionDetails;
        }
        return null;
    }
}

