/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import java.io.IOException;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.wtms.application.entity.InstDmdCollResponse;
import org.egov.wtms.application.entity.WaterChargeMaterlizeView;
import org.egov.wtms.application.service.ArrearRegisterReportService;
import org.egov.wtms.reports.entity.ArrearRegisterReport;
import org.egov.wtms.reports.entity.ArrearReportInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/reports/arrear"})
public class ArrearRegisterReportController {
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ArrearRegisterReportService arrearRegisterReportService;

    @ModelAttribute(value="zones")
    public List<Boundary> zones() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
    }

    @ModelAttribute(value="wards")
    public List<Boundary> wards() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @ModelAttribute
    public void getReportHelper(Model model) {
        ArrearRegisterReport reportHealperObj = new ArrearRegisterReport();
        model.addAttribute("reportHelper", (Object)reportHealperObj);
    }

    @ModelAttribute(value="localitys")
    public List<Boundary> localitys() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION");
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/arrearReportList"})
    public String searchNoOfConnectionByBoundaryForm(Model model) {
        model.addAttribute("currDate", (Object)new Date());
        return "arrearRegister-report";
    }

    @RequestMapping(value={"/arrearReport"}, method={RequestMethod.POST})
    public String springPaginationDataTablesUpdate(HttpServletRequest request, @ModelAttribute ArrearRegisterReport reportHealperObj, HttpSession session, Model model, HttpServletResponse response) throws IOException {
        ArrayList<ArrearRegisterReport> propertyWiseInfoList = new ArrayList<ArrearRegisterReport>();
        ArrayList<ArrearReportInfo> arrearReportInfoList = new ArrayList<ArrearReportInfo>();
        new ArrearReportInfo();
        Long strZoneNum = null;
        Long strWardNum = null;
        Long strLocalityNum = null;
        if (reportHealperObj.getZone() != null) {
            strZoneNum = Long.valueOf(reportHealperObj.getZone());
        }
        if (reportHealperObj.getWard() != null) {
            strWardNum = Long.valueOf(reportHealperObj.getWard());
        }
        if (reportHealperObj.getLocality() != null) {
            strLocalityNum = Long.valueOf(reportHealperObj.getLocality());
        }
        List propertyViewList = this.arrearRegisterReportService.prepareQueryforArrearRegisterReport(strZoneNum, strWardNum, strLocalityNum);
        for (WaterChargeMaterlizeView propMatView : propertyViewList) {
            ArrearReportInfo arrearReportInfoObj = new ArrearReportInfo();
            arrearReportInfoObj.setBasicPropId(propMatView.getConnectiondetailsid());
            arrearReportInfoObj.setIndexNumber(propMatView.getHscno());
            arrearReportInfoObj.setOwnerName(propMatView.getUsername());
            arrearReportInfoObj.setHouseNo(propMatView.getHouseno());
            if (propMatView.getInstDmdColl().size() == 1) {
                InstDmdCollResponse currIDCMatView = (InstDmdCollResponse)propMatView.getInstDmdColl().iterator().next();
                ArrearRegisterReport propertyWiseInfo = this.preparePropertyWiseInfo(currIDCMatView);
                if (propertyWiseInfo != null) {
                    propertyWiseInfoList.add(propertyWiseInfo);
                }
            } else {
                ArrayList idcList = new ArrayList(propMatView.getInstDmdColl());
                ArrayList<String> unitList = new ArrayList<String>();
                ArrearRegisterReport propertyWiseInfoTotal = null;
                for (InstDmdCollResponse instlDmdColMatView : idcList) {
                    ArrearRegisterReport propertyWiseInfo = this.preparePropertyWiseInfo(instlDmdColMatView);
                    if (propertyWiseInfo != null) {
                        if (unitList.isEmpty()) {
                            unitList.add(propertyWiseInfo.getArrearInstallmentDesc());
                            propertyWiseInfoTotal = propertyWiseInfo;
                            continue;
                        }
                        if (unitList.contains(propertyWiseInfo.getArrearInstallmentDesc())) {
                            propertyWiseInfoTotal = this.addPropertyWiseInfo(propertyWiseInfoTotal, propertyWiseInfo);
                            continue;
                        }
                        if (unitList.contains(propertyWiseInfo.getArrearInstallmentDesc())) continue;
                        propertyWiseInfoList.add(propertyWiseInfoTotal);
                        unitList.add(propertyWiseInfo.getArrearInstallmentDesc());
                        propertyWiseInfoTotal = propertyWiseInfo;
                        continue;
                    }
                    propertyWiseInfoList.add(propertyWiseInfoTotal);
                }
            }
            arrearReportInfoObj.getPropertyWiseArrearInfoList().addAll(propertyWiseInfoList);
            arrearReportInfoList.add(arrearReportInfoObj);
        }
        model.addAttribute("arrearReportInfoList", arrearReportInfoList);
        model.addAttribute("reportHelper", (Object)reportHealperObj);
        return "arrearRegister-report";
    }

    private ArrearRegisterReport addPropertyWiseInfo(ArrearRegisterReport propertyWiseInfoTotal, ArrearRegisterReport propertyInfo) {
        propertyWiseInfoTotal.setArrearLibraryCess(propertyWiseInfoTotal.getWaterCharge().add(propertyInfo.getWaterCharge()));
        propertyWiseInfoTotal.setArrearPropertyTax(propertyWiseInfoTotal.getWaterChargeColl().add(propertyInfo.getWaterChargeColl()));
        propertyWiseInfoTotal.setTotalArrearTax(propertyWiseInfoTotal.getTotalArrearTax().add(propertyInfo.getTotalArrearTax()));
        return propertyWiseInfoTotal;
    }

    private ArrearRegisterReport preparePropertyWiseInfo(InstDmdCollResponse currInstDmdColMatView) {
        ArrearRegisterReport propertyWiseInfo = new ArrearRegisterReport();
        Double totalTax = currInstDmdColMatView.getWaterCharge();
        propertyWiseInfo.setArrearInstallmentDesc(currInstDmdColMatView.getInstallment().getDescription());
        propertyWiseInfo.setWaterCharge(BigDecimal.valueOf(currInstDmdColMatView.getWaterCharge()));
        propertyWiseInfo.setWaterChargeColl(BigDecimal.valueOf(currInstDmdColMatView.getWaterchargecoll()));
        propertyWiseInfo.setTotalArrearTax(BigDecimal.valueOf(totalTax));
        return propertyWiseInfo;
    }

    private ArrearRegisterReport preparePropInfo(WaterChargeMaterlizeView propMatView) {
        ArrearRegisterReport propertyWiseInfo = new ArrearRegisterReport();
        propertyWiseInfo.setBasicPropId(propMatView.getConnectiondetailsid());
        propertyWiseInfo.setIndexNumber(propMatView.getHscno());
        propertyWiseInfo.setOwnerName(propMatView.getUsername());
        propertyWiseInfo.setHouseNo(propMatView.getHouseno());
        return propertyWiseInfo;
    }
}

