/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.masters;

import java.util.List;
import javax.validation.Valid;
import org.egov.wtms.masters.entity.PropertyCategory;
import org.egov.wtms.masters.service.ConnectionCategoryService;
import org.egov.wtms.masters.service.PropertyCategoryService;
import org.egov.wtms.masters.service.PropertyTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class PropertyCategoryMasterController {
    private final PropertyTypeService propertyTypeService;
    private final ConnectionCategoryService connectionCategoryService;
    private final PropertyCategoryService propertyCategoryService;

    @Autowired
    public PropertyCategoryMasterController(PropertyTypeService propertyTypeService, ConnectionCategoryService connectionCategoryService, PropertyCategoryService propertyCategoryService) {
        this.propertyTypeService = propertyTypeService;
        this.connectionCategoryService = connectionCategoryService;
        this.propertyCategoryService = propertyCategoryService;
    }

    @RequestMapping(value={"/propertyCategoryMaster"}, method={RequestMethod.GET})
    public String viewForm(Model model) {
        PropertyCategory propertyCategory = new PropertyCategory();
        model.addAttribute("propertyCategory", (Object)propertyCategory);
        model.addAttribute("propertyType", (Object)this.propertyTypeService.getAllActivePropertyTypes());
        model.addAttribute("connectionCategory", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
        model.addAttribute("reqAttr", (Object)"false");
        model.addAttribute("mode", (Object)"create");
        return "property-category-master";
    }

    @RequestMapping(value={"/propertyCategoryMaster"}, method={RequestMethod.POST})
    public String createPropertyCategoryMasterData(@Valid @ModelAttribute PropertyCategory propertyCategory, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute("propertyType", (Object)this.propertyTypeService.getAllActivePropertyTypes());
            model.addAttribute("connectionCategory", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
            return "property-category-master";
        }
        this.propertyCategoryService.createPropertyCategory(propertyCategory);
        redirectAttrs.addFlashAttribute("propertyCategory", (Object)propertyCategory);
        model.addAttribute("message", (Object)"Property Category created successfully.");
        model.addAttribute("mode", (Object)"create");
        return "property-category-master-success";
    }

    @RequestMapping(value={"/propertyCategoryMaster/list"}, method={RequestMethod.GET})
    public String getPropertyCategoryMasterList(Model model) {
        List propertyCategoryList = this.propertyCategoryService.findAll();
        model.addAttribute("propertyCategoryList", (Object)propertyCategoryList);
        return "property-category-master-list";
    }

    @RequestMapping(value={"/propertyCategoryMaster/edit"}, method={RequestMethod.GET})
    public String getPropertyCategoryMaster(Model model) {
        model.addAttribute("mode", (Object)"edit");
        return this.getPropertyCategoryMasterList(model);
    }

    @RequestMapping(value={"/propertyCategoryMaster/edit/{propertyCategoryId}"}, method={RequestMethod.GET})
    public String getPropertyCategoryMasterDetails(Model model, @PathVariable String propertyCategoryId) {
        PropertyCategory propertyCategory = this.propertyCategoryService.findOne(Long.valueOf(Long.parseLong(propertyCategoryId)));
        model.addAttribute("propertyCategory", (Object)propertyCategory);
        model.addAttribute("propertyType", (Object)this.propertyTypeService.getAllActivePropertyTypes());
        model.addAttribute("connectionCategory", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
        model.addAttribute("reqAttr", (Object)"true");
        return "property-category-master";
    }

    @RequestMapping(value={"/propertyCategoryMaster/edit/{propertyCategoryId}"}, method={RequestMethod.POST})
    public String editPropertyCategoryMasterData(@Valid @ModelAttribute PropertyCategory propertyCategory, BindingResult errors, RedirectAttributes redirectAttrs, Model model, @PathVariable long propertyCategoryId) {
        if (errors.hasErrors()) {
            model.addAttribute("propertyType", (Object)this.propertyTypeService.getAllActivePropertyTypes());
            model.addAttribute("connectionCategory", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
            return "property-category-master";
        }
        this.propertyCategoryService.updatePropertyCategory(propertyCategory);
        redirectAttrs.addFlashAttribute("propertyCategory", (Object)propertyCategory);
        model.addAttribute("message", (Object)"Property Category updated successfully.");
        return "property-category-master-success";
    }
}

