/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.masters;

import java.util.List;
import javax.validation.Valid;
import org.egov.wtms.masters.entity.ApplicationProcessTime;
import org.egov.wtms.masters.service.ApplicationProcessTimeService;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.masters.service.ConnectionCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class ApplicationProcessTimeController {
    private final ConnectionCategoryService connectionCategoryService;
    private final ApplicationTypeService applicationTypeService;
    private final ApplicationProcessTimeService applicationProcessTimeService;

    @Autowired
    public ApplicationProcessTimeController(ApplicationTypeService applicationTypeService, ConnectionCategoryService connectionCategoryService, ApplicationProcessTimeService applicationProcessTimeService) {
        this.connectionCategoryService = connectionCategoryService;
        this.applicationTypeService = applicationTypeService;
        this.applicationProcessTimeService = applicationProcessTimeService;
    }

    @RequestMapping(value={"/applicationProcessTime"}, method={RequestMethod.GET})
    public String viewForm(Model model) {
        ApplicationProcessTime applicationProcessTime = new ApplicationProcessTime();
        model.addAttribute("applicationProcessTime", (Object)applicationProcessTime);
        model.addAttribute("connectionCategories", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
        model.addAttribute("applicationTypes", (Object)this.applicationTypeService.findAll());
        model.addAttribute("reqAttr", (Object)"false");
        model.addAttribute("mode", (Object)"create");
        return "application-process-time-master";
    }

    @RequestMapping(value={"/applicationProcessTime"}, method={RequestMethod.POST})
    public String createApplicationProcessTimeMasterData(@Valid @ModelAttribute ApplicationProcessTime applicationProcessTime, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute("connectionCategories", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
            model.addAttribute("applicationTypes", (Object)this.applicationTypeService.findAll());
            return "application-process-time-master";
        }
        this.applicationProcessTimeService.createApplicationProcessTime(applicationProcessTime);
        redirectAttrs.addFlashAttribute("applicationProcessTime", (Object)applicationProcessTime);
        model.addAttribute("message", (Object)"Application ProcessTime created successfully.");
        model.addAttribute("mode", (Object)"create");
        return "application-process-time-master-success";
    }

    @RequestMapping(value={"/applicationProcessTime/list"}, method={RequestMethod.GET})
    public String getApplicationProcessTimeList(Model model) {
        List applicationProcessTimeList = this.applicationProcessTimeService.findAll();
        model.addAttribute("applicationProcessTimeList", (Object)applicationProcessTimeList);
        return "application-process-master-list";
    }

    @RequestMapping(value={"/applicationProcessTime/edit"}, method={RequestMethod.GET})
    public String getApplicationProcessTimeMaster(Model model) {
        model.addAttribute("mode", (Object)"edit");
        return this.getApplicationProcessTimeList(model);
    }

    @RequestMapping(value={"/applicationProcessTime/edit/{applicationProcessId}"}, method={RequestMethod.GET})
    public String getApplicationProcessTimeMasterDetails(Model model, @PathVariable String applicationProcessId) {
        ApplicationProcessTime applicationProcessTime = this.applicationProcessTimeService.findOne(Long.valueOf(Long.parseLong(applicationProcessId)));
        model.addAttribute("applicationProcessTime", (Object)applicationProcessTime);
        model.addAttribute("connectionCategories", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
        model.addAttribute("applicationTypes", (Object)this.applicationTypeService.findAll());
        model.addAttribute("reqAttr", (Object)"true");
        return "application-process-time-master";
    }

    @RequestMapping(value={"/applicationProcessTime/edit/{applicationProcessId}"}, method={RequestMethod.POST})
    public String editApplicationProcessTimeData(@Valid @ModelAttribute ApplicationProcessTime applicationProcessTime, BindingResult errors, RedirectAttributes redirectAttrs, Model model, @PathVariable long applicationProcessId) {
        if (errors.hasErrors()) {
            model.addAttribute("connectionCategories", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
            model.addAttribute("applicationTypes", (Object)this.applicationTypeService.findAll());
            return "application-process-time-master";
        }
        this.applicationProcessTimeService.updateApplicationProcessTime(applicationProcessTime);
        redirectAttrs.addFlashAttribute("applicationProcessTime", (Object)applicationProcessTime);
        model.addAttribute("message", (Object)"Application ProcessTime updated successfully.");
        return "application-process-time-master-success";
    }
}

