/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.es;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.elasticsearch.entity.ApplicationIndex;
import org.egov.infra.elasticsearch.entity.es.ApplicationDocument;
import org.egov.wtms.entity.es.ApplicationSearchRequest;
import org.egov.wtms.service.es.ApplicationSearchService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/elastic/appSearch/"})
public class ApplicationSearchController {
    private static final String APPLICATION_COUNT = "application_count";
    private static final String APPLICATION_NUMBER = "applicationNumber";
    private static final String CITY_NAME = "cityName";
    private static final String APPLICANT_NAME = "applicantName";
    private static final String CONSUMER_CODE = "consumerCode";
    private static final String ISCLOSED = "isClosed";
    private static final String MOBILE_NUMBER = "mobileNumber";
    private static final String APPLICATION_TYPE = "applicationType";
    private static final String CHANNEL = "channel";
    private static final String MODULE_NAME = "moduleName";
    private static final String APPLICATION_DATE = "applicationDate";
    private final ApplicationSearchService applicationSearchService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;

    @Autowired
    public ApplicationSearchController(ApplicationSearchService applicationSearchService) {
        this.applicationSearchService = applicationSearchService;
    }

    @RequestMapping(value={"/ajax-moduleTypepopulate"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<ApplicationIndex> getAppConfigs(@ModelAttribute(value="appConfig") @RequestParam String appModuleName) {
        return this.applicationSearchService.findApplicationIndexApplicationTypes(appModuleName);
    }

    @ModelAttribute(value="applicationstatusList")
    public Map<String, String> connectionTypes() {
        return this.applicationSearchService.getApplicationStatusMap();
    }

    @ModelAttribute(value="sourceList")
    public List<ApplicationIndex> getSourceList() {
        return this.applicationSearchService.getSourceList();
    }

    @ModelAttribute
    public ApplicationSearchRequest searchRequest() {
        return new ApplicationSearchRequest();
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newSearchForm(Model model) {
        model.addAttribute("citizenRole", (Object)this.waterTaxUtils.getCitizenUserRole());
        return "applicationSearch-newForm";
    }

    @ModelAttribute(value="modulesList")
    public List<ApplicationIndex> findApplicationIndexModules() {
        return this.applicationSearchService.findApplicationIndexModules();
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public List<ApplicationSearchRequest> searchApplication(@ModelAttribute ApplicationSearchRequest searchRequest) {
        SimpleDateFormat ft = new SimpleDateFormat("dd/MM/yyyy");
        ArrayList<ApplicationSearchRequest> finalResult = new ArrayList<ApplicationSearchRequest>();
        List applicationDocumentList = this.findAllAppicationIndexByFilter(searchRequest);
        for (ApplicationDocument applicationIndex : applicationDocumentList) {
            ApplicationSearchRequest customerObj = new ApplicationSearchRequest();
            customerObj.setApplicantName(applicationIndex.getApplicantName());
            customerObj.setConsumerCode(applicationIndex.getConsumerCode());
            customerObj.setApplicationAddress(applicationIndex.getApplicantAddress());
            customerObj.setApplicationNumber(applicationIndex.getApplicationNumber());
            customerObj.setOwnername(applicationIndex.getOwnerName());
            customerObj.setSource(applicationIndex.getChannel());
            customerObj.setApplicationType(applicationIndex.getApplicationType());
            if (applicationIndex.getApplicationDate() != null) {
                customerObj.setApplicationCreatedDate(ft.format(applicationIndex.getApplicationDate()));
            }
            customerObj.setUrl(applicationIndex.getUrl());
            customerObj.setApplicationStatus(applicationIndex.getStatus());
            finalResult.add(customerObj);
        }
        return finalResult;
    }

    private BoolQueryBuilder getFilterQuery(ApplicationSearchRequest searchRequest) {
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)CITY_NAME, (String)ApplicationThreadLocals.getCityName()));
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getApplicantName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)APPLICANT_NAME, (Object)searchRequest.getApplicantName()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getConsumerCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CONSUMER_CODE, (Object)searchRequest.getConsumerCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getApplicationStatus())) {
            if ("Open".equals(searchRequest.getApplicationStatus())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)ISCLOSED, (Object)Integer.toString(0)));
            } else if ("Closed".equals(searchRequest.getApplicationStatus())) {
                boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)ISCLOSED, (Object)Integer.toString(1)));
            }
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getMobileNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)MOBILE_NUMBER, (Object)searchRequest.getMobileNumber()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getApplicationNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)APPLICATION_NUMBER, (Object)searchRequest.getApplicationNumber()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getApplicationType())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)APPLICATION_TYPE, (Object)searchRequest.getApplicationType()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getSource())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)CHANNEL, (Object)searchRequest.getSource()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getModuleName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)MODULE_NAME, (Object)searchRequest.getModuleName()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getFromDate()) && StringUtils.isNotBlank((CharSequence)searchRequest.getToDate())) {
            boolQuery = boolQuery.must((QueryBuilder)QueryBuilders.rangeQuery((String)APPLICATION_DATE).from(searchRequest.getFromDate()).to(searchRequest.getToDate()));
        }
        return boolQuery;
    }

    public List<ApplicationDocument> findAllAppicationIndexByFilter(ApplicationSearchRequest searchRequest) {
        BoolQueryBuilder query = this.getFilterQuery(searchRequest);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().addAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)APPLICATION_COUNT).field(APPLICATION_NUMBER)).withIndices(new String[]{"applications"}).withQuery((QueryBuilder)query).build();
        Aggregations applicationCountAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, SearchResponse::getAggregations);
        ValueCount aggr = (ValueCount)applicationCountAggr.get(APPLICATION_COUNT);
        searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"applications"}).withQuery((QueryBuilder)query).addAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)APPLICATION_COUNT).field(APPLICATION_NUMBER)).withPageable((Pageable)new PageRequest(0, Math.toIntExact(aggr.getValue() == 0L ? 1L : aggr.getValue()))).build();
        return this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, ApplicationDocument.class);
    }
}

