/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.utils.JsonUtils;
import org.egov.wtms.application.entity.WaterConnExecutionDetails;
import org.egov.wtms.application.entity.WaterConnectionExecutionResponse;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.MeterCost;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.masters.service.MeterCostService;
import org.egov.wtms.reports.entity.ExecuteWaterConnectionAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/application/execute-update"})
public class UpdateWaterConnectionExecutionController {
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    private MeterCostService meterCostService;

    @GetMapping(value={"/search"})
    public String getSearchScreen(Model model) {
        model.addAttribute("executeWaterApplicationDetails", (Object)new WaterConnExecutionDetails());
        model.addAttribute("applicationTypeList", (Object)this.applicationTypeService.getActiveApplicationTypes());
        model.addAttribute("revenueWardList", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE"));
        return "execute-update-search";
    }

    @GetMapping(value={"/search-form"})
    public String getSearchForm(Model model) {
        model.addAttribute("executeWaterApplicationDetails", (Object)new WaterConnExecutionDetails());
        model.addAttribute("applicationTypeList", (Object)this.applicationTypeService.getActiveApplicationTypes());
        model.addAttribute("revenueWardList", (Object)this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE"));
        return "execute-search-screen";
    }

    @ModelAttribute
    public WaterConnExecutionDetails executeWaterApplicationDetails() {
        return new WaterConnExecutionDetails();
    }

    @PostMapping(value={"/search"}, produces={"text/plain"})
    @ResponseBody
    public String searchResult(WaterConnExecutionDetails executeWaterApplicationDetails) {
        List detailList = this.waterConnectionDetailsService.getApplicationResultList(executeWaterApplicationDetails);
        return " { \"data\" : " + JsonUtils.toJSON((Collection)this.waterConnectionDetailsService.getConnExecutionObjectList(detailList), WaterConnExecutionDetails.class, ExecuteWaterConnectionAdaptor.class) + "}";
    }

    @PostMapping(value={"/search-form"}, produces={"text/plain"})
    @ResponseBody
    public String getMeteredApplicationSearchResult(WaterConnExecutionDetails executeWaterApplicationDetails) {
        List detailList = this.waterConnectionDetailsService.getMeteredApplicationList(executeWaterApplicationDetails);
        return " { \"data\" : " + JsonUtils.toJSON((Collection)this.waterConnectionDetailsService.getConnExecutionObjectList(detailList), WaterConnExecutionDetails.class, ExecuteWaterConnectionAdaptor.class) + "}";
    }

    @PostMapping(value={"/result"}, consumes={"application/json"})
    @ResponseBody
    public String getSearchResult(@RequestBody WaterConnectionExecutionResponse waterApplicationDetails) {
        ArrayList connectionDetailsList = new ArrayList();
        String validationStatus = this.waterConnectionDetailsService.validateDate(waterApplicationDetails, connectionDetailsList);
        Boolean updateStatus = this.waterConnectionDetailsService.updateStatus(connectionDetailsList);
        return this.waterConnectionDetailsService.getResultStatus(waterApplicationDetails, validationStatus, updateStatus);
    }

    @GetMapping(value={"/search-result"}, consumes={"application/json"})
    @ResponseBody
    public List<MeterCost> getMeterDetails() {
        return this.meterCostService.findAll();
    }

    @PostMapping(value={"/search-result"}, produces={"application/json"})
    @ResponseBody
    public String updateMeterDetails(@RequestBody WaterConnectionExecutionResponse executeWaterApplicationDetails) {
        ArrayList applicationList = new ArrayList();
        String validationResult = this.waterConnectionDetailsService.validateMeterDetails(executeWaterApplicationDetails, applicationList);
        Boolean status = this.waterConnectionDetailsService.updateMeterDetails(applicationList);
        return this.waterConnectionDetailsService.getResultStatus(executeWaterApplicationDetails, validationResult, status);
    }
}

