/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.util.Date;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang.StringUtils;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.wtms.application.entity.RegularisedConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.RegularisedConnectionService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.egov.wtms.web.controller.application.GenericConnectionController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"/application"})
public class RegularisedConnectionController
extends GenericConnectionController {
    private static final String CURRENTUSER = "currentUser";
    private static final String STATETYPE = "stateType";
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    private RegularisedConnectionService regularisedConnectionService;

    @GetMapping(value={"/regulariseconnection-form/{id}"})
    public String getApplicationForm(@ModelAttribute WaterConnectionDetails waterConnectionDetails, @PathVariable String id, Model model, HttpServletRequest request) {
        RegularisedConnection regularisedConnection = null;
        if (StringUtils.isNotBlank((String)id)) {
            regularisedConnection = this.regularisedConnectionService.findById(Long.valueOf(id));
        }
        waterConnectionDetails.setApplicationDate(new Date());
        waterConnectionDetails.setConnectionStatus(ConnectionStatus.INPROGRESS);
        waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode("REGLZNCONNECTION"));
        if (regularisedConnection != null) {
            model.addAttribute("propertyId", (Object)regularisedConnection.getPropertyIdentifier());
        }
        model.addAttribute("allowIfPTDueExists", (Object)this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent());
        WorkflowContainer workFlowContainer = new WorkflowContainer();
        this.prepareWorkflow(model, (StateAware)waterConnectionDetails, workFlowContainer);
        model.addAttribute(CURRENTUSER, (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute(STATETYPE, (Object)waterConnectionDetails.getClass().getSimpleName());
        model.addAttribute("documentName", (Object)this.waterTaxUtils.documentRequiredForBPLCategory());
        model.addAttribute("typeOfConnection", (Object)"NEWCONNECTION");
        model.addAttribute("citizenPortalUser", (Object)this.waterTaxUtils.isCitizenPortalUser(this.securityUtils.getCurrentUser()));
        model.addAttribute("isAnonymousUser", (Object)this.waterTaxUtils.isAnonymousUser(this.securityUtils.getCurrentUser()));
        return "regulariseconnection-form";
    }

    @PostMapping(value={"/regulariseconnection-form"})
    public String createRegularisedConnection(@ModelAttribute WaterConnectionDetails waterConnectionDetails, BindingResult errors, Model model) {
        return "";
    }
}

