/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.entity.Source;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Position;
import org.egov.wtms.application.entity.ApplicationDocuments;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.NewConnectionService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionService;
import org.egov.wtms.masters.entity.DocumentNames;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.egov.wtms.web.controller.application.GenericConnectionController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/application"})
public class NewConnectionController
extends GenericConnectionController {
    private static final Logger LOG = LoggerFactory.getLogger(NewConnectionController.class);
    private static final String CONNECTION_PROPERTYID = "connection.propertyIdentifier";
    private static final String ADDITIONALRULE = "additionalRule";
    private static final String CURRENTUSER = "currentUser";
    private static final String RADIOBUTTONMAP = "radioButtonMap";
    private static final String STATETYPE = "stateType";
    private static final String NEWCONNECTION_FORM = "newconnection-form";
    private static final String VALIDIFPTDUEEXISTS = "validateIfPTDueExists";
    private static final String APPROVALPOSITION = "approvalPosition";
    private final WaterConnectionDetailsService waterConnectionDtlsService;
    private final ApplicationTypeService applicationTypeService;
    private final ConnectionDemandService connectionDemandService;
    private final NewConnectionService newConnectionService;
    private final WaterTaxUtils waterTaxUtils;
    @Autowired
    private SecurityUtils securityUtils;

    @Autowired
    public NewConnectionController(WaterConnectionDetailsService waterConnectionDtlsService, ApplicationTypeService applicationTypeService, ConnectionDemandService connectionDemandService, WaterTaxUtils waterTaxUtils, NewConnectionService newConnectionService, WaterConnectionService waterConnectionService) {
        this.waterConnectionDtlsService = waterConnectionDtlsService;
        this.applicationTypeService = applicationTypeService;
        this.connectionDemandService = connectionDemandService;
        this.waterTaxUtils = waterTaxUtils;
        this.newConnectionService = newConnectionService;
    }

    @ModelAttribute(value="documentNamesList")
    public List<DocumentNames> documentNamesList(@ModelAttribute WaterConnectionDetails waterConnectionDetails) {
        waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode("NEWCONNECTION"));
        return this.waterConnectionDtlsService.getAllActiveDocumentNames(waterConnectionDetails.getApplicationType());
    }

    @RequestMapping(value={"/newConnection-newform"}, method={RequestMethod.GET})
    public String showNewApplicationForm(@ModelAttribute WaterConnectionDetails waterConnectionDetails, Model model, HttpServletRequest request) {
        waterConnectionDetails.setApplicationDate(new Date());
        waterConnectionDetails.setConnectionStatus(ConnectionStatus.INPROGRESS);
        model.addAttribute("allowIfPTDueExists", (Object)this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent());
        model.addAttribute(ADDITIONALRULE, (Object)waterConnectionDetails.getApplicationType().getCode());
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setAdditionalRule(waterConnectionDetails.getApplicationType().getCode());
        this.prepareWorkflow(model, (StateAware)waterConnectionDetails, workflowContainer);
        model.addAttribute(CURRENTUSER, (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute(STATETYPE, (Object)waterConnectionDetails.getClass().getSimpleName());
        model.addAttribute("documentName", (Object)this.waterTaxUtils.documentRequiredForBPLCategory());
        model.addAttribute("typeOfConnection", (Object)"NEWCONNECTION");
        model.addAttribute("citizenPortalUser", (Object)this.waterTaxUtils.isCitizenPortalUser(this.securityUtils.getCurrentUser()));
        model.addAttribute("isAnonymousUser", (Object)this.waterTaxUtils.isAnonymousUser(this.securityUtils.getCurrentUser()));
        Boolean loggedUserIsMeesevaUser = this.waterTaxUtils.isMeesevaUser(this.securityUtils.getCurrentUser());
        if (loggedUserIsMeesevaUser.booleanValue()) {
            if (request.getParameter("applicationNo") == null) {
                throw new ApplicationRuntimeException("MEESEVA.005");
            }
            waterConnectionDetails.setMeesevaApplicationNumber(request.getParameter("applicationNo"));
        }
        return NEWCONNECTION_FORM;
    }

    @RequestMapping(value={"/newConnection-dataEntryForm"}, method={RequestMethod.GET})
    public String dataEntryForm(@ModelAttribute WaterConnectionDetails waterConnectionDetails, Model model) {
        waterConnectionDetails.setApplicationDate(new Date());
        waterConnectionDetails.setConnectionStatus(ConnectionStatus.ACTIVE);
        HashMap<Long, String> connectionTypeMap = new HashMap<Long, String>();
        connectionTypeMap.put(this.applicationTypeService.findByCode("NEWCONNECTION").getId(), "Primary Connection");
        connectionTypeMap.put(this.applicationTypeService.findByCode("ADDNLCONNECTION").getId(), "Additional Connection");
        model.addAttribute(RADIOBUTTONMAP, connectionTypeMap);
        model.addAttribute("mode", (Object)"dataEntry");
        model.addAttribute("typeOfConnection", (Object)"NEWCONNECTION");
        return "newconnection-dataEntryForm";
    }

    @RequestMapping(value={"/newConnection-existingMessage/{consumerCode}"}, method={RequestMethod.GET})
    public String dataEntryMessage(Model model, @PathVariable String consumerCode) {
        model.addAttribute("consumerCode", (Object)consumerCode);
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDtlsService.findByApplicationNumberOrConsumerCode(consumerCode);
        model.addAttribute("connectionType", this.waterConnectionDtlsService.getConnectionTypesMap().get(waterConnectionDetails.getConnectionType().name()));
        if (waterConnectionDetails.getId() != null) {
            model.addAttribute("mode", (Object)"edit");
        } else {
            model.addAttribute("mode", (Object)"");
        }
        return "newconnection-dataEntryMessage";
    }

    @RequestMapping(value={"/newConnection-create"}, method={RequestMethod.POST})
    public String createNewConnection(@Valid @ModelAttribute WaterConnectionDetails waterConnectionDetails, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model, @RequestParam String workFlowAction, BindingResult errors) {
        Boolean isJuniorAsstOrSeniorAsst;
        Boolean loggedUserIsMeesevaUser = this.waterTaxUtils.isMeesevaUser(this.securityUtils.getCurrentUser());
        Boolean isCSCOperator = this.waterTaxUtils.isCSCoperator(this.securityUtils.getCurrentUser());
        boolean citizenPortalUser = this.waterTaxUtils.isCitizenPortalUser(this.securityUtils.getCurrentUser());
        model.addAttribute("citizenPortalUser", (Object)citizenPortalUser);
        Boolean isAnonymousUser = this.waterTaxUtils.isAnonymousUser(this.securityUtils.getCurrentUser());
        model.addAttribute("isAnonymousUser", (Object)isAnonymousUser);
        if (!(isCSCOperator.booleanValue() || citizenPortalUser || loggedUserIsMeesevaUser.booleanValue() || isAnonymousUser.booleanValue() || (isJuniorAsstOrSeniorAsst = this.waterTaxUtils.isLoggedInUserJuniorOrSeniorAssistant(this.securityUtils.getCurrentUser().getId())).booleanValue())) {
            throw new ValidationException("err.creator.application");
        }
        Boolean applicationByOthers = this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser());
        String sourceChannel = request.getParameter("Source");
        this.newConnectionService.validatePropertyID(waterConnectionDetails, resultBinder);
        this.waterConnectionDtlsService.validateWaterRateAndDonationHeader(waterConnectionDetails);
        ArrayList applicationDocs = new ArrayList();
        int i = 0;
        String documentRequired = this.waterTaxUtils.documentRequiredForBPLCategory();
        if (!waterConnectionDetails.getApplicationDocs().isEmpty()) {
            for (ApplicationDocuments applicationDocument : waterConnectionDetails.getApplicationDocs()) {
                this.newConnectionService.validateDocuments(applicationDocs, applicationDocument, i, resultBinder, waterConnectionDetails.getCategory().getId(), documentRequired);
                ++i;
            }
        }
        if (waterConnectionDetails.getState() == null) {
            waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CREATED", "WATERTAXAPPLICATION"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Model Level Validation occurs = " + resultBinder);
        }
        if (resultBinder.hasErrors()) {
            waterConnectionDetails.setApplicationDate(new Date());
            model.addAttribute(VALIDIFPTDUEEXISTS, (Object)this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent());
            WorkflowContainer workflowContainer = new WorkflowContainer();
            workflowContainer.setAdditionalRule(waterConnectionDetails.getApplicationType().getCode());
            this.prepareWorkflow(model, (StateAware)waterConnectionDetails, workflowContainer);
            model.addAttribute(ADDITIONALRULE, (Object)waterConnectionDetails.getApplicationType().getCode());
            model.addAttribute(CURRENTUSER, (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
            model.addAttribute("approvalPosOnValidate", (Object)request.getParameter(APPROVALPOSITION));
            model.addAttribute("typeOfConnection", (Object)"NEWCONNECTION");
            model.addAttribute(STATETYPE, (Object)waterConnectionDetails.getClass().getSimpleName());
            model.addAttribute("documentName", (Object)this.waterTaxUtils.documentRequiredForBPLCategory());
            return NEWCONNECTION_FORM;
        }
        waterConnectionDetails.getApplicationDocs().clear();
        waterConnectionDetails.setApplicationDocs(applicationDocs);
        this.processAndStoreApplicationDocuments(waterConnectionDetails);
        Long approvalPosition = 0L;
        String approvalComent = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComent = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter(APPROVALPOSITION) != null && !request.getParameter(APPROVALPOSITION).isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter(APPROVALPOSITION));
        }
        if (applicationByOthers != null && applicationByOthers.equals(true) || citizenPortalUser || isAnonymousUser.booleanValue()) {
            Position userPosition = this.waterTaxUtils.getZonalLevelClerkForLoggedInUser(waterConnectionDetails.getConnection().getPropertyIdentifier());
            if (userPosition != null) {
                approvalPosition = userPosition.getId();
            } else {
                model.addAttribute(VALIDIFPTDUEEXISTS, (Object)this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent());
                WorkflowContainer workflowContainer = new WorkflowContainer();
                workflowContainer.setAdditionalRule(waterConnectionDetails.getApplicationType().getCode());
                this.prepareWorkflow(model, (StateAware)waterConnectionDetails, workflowContainer);
                model.addAttribute(ADDITIONALRULE, (Object)waterConnectionDetails.getApplicationType().getCode());
                model.addAttribute("approvalPosOnValidate", (Object)request.getParameter(APPROVALPOSITION));
                model.addAttribute(CURRENTUSER, (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
                model.addAttribute(STATETYPE, (Object)waterConnectionDetails.getClass().getSimpleName());
                errors.rejectValue(CONNECTION_PROPERTYID, "err.validate.connection.user.mapping", "err.validate.connection.user.mapping");
                model.addAttribute("noJAORSAMessage", (Object)"No JA/SA exists to forward the application.");
                return NEWCONNECTION_FORM;
            }
        }
        if (isAnonymousUser.booleanValue()) {
            waterConnectionDetails.setSource(Source.ONLINE);
            sourceChannel = "ONLINE";
        }
        if (citizenPortalUser && (waterConnectionDetails.getSource() == null || StringUtils.isBlank((CharSequence)waterConnectionDetails.getSource().toString()))) {
            waterConnectionDetails.setSource(this.waterTaxUtils.setSourceOfConnection(this.securityUtils.getCurrentUser()));
        }
        if (loggedUserIsMeesevaUser.booleanValue()) {
            waterConnectionDetails.setSource(Source.MEESEVA);
            if (waterConnectionDetails.getMeesevaApplicationNumber() != null) {
                waterConnectionDetails.setApplicationNumber(waterConnectionDetails.getMeesevaApplicationNumber());
            }
        }
        this.waterConnectionDtlsService.createNewWaterConnection(waterConnectionDetails, approvalPosition, approvalComent, waterConnectionDetails.getApplicationType().getCode(), workFlowAction, sourceChannel);
        if (LOG.isDebugEnabled()) {
            LOG.debug("createNewWaterConnection is completed ");
        }
        if (loggedUserIsMeesevaUser.booleanValue()) {
            return "redirect:/application/generate-meesevareceipt?transactionServiceNumber=" + waterConnectionDetails.getApplicationNumber();
        }
        return "redirect:/application/citizeenAcknowledgement?pathVars=" + waterConnectionDetails.getApplicationNumber();
    }

    @ModelAttribute
    public WaterConnectionDetails loadByConsumerNo(@RequestParam(name="id", required=false) Long id) {
        if (id != null) {
            return this.waterConnectionDtlsService.findBy(id);
        }
        return new WaterConnectionDetails();
    }

    @RequestMapping(value={"/newConnection-dataEntryForm"}, method={RequestMethod.POST})
    public String createExisting(@Valid @ModelAttribute WaterConnectionDetails waterConnectionDetails, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model) {
        return this.createAndUpdateDataEntryRecord(waterConnectionDetails, resultBinder, model);
    }

    private String createAndUpdateDataEntryRecord(WaterConnectionDetails waterConnectionDetails, BindingResult resultBinder, Model model) {
        this.newConnectionService.validatePropertyIDForDataEntry(waterConnectionDetails, resultBinder);
        this.newConnectionService.validateExisting(waterConnectionDetails, resultBinder);
        if (resultBinder.hasErrors()) {
            model.addAttribute(VALIDIFPTDUEEXISTS, (Object)this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent());
            HashMap<Long, String> connectionTypeMap = new HashMap<Long, String>();
            connectionTypeMap.put(this.applicationTypeService.findByCode("NEWCONNECTION").getId(), "Primary Connection");
            connectionTypeMap.put(this.applicationTypeService.findByCode("ADDNLCONNECTION").getId(), "Additional Connection");
            model.addAttribute(RADIOBUTTONMAP, connectionTypeMap);
            model.addAttribute(RADIOBUTTONMAP, connectionTypeMap);
            model.addAttribute("usageTypes", (Object)this.usageTypeService.getActiveUsageTypes());
            model.addAttribute("connectionCategories", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
            model.addAttribute("pipeSizes", (Object)this.pipeSizeService.getAllActivePipeSize());
            if (waterConnectionDetails.getId() == null) {
                return "newconnection-dataEntryForm";
            }
            return "newconnection-dataEntryEditForm";
        }
        this.waterConnectionDtlsService.createExisting(waterConnectionDetails);
        return "redirect:newConnection-existingMessage/" + waterConnectionDetails.getConnection().getConsumerCode();
    }

    @RequestMapping(value={"/generate-meesevareceipt"}, method={RequestMethod.GET})
    public RedirectView generateMeesevaReceipt(@ModelAttribute WaterConnectionDetails waterConnectionDetails, HttpServletRequest request, Model model) {
        String keyNameArray = request.getParameter("transactionServiceNumber");
        RedirectView redirect = new RedirectView("/meeseva/generatereceipt?transactionServiceNumber=" + keyNameArray, false);
        FlashMap outputFlashMap = RequestContextUtils.getOutputFlashMap((HttpServletRequest)request);
        if (outputFlashMap != null) {
            outputFlashMap.put((Object)"url", (Object)request.getRequestURL());
        }
        return redirect;
    }

    @RequestMapping(value={"/application-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute WaterConnectionDetails waterConnectionDetails, HttpServletRequest request, Model model) {
        String[] keyNameArray = request.getParameter("pathVars").split(",");
        String applicationNumber = "";
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                applicationNumber = keyNameArray[0];
            } else if (keyNameArray.length == 3) {
                applicationNumber = keyNameArray[0];
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                applicationNumber = keyNameArray[0];
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (applicationNumber != null) {
            waterConnectionDetails = this.waterConnectionDtlsService.findByApplicationNumber(applicationNumber);
        }
        model.addAttribute("approverName", (Object)approverName);
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        model.addAttribute("connectionType", this.waterConnectionDtlsService.getConnectionTypesMap().get(waterConnectionDetails.getConnectionType().name()));
        model.addAttribute("cityName", (Object)this.waterTaxUtils.getMunicipalityName());
        model.addAttribute("applicationDocList", (Object)this.waterConnectionDtlsService.getApplicationDocForExceptClosureAndReConnection(waterConnectionDetails));
        model.addAttribute("feeDetails", (Object)this.connectionDemandService.getSplitFee(waterConnectionDetails));
        model.addAttribute("mode", (Object)"ack");
        return new ModelAndView("application/application-success", "waterConnectionDetails", (Object)waterConnectionDetails);
    }

    @RequestMapping(value={"/newConnection-editExisting/{consumerCode}"}, method={RequestMethod.GET})
    public String editExisting(@ModelAttribute WaterConnectionDetails waterConnectionDetails, @PathVariable String consumerCode, Model model) {
        waterConnectionDetails = this.waterConnectionDtlsService.findByApplicationNumberOrConsumerCode(consumerCode);
        model.addAttribute("allowIfPTDueExists", (Object)this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent());
        model.addAttribute(ADDITIONALRULE, (Object)waterConnectionDetails.getApplicationType().getCode());
        model.addAttribute(CURRENTUSER, (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute(STATETYPE, (Object)waterConnectionDetails.getClass().getSimpleName());
        HashMap<Long, String> connectionTypeMap = new HashMap<Long, String>();
        connectionTypeMap.put(this.applicationTypeService.findByCode("NEWCONNECTION").getId(), "Primary Connection");
        connectionTypeMap.put(this.applicationTypeService.findByCode("ADDNLCONNECTION").getId(), "Additional Connection");
        model.addAttribute(RADIOBUTTONMAP, connectionTypeMap);
        model.addAttribute("mode", (Object)"dataEntry");
        model.addAttribute("waterConnectionDetails", (Object)waterConnectionDetails);
        model.addAttribute("usageTypes", (Object)this.usageTypeService.getActiveUsageTypes());
        model.addAttribute("connectionCategories", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
        model.addAttribute("pipeSizes", (Object)this.pipeSizeService.getAllActivePipeSize());
        return "newconnection-dataEntryEditForm";
    }

    @RequestMapping(value={"/newConnection-editExisting/{consumerCode}"}, method={RequestMethod.POST})
    public String modifyExisting(@Valid @ModelAttribute WaterConnectionDetails waterConnectionDetails, @PathVariable String consumerCode, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model) {
        return this.createAndUpdateDataEntryRecord(waterConnectionDetails, resultBinder, model);
    }
}

