/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.demand.model.EgDemand;
import org.egov.demand.model.EgDemandDetails;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.DateUtils;
import org.egov.wtms.application.entity.MeterReadingConnectionDetails;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.MeteredRates;
import org.egov.wtms.masters.entity.MeteredRatesDetail;
import org.egov.wtms.masters.entity.UsageSlab;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.repository.WaterRatesDetailsRepository;
import org.egov.wtms.masters.service.MeteredRatesDetailService;
import org.egov.wtms.masters.service.MeteredRatesService;
import org.egov.wtms.masters.service.UsageSlabService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.joda.time.DateTime;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class MeterReadingController {
    private static final Logger LOGGER = LoggerFactory.getLogger(MeterReadingController.class);
    private static final String PREVIOUSREADING = "previousreading";
    private static final String NEWCONNECTIONMETERENTRY = "newconnection-meterEntry";
    private static final String METERCURRENTREADING = "metercurrentReading";
    private static final String REDIRECT_TO_METERDEMANDNOTICE = "redirect:/application/meterdemandnotice?pathVar=";
    private static final String ERROR_METER_RATE_NOT_PRESENT = "err.metered.rate.not.present";
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private UsageSlabService usageSlabService;
    @Autowired
    private MeteredRatesService meteredRatesService;
    @Autowired
    private MeteredRatesDetailService meteredRatesDetailService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    private final WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    private final ConnectionDemandService connectionDemandService;

    @Autowired
    public MeterReadingController(WaterConnectionDetailsRepository waterConnectionDetailsRepository, WaterRatesDetailsRepository waterRatesDetailsRepository, ConnectionDemandService connectionDemandService) {
        this.waterConnectionDetailsRepository = waterConnectionDetailsRepository;
        this.connectionDemandService = connectionDemandService;
    }

    @ModelAttribute
    public WaterConnectionDetails getWaterConnectionDetails(@PathVariable String consumerCode) {
        return this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
    }

    private String loadViewData(Model model, WaterConnectionDetails waterConnectionDetails) {
        SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
        model.addAttribute("waterConnectionDetails", (Object)waterConnectionDetails);
        model.addAttribute("executionDate", (Object)formatter.format(waterConnectionDetails.getExecutionDate()));
        model.addAttribute("feeDetails", (Object)this.connectionDemandService.getSplitFee(waterConnectionDetails));
        model.addAttribute("connectionType", this.waterConnectionDetailsService.getConnectionTypesMap().get(waterConnectionDetails.getConnectionType().name()));
        model.addAttribute("mode", (Object)"meterEntry");
        model.addAttribute("meterReadingCurrentObj", (Object)new MeterReadingConnectionDetails());
        BigDecimal waterTaxDueforParent = this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails);
        model.addAttribute("waterTaxDueforParent", (Object)waterTaxDueforParent);
        return NEWCONNECTIONMETERENTRY;
    }

    @RequestMapping(value={"/meterentry/{consumerCode}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable String consumerCode, HttpServletRequest request) {
        MeterReadingConnectionDetails meterReadingpriviousObj;
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
        List meterReadingpriviousObjlist = this.waterConnectionDetailsRepository.findPreviousMeterReadingReading(waterConnectionDetails.getId());
        if (!meterReadingpriviousObjlist.isEmpty()) {
            meterReadingpriviousObj = (MeterReadingConnectionDetails)meterReadingpriviousObjlist.get(0);
        } else {
            meterReadingpriviousObj = new MeterReadingConnectionDetails();
            if (waterConnectionDetails.getConnection().getInitialReading() != null) {
                meterReadingpriviousObj.setCurrentReading(waterConnectionDetails.getConnection().getInitialReading());
            } else {
                meterReadingpriviousObj.setCurrentReading(Long.valueOf(0L));
            }
        }
        model.addAttribute("meterReadingpriviousObj", (Object)meterReadingpriviousObj);
        if (this.connectionDemandService.meterEntryAllReadyExistForCurrentMonth(waterConnectionDetails, new Date()).booleanValue()) {
            return REDIRECT_TO_METERDEMANDNOTICE + waterConnectionDetails.getConnection().getConsumerCode();
        }
        return this.loadViewData(model, waterConnectionDetails);
    }

    @RequestMapping(value={"/meterentry/{consumerCode}"}, method={RequestMethod.POST})
    public String updateMeterEntry(@ModelAttribute WaterConnectionDetails waterConnectionDetails, BindingResult errors, RedirectAttributes redirectAttrs, Model model, HttpServletRequest request) {
        String sourceChannel = request.getParameter("Source");
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy", Locale.getDefault());
        Date givenDate = null;
        try {
            givenDate = dateFormat.parse(request.getParameter("metercurrentReadingDate"));
        }
        catch (ParseException e) {
            LOGGER.error("Exception while parsing date " + e);
        }
        if (this.connectionDemandService.meterEntryAllReadyExistForCurrentMonth(waterConnectionDetails, givenDate).booleanValue()) {
            return REDIRECT_TO_METERDEMANDNOTICE + waterConnectionDetails.getConnection().getConsumerCode();
        }
        MeterReadingConnectionDetails meterReadingConnectionDetailObj = new MeterReadingConnectionDetails();
        Long previousReading = 0L;
        Long currentReadingValue = null;
        if ("true".equals(request.getParameter("waterConnectionDetails.meterConnection.isMeterDamaged"))) {
            Boolean meterDamaged = true;
            meterReadingConnectionDetailObj.setMeterDamaged(meterDamaged.booleanValue());
        }
        if (errors.hasErrors()) {
            return NEWCONNECTIONMETERENTRY;
        }
        if (null != request.getParameter(PREVIOUSREADING) && !"".equals(request.getParameter(PREVIOUSREADING))) {
            previousReading = Long.valueOf(request.getParameter(PREVIOUSREADING));
        }
        if (StringUtils.isNotBlank((CharSequence)request.getParameter(METERCURRENTREADING))) {
            currentReadingValue = Long.valueOf(request.getParameter(METERCURRENTREADING));
        }
        if (currentReadingValue != null && currentReadingValue < previousReading) {
            String message = "Current rate should not be less than Previous reading";
            model.addAttribute("message", (Object)"Current rate should not be less than Previous reading");
            return NEWCONNECTIONMETERENTRY;
        }
        WaterConnectionDetails waterconnectionDetails = this.billCalculationAndDemandUpdate(waterConnectionDetails, request, meterReadingConnectionDetailObj, previousReading, dateFormat);
        WaterConnectionDetails savedWaterConnectionDetails = (WaterConnectionDetails)this.waterConnectionDetailsRepository.save((Object)waterconnectionDetails);
        this.waterConnectionDetailsService.updateIndexes(savedWaterConnectionDetails, sourceChannel);
        return REDIRECT_TO_METERDEMANDNOTICE + savedWaterConnectionDetails.getConnection().getConsumerCode();
    }

    private WaterConnectionDetails billCalculationAndDemandUpdate(WaterConnectionDetails waterConnectionDetails, HttpServletRequest request, MeterReadingConnectionDetails meterReadingConnectionDetailObj, Long previousReading, SimpleDateFormat dateFormat) {
        WaterConnectionDetails waterconnectionDetails;
        Date currentDate = null;
        Date previousDate = null;
        Long noOfUnitsPerMonth = 0L;
        String readingDate = request.getParameter("metercurrentReadingDate");
        try {
            currentDate = dateFormat.parse(readingDate);
            if (request.getParameter("previousreadingDate") != null) {
                previousDate = dateFormat.parse(request.getParameter("previousreadingDate"));
            }
        }
        catch (ParseException e) {
            LOGGER.error("Exception while parsing date " + e);
        }
        if (StringUtils.isNotBlank((CharSequence)request.getParameter(METERCURRENTREADING))) {
            meterReadingConnectionDetailObj.setCurrentReading(Long.valueOf(request.getParameter(METERCURRENTREADING)));
        }
        meterReadingConnectionDetailObj.setCurrentReadingDate(currentDate);
        this.populateMeterReadingDetails(meterReadingConnectionDetailObj, waterConnectionDetails);
        int noofmonths = previousDate != null ? DateUtils.noOfMonthsBetween((Date)previousDate, (Date)currentDate) : DateUtils.noOfMonthsBetween((Date)new Date(), (Date)currentDate);
        if (!meterReadingConnectionDetailObj.isMeterDamaged()) {
            Long currentToPreviousDiffOfUnits = Long.valueOf(request.getParameter(METERCURRENTREADING)) - previousReading;
            noOfUnitsPerMonth = noofmonths > 0 ? Long.valueOf(currentToPreviousDiffOfUnits / (long)noofmonths) : currentToPreviousDiffOfUnits;
        }
        if (meterReadingConnectionDetailObj.isMeterDamaged()) {
            waterconnectionDetails = this.calculateDemandForDamagedMeter(waterConnectionDetails, previousDate, noofmonths);
        } else {
            double finalAmountToBePaid = this.calculateAmountTobePaid(waterConnectionDetails, noOfUnitsPerMonth);
            if (BigDecimal.valueOf(finalAmountToBePaid).compareTo(BigDecimal.ZERO) > 0) {
                waterconnectionDetails = this.connectionDemandService.updateDemandForMeteredConnection(waterConnectionDetails, BigDecimal.valueOf(finalAmountToBePaid), currentDate, previousDate, noofmonths);
            } else {
                throw new ApplicationRuntimeException("err.no.amount.due");
            }
        }
        return waterconnectionDetails;
    }

    private WaterConnectionDetails calculateDemandForDamagedMeter(WaterConnectionDetails waterConnectionDetails, Date previousDate, int noofmonths) {
        new WaterConnectionDetails();
        DateTime dateTime = new DateTime((Object)previousDate);
        List newInstallmentList = this.installmentDao.getInstallmentsByModuleForGivenDateAndInstallmentType(this.moduleService.getModuleByName("Water Tax Management"), previousDate, "Monthly");
        Installment currentInstallment = this.connectionDemandService.getCurrentInstallment("Water Tax Management", "Monthly", new Date());
        if (newInstallmentList.isEmpty() || !newInstallmentList.contains(currentInstallment)) {
            newInstallmentList.add(currentInstallment);
        }
        for (Installment instalmentVal : newInstallmentList) {
            DateTime lastInstReadingDate = dateTime.minusMonths(6);
            DateTime lastInstStartDate = lastInstReadingDate.withDayOfMonth(1).withTimeAtStartOfDay();
            List lastInstallmentList = this.installmentDao.getInstallmentsByModuleBetweenFromDateAndToDateAndInstallmentType(this.moduleService.getModuleByName("Water Tax Management"), lastInstStartDate.toDate(), instalmentVal.getFromDate(), "Monthly");
            Double amountValue = this.calculateDamagedMeterAverageDemand(lastInstallmentList, waterConnectionDetails);
            if (BigDecimal.valueOf(amountValue).compareTo(BigDecimal.ZERO) > 0) {
                this.connectionDemandService.updateDemandForMeteredConnection(waterConnectionDetails, BigDecimal.valueOf(amountValue), instalmentVal.getFromDate(), previousDate, noofmonths);
            }
            dateTime = new DateTime((Object)instalmentVal.getFromDate());
            dateTime = dateTime.plusMonths(1);
        }
        return waterConnectionDetails;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private double calculateAmountTobePaid(WaterConnectionDetails waterConnectionDetails, Long noOfUnitsPerMonth) {
        MeteredRates meteredRates = null;
        Double amountToBeCollected = 0.0;
        UsageSlab usageSlab = null;
        if (noOfUnitsPerMonth != 0L) {
            usageSlab = this.usageSlabService.getUsageSlabForWaterVolumeConsumed(waterConnectionDetails.getUsageType().getName(), noOfUnitsPerMonth);
        }
        if (usageSlab != null && usageSlab.getSlabName() != null) {
            meteredRates = this.meteredRatesService.findBySlabName(usageSlab.getSlabName());
        } else if (noOfUnitsPerMonth != 0L) {
            throw new ApplicationRuntimeException("err.usageslab.not.present");
        }
        if (meteredRates == null || meteredRates.getSlabName() == null) throw new ApplicationRuntimeException(ERROR_METER_RATE_NOT_PRESENT);
        MeteredRatesDetail meteredRatesDetail = this.meteredRatesDetailService.getActiveRateforSlab(meteredRates.getSlabName(), new Date());
        if (meteredRatesDetail == null) throw new ApplicationRuntimeException(ERROR_METER_RATE_NOT_PRESENT);
        if (meteredRatesDetail.getRateAmount() == null && meteredRatesDetail.getFlatAmount() == null) {
            throw new ApplicationRuntimeException(ERROR_METER_RATE_NOT_PRESENT);
        }
        if (meteredRatesDetail.isRecursive()) {
            amountToBeCollected = this.calculateDemandWithRecursiveAmount(usageSlab, meteredRatesDetail, noOfUnitsPerMonth);
            return amountToBeCollected;
        } else if (meteredRatesDetail.getRateAmount() != null && meteredRatesDetail.getRateAmount() != 0.0) {
            amountToBeCollected = meteredRatesDetail.getRateAmount() * (double)noOfUnitsPerMonth.longValue();
            return amountToBeCollected;
        } else {
            if (meteredRatesDetail.getFlatAmount() == null || meteredRatesDetail.getFlatAmount() == 0.0) return amountToBeCollected;
            amountToBeCollected = meteredRatesDetail.getFlatAmount();
        }
        return amountToBeCollected;
    }

    private Double calculateDamagedMeterAverageDemand(List<Installment> installmentList, WaterConnectionDetails waterConnectionDetails) {
        Double totalAmount = 0.0;
        int count = 0;
        Set demandDtlSet = null;
        BigDecimal meterDemandAmount = BigDecimal.ZERO;
        EgDemand demand = this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand();
        if (demand != null) {
            demandDtlSet = demand.getEgDemandDetails();
        }
        for (Installment installment : installmentList) {
            for (EgDemandDetails demandDetail : demandDtlSet) {
                if (!demandDetail.getEgDemandReason().getEgInstallmentMaster().equals((Object)installment)) continue;
                ++count;
                meterDemandAmount = meterDemandAmount.add(demandDetail.getAmount());
            }
        }
        if (count != 0) {
            totalAmount = meterDemandAmount.doubleValue() / (double)count;
        }
        return totalAmount;
    }

    private Double calculateDemandWithRecursiveAmount(UsageSlab usageSlab, MeteredRatesDetail meteredRatesDetail, Long numberOfUnitsPerMonth) {
        Double totalAmount = 0.0;
        if (meteredRatesDetail.getFlatAmount() != null && meteredRatesDetail.getFlatAmount() != 0.0 && numberOfUnitsPerMonth >= usageSlab.getFromVolume()) {
            Double amtValue = ((double)numberOfUnitsPerMonth.longValue() - (double)usageSlab.getFromVolume().longValue() + 1.0) / meteredRatesDetail.getRecursiveFactor();
            totalAmount = meteredRatesDetail.getFlatAmount() + Math.ceil(amtValue) * meteredRatesDetail.getRecursiveAmount();
        } else if (meteredRatesDetail.getRateAmount() != null && meteredRatesDetail.getRateAmount() != 0.0 && numberOfUnitsPerMonth >= usageSlab.getFromVolume()) {
            Double amount1 = ((double)usageSlab.getFromVolume().longValue() - 1.0) * meteredRatesDetail.getRateAmount();
            Double amount2 = ((double)numberOfUnitsPerMonth.longValue() - (double)usageSlab.getFromVolume().longValue() + 1.0) / meteredRatesDetail.getRecursiveFactor();
            Double amtValue = Math.ceil(amount2) * meteredRatesDetail.getRecursiveAmount();
            totalAmount = amount1 + amtValue;
        }
        return totalAmount;
    }

    private void populateMeterReadingDetails(MeterReadingConnectionDetails meterReadingConnectionDeatilObj, WaterConnectionDetails waterConnectionDetails) {
        ArrayList<MeterReadingConnectionDetails> meterentryDetailsList = new ArrayList<MeterReadingConnectionDetails>(0);
        if (meterReadingConnectionDeatilObj != null && this.validMeterEntryDetail(meterReadingConnectionDeatilObj)) {
            meterReadingConnectionDeatilObj.setWaterConnectionDetails(waterConnectionDetails);
            meterentryDetailsList.add(meterReadingConnectionDeatilObj);
        }
        waterConnectionDetails.getMeterConnection().clear();
        waterConnectionDetails.setMeterConnection(meterentryDetailsList);
    }

    private boolean validMeterEntryDetail(MeterReadingConnectionDetails meterReadingConnectionDetails) {
        return meterReadingConnectionDetails.getCurrentReading() != null || meterReadingConnectionDetails.getCurrentReadingDate() != null;
    }
}

