/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.WordUtils;
import org.egov.commons.Installment;
import org.egov.demand.dao.DemandGenericDao;
import org.egov.demand.model.EgBill;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.MeterReadingConnectionDetails;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/application"})
public class MeterDemandNoticeController {
    public static final String METERDEMAND_NOTICE = "meterDemandNotice";
    @Autowired
    private ReportService reportService;
    @Autowired
    private DemandGenericDao demandGenericDao;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;

    @RequestMapping(value={"/meterdemandnotice"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateEstimationNotice(HttpServletRequest request, HttpSession session) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(request.getParameter("pathVar"), ConnectionStatus.ACTIVE);
        return this.generateReport(waterConnectionDetails, session);
    }

    private ResponseEntity<byte[]> generateReport(WaterConnectionDetails waterConnectionDetails, HttpSession session) {
        ReportRequest reportInput = null;
        if (waterConnectionDetails != null) {
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
            StringBuilder ownerName = new StringBuilder();
            int counter = 0;
            for (OwnerName names : assessmentDetails.getOwnerNames()) {
                if (counter > 0) {
                    ownerName.append(", ");
                }
                ownerName.append(names.getOwnerName());
                ++counter;
            }
            EgBill billObj = null;
            List billlist = this.demandGenericDao.getAllBillsForDemand(this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand(), "N", "N");
            if (!billlist.isEmpty()) {
                billObj = (EgBill)billlist.get(0);
            }
            MeterReadingConnectionDetails meterReadingpriviousObj = new MeterReadingConnectionDetails();
            List meterReadingpriviousObjlist = this.waterConnectionDetailsRepository.findPreviousMeterReadingReading(waterConnectionDetails.getId());
            if (meterReadingpriviousObjlist.size() > 1) {
                meterReadingpriviousObj.setCurrentReading(((MeterReadingConnectionDetails)meterReadingpriviousObjlist.get(1)).getCurrentReading());
                if (((MeterReadingConnectionDetails)meterReadingpriviousObjlist.get(1)).getCurrentReadingDate() != null) {
                    meterReadingpriviousObj.setCurrentReadingDate(((MeterReadingConnectionDetails)meterReadingpriviousObjlist.get(1)).getCurrentReadingDate());
                } else {
                    meterReadingpriviousObj.setCurrentReadingDate(waterConnectionDetails.getExecutionDate());
                }
            } else {
                if (waterConnectionDetails.getConnection().getInitialReading() != null) {
                    meterReadingpriviousObj.setCurrentReading(waterConnectionDetails.getConnection().getInitialReading());
                } else {
                    meterReadingpriviousObj.setCurrentReading(Long.valueOf(0L));
                }
                meterReadingpriviousObj.setCurrentReadingDate(waterConnectionDetails.getExecutionDate());
            }
            SimpleDateFormat formattermonth = new SimpleDateFormat("MMMM");
            SimpleDateFormat formatterYear = new SimpleDateFormat("YYYY");
            String monthName = formattermonth.format((Object)((MeterReadingConnectionDetails)waterConnectionDetails.getMeterConnection().get(0)).getCurrentReadingDate());
            String yearName = formatterYear.format((Object)((MeterReadingConnectionDetails)waterConnectionDetails.getMeterConnection().get(0)).getCurrentReadingDate());
            Map reportParams = this.prepareReportParams(waterConnectionDetails, session, formatter, assessmentDetails, ownerName.toString(), billObj, meterReadingpriviousObj, monthName, yearName);
            reportInput = new ReportRequest(METERDEMAND_NOTICE, (Object)waterConnectionDetails, reportParams);
            reportInput.setPrintDialogOnOpenReport(true);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=DemandNotice.pdf");
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    private Map<String, Object> prepareReportParams(WaterConnectionDetails waterConnectionDetails, HttpSession session, SimpleDateFormat formatter, AssessmentDetails assessmentDetails, String ownerName, EgBill billObj, MeterReadingConnectionDetails meterReadingpriviousObj, String monthName, String yearName) {
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        if ("NEWCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode()) || "ADDNLCONNECTION".equalsIgnoreCase(waterConnectionDetails.getApplicationType().getCode())) {
            reportParams.put("applicationType", WordUtils.capitalize((String)waterConnectionDetails.getApplicationType().getName()));
        }
        reportParams.put("municipality", session.getAttribute("citymunicipalityname"));
        reportParams.put("district", session.getAttribute("districtName"));
        reportParams.put("waterCharges", waterConnectionDetails.getConnectionType().name());
        reportParams.put("propertyassesmentNumber", waterConnectionDetails.getConnection().getPropertyIdentifier());
        reportParams.put("consumerNumber", waterConnectionDetails.getConnection().getConsumerCode());
        reportParams.put("pipeSize", waterConnectionDetails.getPipeSize().getSizeInInch());
        reportParams.put("mterSerialNumber", waterConnectionDetails.getConnection().getMeterSerialNumber());
        reportParams.put("applicantName", ownerName);
        reportParams.put("demandNoticeNumber", billObj != null && billObj.getBillNo() != null ? billObj.getBillNo() : "");
        reportParams.put("billMonth", monthName + "-" + yearName);
        reportParams.put("demandNoticeDate", billObj != null && billObj.getCreateDate() != null ? formatter.format(billObj.getCreateDate()) : null);
        reportParams.put("previousReading", meterReadingpriviousObj.getCurrentReading());
        if (meterReadingpriviousObj.getCurrentReadingDate() != null) {
            reportParams.put("previousReadingDate", formatter.format(meterReadingpriviousObj.getCurrentReadingDate()));
        } else {
            reportParams.put("previousReadingDate", "");
        }
        reportParams.put("currentReading", ((MeterReadingConnectionDetails)waterConnectionDetails.getMeterConnection().get(0)).getCurrentReading());
        reportParams.put("currrentReadingDate", formatter.format(((MeterReadingConnectionDetails)waterConnectionDetails.getMeterConnection().get(0)).getCurrentReadingDate()));
        if (meterReadingpriviousObj.getCurrentReading() != null && !waterConnectionDetails.getMeterConnection().isEmpty() && ((MeterReadingConnectionDetails)waterConnectionDetails.getMeterConnection().get(0)).getCurrentReading() != null) {
            reportParams.put("noofunitsconsume", ((MeterReadingConnectionDetails)waterConnectionDetails.getMeterConnection().get(0)).getCurrentReading() - meterReadingpriviousObj.getCurrentReading());
        }
        reportParams.put("totalBilltoCollect", this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails));
        reportParams.put("currentMonthCharges", this.getCurrentMonthDemandAmount(waterConnectionDetails, ((MeterReadingConnectionDetails)waterConnectionDetails.getMeterConnection().get(0)).getCurrentReadingDate()));
        reportParams.put("totalDueAmount", this.getTotalDue(waterConnectionDetails, ((MeterReadingConnectionDetails)waterConnectionDetails.getMeterConnection().get(0)).getCurrentReadingDate()));
        reportParams.put("address", assessmentDetails.getPropertyAddress());
        return reportParams;
    }

    public BigDecimal getTotalDue(WaterConnectionDetails waterConnectionDetails, Date givenDate) {
        BigDecimal balance = this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails);
        BigDecimal demnadDetCurrentamount = this.getCurrentMonthDemandAmount(waterConnectionDetails, givenDate);
        balance = balance.subtract(demnadDetCurrentamount);
        return balance;
    }

    private BigDecimal getCurrentMonthDemandAmount(WaterConnectionDetails waterConnectionDetails, Date givenDate) {
        BigDecimal currentAmount = BigDecimal.ZERO;
        Installment installment = this.connectionDemandService.getCurrentInstallment("Water Tax Management", "Monthly", givenDate);
        EgDemandReason demandReasonObj = this.connectionDemandService.getDemandReasonByCodeAndInstallment("WTAXCHARGES", installment);
        List demnadDetList = this.demandGenericDao.getDemandDetailsForDemandAndReasons(this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand(), Arrays.asList(demandReasonObj));
        if (!demnadDetList.isEmpty()) {
            int detLength = demnadDetList.size() - 1;
            if (((EgDemandDetails)demnadDetList.get(0)).getAmount() != null) {
                currentAmount = ((EgDemandDetails)demnadDetList.get(detLength)).getAmount();
            }
        }
        return currentAmount;
    }

    @RequestMapping(value={"/meterdemandnotice/view/{applicationNumber}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewEstimationNotice(@PathVariable String applicationNumber, HttpSession session) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNumber);
        return this.generateReport(waterConnectionDetails, session);
    }
}

