/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.util.List;
import javax.validation.ValidationException;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.LinkedAssessment;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class LinkedAssessmentController {
    public static final String LINKED_ASSESSMENT = "linked-assessment";
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;

    @RequestMapping(value={"/linkedAssessment"}, method={RequestMethod.GET})
    public String viewForm(Model model) {
        model.addAttribute("linkedAssessment", (Object)new LinkedAssessment());
        return LINKED_ASSESSMENT;
    }

    @RequestMapping(value={"/linkedAssessment"}, method={RequestMethod.POST})
    public String linkActiveAssessments(@ModelAttribute LinkedAssessment linkedAssessment, BindingResult resultBinder, RedirectAttributes redirectAttrs, Model model) {
        if (linkedAssessment.getPropertyAssessmentDetails().getStatus().equalsIgnoreCase("ACTIVE")) {
            throw new ValidationException("err.assessment.no.active");
        }
        if (linkedAssessment.getActiveAssessmentDetails().getStatus().equalsIgnoreCase("INACTIVE")) {
            throw new ValidationException("err.assessment.no.inactive");
        }
        List waterconnectiondetailslist = this.waterConnectionDetailsService.getAllConnectionDetailsByPropertyID(linkedAssessment.getPropertyAssessmentDetails().getAssessmentNumber());
        List activeWaterConnectionDetailsList = this.waterConnectionDetailsService.getAllConnectionDetailsByPropertyID(linkedAssessment.getActiveAssessmentDetails().getAssessmentNumber());
        WaterConnection parentConnection = null;
        if (!activeWaterConnectionDetailsList.isEmpty()) {
            for (WaterConnectionDetails connectionDetails : activeWaterConnectionDetailsList) {
                if (connectionDetails.getConnection().getParentConnection() != null) continue;
                parentConnection = connectionDetails.getConnection();
            }
        }
        if (!waterconnectiondetailslist.isEmpty()) {
            for (WaterConnectionDetails connectionDetails : waterconnectiondetailslist) {
                WaterConnectionDetails waterconnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(connectionDetails.getConnection().getConsumerCode(), ConnectionStatus.ACTIVE);
                waterconnectionDetails.getConnection().setPropertyIdentifier(linkedAssessment.getActiveAssessmentDetails().getAssessmentNumber());
                if (!activeWaterConnectionDetailsList.isEmpty()) {
                    waterconnectionDetails.getConnection().setParentConnection(parentConnection);
                    waterconnectionDetails.setApplicationType(this.applicationTypeService.findByCode("ADDNLCONNECTION"));
                }
                this.waterConnectionDetailsService.save(waterconnectionDetails);
                AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterconnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
                this.waterConnectionDetailsService.createWaterChargeIndex(waterconnectionDetails, assessmentDetails, this.waterConnectionDetailsService.getTotalAmount(waterconnectionDetails));
            }
            model.addAttribute("propertyIdentifier", (Object)linkedAssessment.getActiveAssessmentDetails().getAssessmentNumber());
            return "linkedassessment-success";
        }
        throw new ValidationException("err.no.active.connections");
    }
}

