/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.WordUtils;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.reporting.engine.ReportFormat;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ReportGenerationService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/application"})
public class EstimationNoticeController {
    @Autowired
    private ReportService reportService;
    public static final String ESTIMATION_NOTICE = "estimationNotice";
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ReportGenerationService reportGenerationService;
    @Autowired
    private FileStoreService fileStoreService;

    @RequestMapping(value={"/estimationNotice"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateEstimationNotice(HttpServletRequest request, HttpSession session) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(request.getParameter("pathVar"));
        return this.generateReport(waterConnectionDetails, session);
    }

    private ResponseEntity<byte[]> generateReport(WaterConnectionDetails waterConnectionDetails, HttpSession session) {
        ReportRequest reportInput = null;
        ReportOutput reportOutput = new ReportOutput();
        if (waterConnectionDetails != null) {
            if (waterConnectionDetails.getEstimationNoticeFileStoreId() != null) {
                FileStoreMapper fmp = waterConnectionDetails.getEstimationNoticeFileStoreId();
                File file = this.fileStoreService.fetch(fmp, "WTMS");
                reportOutput = new ReportOutput();
                try {
                    reportOutput.setReportOutputData(FileUtils.readFileToByteArray((File)file));
                    reportOutput.setReportFormat(ReportFormat.PDF);
                }
                catch (IOException e) {
                    throw new ApplicationRuntimeException("Exception in generating work order notice" + e);
                }
            } else {
                HashMap<String, Object> reportParams = new HashMap<String, Object>();
                SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
                AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
                String[] doorNo = assessmentDetails.getPropertyAddress().split(",");
                StringBuilder ownerName = new StringBuilder();
                for (OwnerName names : assessmentDetails.getOwnerNames()) {
                    if (assessmentDetails.getOwnerNames().size() > 1) {
                        ownerName.append(", ");
                    }
                    ownerName.append(names.getOwnerName());
                }
                reportParams.put("applicationType", WordUtils.capitalize((String)waterConnectionDetails.getApplicationType().getName()));
                reportParams.put("cityName", session.getAttribute("citymunicipalityname"));
                reportParams.put("district", session.getAttribute("districtName"));
                reportParams.put("estimationDate", formatter.format(waterConnectionDetails.getFieldInspectionDetails().getCreatedDate()));
                reportParams.put("estimationNumber", waterConnectionDetails.getEstimationNumber());
                reportParams.put("donationCharges", waterConnectionDetails.getDonationCharges());
                double totalCharges = waterConnectionDetails.getDonationCharges() + waterConnectionDetails.getFieldInspectionDetails().getSupervisionCharges() + waterConnectionDetails.getFieldInspectionDetails().getRoadCuttingCharges() + waterConnectionDetails.getFieldInspectionDetails().getSecurityDeposit();
                reportParams.put("totalCharges", totalCharges);
                reportParams.put("applicationDate", formatter.format(waterConnectionDetails.getApplicationDate()));
                reportParams.put("applicantName", ownerName.toString());
                reportParams.put("address", assessmentDetails.getPropertyAddress());
                reportParams.put("houseNo", doorNo[0]);
                reportParams.put("propertyID", waterConnectionDetails.getConnection().getPropertyIdentifier());
                reportParams.put("amountInWords", this.reportGenerationService.getTotalAmntInWords(Double.valueOf(totalCharges)));
                reportParams.put("securityDeposit", waterConnectionDetails.getFieldInspectionDetails().getSecurityDeposit());
                reportParams.put("roadCuttingCharges", waterConnectionDetails.getFieldInspectionDetails().getRoadCuttingCharges());
                reportParams.put("superVisionCharges", waterConnectionDetails.getFieldInspectionDetails().getSupervisionCharges());
                reportInput = new ReportRequest(ESTIMATION_NOTICE, (Object)waterConnectionDetails, reportParams);
                reportOutput = this.reportService.createReport(reportInput);
            }
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=EstimationNotice.pdf");
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/estimationNotice/view/{applicationNumber}"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> viewEstimationNotice(@PathVariable String applicationNumber, HttpSession session) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNumber);
        return this.generateReport(waterConnectionDetails, session);
    }
}

