/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.math.BigDecimal;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.egov.commons.Installment;
import org.egov.demand.model.EgDemandDetails;
import org.egov.demand.model.EgDemandReason;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.wtms.application.entity.DemandDetail;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.repository.WaterConnectionDetailsRepository;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.WaterTaxUtils;
import org.egov.wtms.utils.constants.WaterTaxConstants;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class EditDemandForDataEntryController {
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    private final WaterConnectionDetailsRepository waterConnectionDetailsRepository;
    private final ConnectionDemandService connectionDemandService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;

    @Autowired
    public EditDemandForDataEntryController(WaterConnectionDetailsRepository waterConnectionDetailsRepository, ConnectionDemandService connectionDemandService) {
        this.waterConnectionDetailsRepository = waterConnectionDetailsRepository;
        this.connectionDemandService = connectionDemandService;
    }

    @ModelAttribute
    public WaterConnectionDetails getWaterConnectionDetails(@PathVariable String consumerCode) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
        return waterConnectionDetails;
    }

    @RequestMapping(value={"/editDemand/{consumerCode}"}, method={RequestMethod.GET})
    public String newForm(Model model, @PathVariable String consumerCode, @ModelAttribute WaterConnectionDetails waterConnectionDetails, HttpServletRequest request) {
        return this.loadViewData(model, waterConnectionDetails);
    }

    private String loadViewData(Model model, WaterConnectionDetails waterConnectionDetails) {
        ArrayList<DemandDetail> demandDetailBeanList = new ArrayList<DemandDetail>();
        LinkedHashSet<DemandDetail> tempDemandDetail = new LinkedHashSet<DemandDetail>();
        List allInstallments = new ArrayList();
        SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MM/yyyy");
        try {
            allInstallments = waterConnectionDetails.getConnectionType().toString().equals("METERED") ? this.waterTaxUtils.getMonthlyInstallments(dateFormat.parse(dateFormat.format(waterConnectionDetails.getExecutionDate()))) : this.waterTaxUtils.getInstallmentsForCurrYear(dateFormat.parse(dateFormat.format(waterConnectionDetails.getExecutionDate())));
        }
        catch (ParseException e) {
            throw new ApplicationRuntimeException("Error while getting all installments from start date", (Throwable)e);
        }
        DemandDetail dmdDtl = null;
        for (Map.Entry entry : WaterTaxConstants.NON_METERED_DMDRSN_CODE_MAP.entrySet()) {
            for (Installment installObj : allInstallments) {
                EgDemandReason demandReasonObj = this.connectionDemandService.getDemandReasonByCodeAndInstallment((String)entry.getKey(), installObj);
                if (demandReasonObj != null) {
                    EgDemandDetails demanddet = null;
                    if (this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand() != null) {
                        demanddet = this.getDemandDetailsExist(waterConnectionDetails, demandReasonObj);
                    }
                    dmdDtl = demanddet != null ? this.createDemandDetailBean(installObj, demandReasonObj.getEgDemandReasonMaster().getCode(), (String)entry.getValue(), demanddet.getAmount(), demanddet.getAmtCollected(), demanddet.getId(), waterConnectionDetails) : this.createDemandDetailBean(installObj, (String)entry.getKey(), (String)entry.getValue(), BigDecimal.ZERO, BigDecimal.ZERO, null, waterConnectionDetails);
                }
                tempDemandDetail.add(dmdDtl);
            }
        }
        for (DemandDetail demandDetList : tempDemandDetail) {
            if (demandDetList == null) continue;
            demandDetailBeanList.add(demandDetList);
        }
        BigDecimal waterTaxDueforParent = this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails);
        model.addAttribute("mode", (Object)"editdemand");
        model.addAttribute("waterTaxDueforParent", (Object)waterTaxDueforParent);
        model.addAttribute("demandDetailBeanList", demandDetailBeanList);
        model.addAttribute("waterConnectionDetails", (Object)waterConnectionDetails);
        model.addAttribute("current1HalfInstallment", !demandDetailBeanList.isEmpty() && demandDetailBeanList.size() > 1 ? ((DemandDetail)demandDetailBeanList.get(demandDetailBeanList.size() - 2)).getInstallment() : null);
        model.addAttribute("current2HalfInstallment", !demandDetailBeanList.isEmpty() ? ((DemandDetail)demandDetailBeanList.get(demandDetailBeanList.size() - 1)).getInstallment() : null);
        model.addAttribute("connectionType", this.waterConnectionDetailsService.getConnectionTypesMap().get(waterConnectionDetails.getConnectionType().name()));
        return "editDemandDateEntry-newForm";
    }

    private EgDemandDetails getDemandDetailsExist(WaterConnectionDetails waterConnectionDetails, EgDemandReason demandReasonObj) {
        EgDemandDetails demandDet = null;
        for (EgDemandDetails dd : this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand().getEgDemandDetails()) {
            if (!dd.getEgDemandReason().equals((Object)demandReasonObj)) continue;
            demandDet = dd;
            break;
        }
        return demandDet;
    }

    private DemandDetail createDemandDetailBean(Installment installment, String reasonMaster, String reasonMasterDesc, BigDecimal amount, BigDecimal amountCollected, Long demanddetailId, WaterConnectionDetails waterConnectionDetails) {
        EgDemandDetails demandDetailsObj = null;
        if (demanddetailId != null && this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand() != null) {
            demandDetailsObj = this.waterConnectionDetailsRepository.findEgDemandDetailById(demanddetailId);
        }
        DemandDetail demandDetail = new DemandDetail();
        demandDetail.setInstallment(installment.getDescription());
        demandDetail.setReasonMaster(reasonMaster);
        demandDetail.setId(demanddetailId);
        if (demandDetailsObj != null) {
            demandDetail.setActualAmount(amount);
            demandDetail.setActualCollection(amountCollected);
        } else {
            demandDetail.setActualAmount(amount);
            demandDetail.setActualCollection(amountCollected);
        }
        demandDetail.setReasonMasterDesc(reasonMasterDesc);
        return demandDetail;
    }

    @RequestMapping(value={"/editDemand/{consumerCode}"}, method={RequestMethod.POST})
    public String updateMeterEntry(@ModelAttribute WaterConnectionDetails waterConnectionDetails, BindingResult errors, RedirectAttributes redirectAttrs, Model model, HttpServletRequest request) {
        String sourceChannel = request.getParameter("Source");
        WaterConnectionDetails connectionDetails = this.connectionDemandService.updateDemandForNonMeteredConnectionDataEntry(waterConnectionDetails, sourceChannel);
        model.addAttribute("waterConnectionDetails", (Object)connectionDetails);
        return "editDemand-dataEntryAck";
    }
}

