/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.ValidationException;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.ClosedConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.CloserConnectionService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class ClosedConnectionController {
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private CloserConnectionService closerConnectionService;

    @RequestMapping(value={"/closedConsumerCode/{consumerCode}"}, method={RequestMethod.GET})
    public String view(Model model, @PathVariable String consumerCode, HttpServletRequest request) {
        String validationMessage = "";
        ClosedConnection closedConnection = new ClosedConnection();
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
        if (waterConnectionDetails != null) {
            validationMessage = this.closerConnectionService.validateChangeOfUseConnection(waterConnectionDetails);
        }
        model.addAttribute("validationMessage", (Object)validationMessage);
        closedConnection.setConsumerNo(consumerCode);
        model.addAttribute("closedConnection", (Object)closedConnection);
        return "closed-consumercode";
    }

    @RequestMapping(value={"/closedConsumerCode/{consumerCode}"}, method={RequestMethod.POST})
    public String closeConnection(@Valid @ModelAttribute ClosedConnection closedConnection, @PathVariable String consumerCode, BindingResult resultBinder, RedirectAttributes redirectAttrs, Model model) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
        if (waterConnectionDetails == null) {
            throw new ValidationException("err.hsc.no.inactive");
        }
        waterConnectionDetails.setCloseApprovalDate(closedConnection.getClosedDate());
        waterConnectionDetails.setReferenceNumber(closedConnection.getReferenceNo());
        waterConnectionDetails.setDeactivateReason(closedConnection.getDeactivateReason());
        waterConnectionDetails.setConnectionStatus(ConnectionStatus.INACTIVE);
        this.waterConnectionDetailsService.save(waterConnectionDetails);
        AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL);
        this.waterConnectionDetailsService.createWaterChargeIndex(waterConnectionDetails, assessmentDetails, this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails));
        model.addAttribute("consumerCode", (Object)consumerCode);
        return "closedconnection-success";
    }
}

