/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import com.google.gson.JsonObject;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.egov.infra.admin.master.entity.AppConfigValues;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.NewConnectionService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.ApplicationProcessTime;
import org.egov.wtms.masters.entity.ConnectionCategory;
import org.egov.wtms.masters.entity.DonationDetails;
import org.egov.wtms.masters.entity.DonationHeader;
import org.egov.wtms.masters.entity.PipeSize;
import org.egov.wtms.masters.entity.PropertyType;
import org.egov.wtms.masters.entity.UsageType;
import org.egov.wtms.masters.entity.WaterRatesDetails;
import org.egov.wtms.masters.entity.WaterRatesHeader;
import org.egov.wtms.masters.entity.WaterSource;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.masters.service.ApplicationProcessTimeService;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.masters.service.ConnectionCategoryService;
import org.egov.wtms.masters.service.DonationDetailsService;
import org.egov.wtms.masters.service.DonationHeaderService;
import org.egov.wtms.masters.service.PipeSizeService;
import org.egov.wtms.masters.service.UsageTypeService;
import org.egov.wtms.masters.service.WaterRatesDetailsService;
import org.egov.wtms.masters.service.WaterRatesHeaderService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class AjaxConnectionController {
    @Autowired
    private NewConnectionService newConnectionService;
    @Autowired
    private DonationHeaderService donationHeaderService;
    @Autowired
    private UsageTypeService usageTypeService;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private WaterRatesHeaderService waterRatesHeaderService;
    @Autowired
    private WaterRatesDetailsService waterRatesDetailsService;
    @Autowired
    private PipeSizeService pipeSizeService;
    @Autowired
    private ConnectionCategoryService connectionCategoryService;
    @Autowired
    private DonationDetailsService donationDetailsService;
    @Autowired
    private ApplicationProcessTimeService applicationProcessTimeService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;

    @RequestMapping(value={"/ajaxconnection/check-primaryconnection-exists"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String isConnectionPresentForProperty(@RequestParam String propertyID) {
        return this.newConnectionService.checkConnectionPresentForProperty(propertyID);
    }

    @RequestMapping(value={"/ajaxconnection/assignmentByPositionId"}, method={RequestMethod.GET}, produces={"text/plain"})
    @ResponseBody
    public String getWorkFlowPositionByDepartmentAndDesignation(@RequestParam Long approvalPositionId, HttpServletResponse response) {
        return this.waterConnectionDetailsService.getApprovalPositionOnValidate(approvalPositionId);
    }

    @RequestMapping(value={"/ajax-CategoryTypeByPropertyType"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<ConnectionCategory> getAllCategoryTypesByPropertyType(@RequestParam Long propertyType, @RequestParam String connectionType) {
        List categoryTypes = this.connectionCategoryService.getAllActiveCategoryTypesByPropertyType(propertyType, connectionType);
        categoryTypes.forEach(categoryType -> categoryType.toString());
        return categoryTypes;
    }

    @RequestMapping(value={"/ajax-UsageTypeByPropertyType"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<UsageType> getAllUsageTypesByPropertyType(@RequestParam Long propertyType) {
        List usageTypes = this.usageTypeService.getAllActiveUsageTypesByPropertyType(propertyType);
        usageTypes.forEach(usageType -> usageType.toString());
        return usageTypes;
    }

    @RequestMapping(value={"/ajax-PipeSizesByPropertyType"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public List<PipeSize> getAllPipeSizesByPropertyType(@RequestParam Long propertyType) {
        List pipesizes = this.pipeSizeService.getAllPipeSizesByPropertyType(propertyType);
        pipesizes.forEach(pipesize -> pipesize.toString());
        return pipesizes;
    }

    @RequestMapping(value={"/ajax-meterReadingEntryExist"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Boolean getMeterReadingEntryExist(@ModelAttribute(value="waterConnectionDetails") @RequestParam Date givenDate, @RequestParam String requestConsumerCode) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(requestConsumerCode);
        return this.connectionDemandService.meterEntryAllReadyExistForCurrentMonth(waterConnectionDetails, givenDate);
    }

    @RequestMapping(value={"/ajax-consumerCodeExistFordataEntry"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public Boolean validateconsumerNumberForDataEntry(@ModelAttribute(value="waterConnectionDetails") @RequestParam String consumerCode) {
        WaterConnectionDetails waterConnectionDetails;
        Boolean enteredMonthReadingExist = Boolean.FALSE;
        if (consumerCode != null && (waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(consumerCode)) != null && waterConnectionDetails.getConnection().getConsumerCode().equals(consumerCode)) {
            enteredMonthReadingExist = Boolean.TRUE;
        }
        return enteredMonthReadingExist;
    }

    @RequestMapping(value={"/ajax-donationheadercombination"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getDonationAmountByAllCombinatons(@RequestParam PropertyType propertyType, @RequestParam ConnectionCategory categoryType, @RequestParam UsageType usageType, @RequestParam Long maxPipeSize, @RequestParam Long minPipeSize, @RequestParam Date fromDate, @RequestParam Date toDate, @RequestParam Boolean activeid) {
        SimpleDateFormat dateformat = new SimpleDateFormat("dd-MM-yyyy");
        PipeSize minPipesizeObj = this.pipeSizeService.findOne(minPipeSize);
        PipeSize maxPipesizeObj = this.pipeSizeService.findOne(maxPipeSize);
        List donationHeaderTempList = this.donationHeaderService.findDonationDetailsByPropertyAndCategoryAndUsageandPipeSize(propertyType, categoryType, usageType, minPipesizeObj.getSizeInInch(), maxPipesizeObj.getSizeInInch());
        DonationDetails donationDetails = null;
        if (!donationHeaderTempList.isEmpty()) {
            DonationHeader donationHeaderTemp;
            Iterator iterator = donationHeaderTempList.iterator();
            while (iterator.hasNext() && (donationDetails = this.donationDetailsService.findByDonationHeaderAndFromDateAndToDate(donationHeaderTemp = (DonationHeader)iterator.next(), fromDate, toDate)) == null) {
            }
        }
        if (donationDetails != null && donationDetails.getDonationHeader().isActive() == activeid.booleanValue()) {
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("maxPipeSize", donationDetails.getDonationHeader().getMaxPipeSize().getCode());
            jsonObj.addProperty("minPipeSize", donationDetails.getDonationHeader().getMinPipeSize().getCode());
            jsonObj.addProperty("fromDate", dateformat.format(donationDetails.getFromDate()).toString());
            jsonObj.addProperty("toDate", dateformat.format(donationDetails.getToDate()).toString());
            return jsonObj.toString();
        }
        return "";
    }

    @RequestMapping(value={"/ajax-minimumpipesizeininch"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public double getMinimumPipeSizeInInch(@RequestParam Long minPipeSize) {
        PipeSize minPipesizeObj = this.pipeSizeService.findOne(minPipeSize);
        return minPipesizeObj.getSizeInInch();
    }

    @RequestMapping(value={"/ajax-maximumpipesizeininch"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public double getMaximumPipeSizeInInch(@RequestParam Long maxPipeSize) {
        PipeSize maxPipesizeObj = this.pipeSizeService.findOne(maxPipeSize);
        return maxPipesizeObj.getSizeInInch();
    }

    @RequestMapping(value={"/ajax-WaterRatescombination"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String geWaterRatesByAllCombinatons(@ModelAttribute(value="waterRatesHeader") @RequestParam ConnectionType categoryType, @RequestParam WaterSource waterSource, @RequestParam UsageType usageType, @RequestParam PipeSize pipeSize, @RequestParam Date fromDate, @RequestParam Date toDate, @RequestParam Boolean activeid) {
        SimpleDateFormat dateformat = new SimpleDateFormat("dd-MM-yyyy");
        List waterRatesHeaderList = this.waterRatesHeaderService.findByConnectionTypeAndUsageTypeAndWaterSourceAndPipeSize(categoryType, usageType, waterSource, pipeSize);
        WaterRatesDetails waterRatesDetails = null;
        if (!waterRatesHeaderList.isEmpty()) {
            WaterRatesHeader waterRatesHeaderTemp;
            Iterator iterator = waterRatesHeaderList.iterator();
            while (iterator.hasNext() && (waterRatesDetails = this.waterRatesDetailsService.findByWaterRatesHeaderAndFromDateAndToDate(waterRatesHeaderTemp = (WaterRatesHeader)iterator.next(), fromDate, toDate)) == null) {
            }
        }
        if (waterRatesDetails != null && waterRatesDetails.getWaterRatesHeader().isActive() == activeid.booleanValue()) {
            JsonObject jsonObj = new JsonObject();
            jsonObj.addProperty("fromDate", dateformat.format(waterRatesDetails.getFromDate()).toString());
            jsonObj.addProperty("toDate", dateformat.format(waterRatesDetails.getToDate()).toString());
            return jsonObj.toString();
        }
        return "";
    }

    @RequestMapping(value={"/ajax-getapplicationprocesstime"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public double getApplicationProcessTime(@RequestParam Long applicationType, @RequestParam Long categoryType) {
        ApplicationProcessTime applicationprocessTime = this.applicationProcessTimeService.findByApplicationTypeandCategory(this.applicationTypeService.findBy(applicationType), this.connectionCategoryService.findOne(categoryType));
        if (applicationprocessTime == null) {
            return 0.0;
        }
        return applicationprocessTime.getProcessingTime().intValue();
    }

    @RequestMapping(value={"/ajax-isdonationamount-editable"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public boolean isDonationChargesEditAllowed(@RequestParam String connectionType) {
        if (connectionType == null) {
            return false;
        }
        List appConfigValues = connectionType.equalsIgnoreCase("Metered") ? this.waterTaxUtils.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "IS_METEREDDONATIONAMOUNT_MANUAL") : this.waterTaxUtils.getAppConfigValueByModuleNameAndKeyName("Water Tax Management", "IS_NONMETEREDDONATIONAMOUNT_MANUAL");
        if (appConfigValues != null && !appConfigValues.isEmpty()) {
            return "YES".equalsIgnoreCase(((AppConfigValues)appConfigValues.get(0)).getValue());
        }
        return false;
    }

    @RequestMapping(value={"/ajax-getPropertyIdByConsumerCode"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public String getPropertyIdentifier(@RequestParam String consumerCode) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(consumerCode, ConnectionStatus.ACTIVE);
        if (waterConnectionDetails == null) {
            return "";
        }
        return waterConnectionDetails.getConnection().getPropertyIdentifier();
    }
}

