/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.ValidationException;
import org.apache.commons.lang3.StringUtils;
import org.egov.commons.entity.Source;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Position;
import org.egov.wtms.application.entity.ApplicationDocuments;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.AdditionalConnectionService;
import org.egov.wtms.application.service.ConnectionDetailService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionService;
import org.egov.wtms.masters.entity.DocumentNames;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.egov.wtms.web.controller.application.GenericConnectionController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class AdditionalConnectionController
extends GenericConnectionController {
    private static final String MEESEVAAPPLICATIONNUMBER = "meesevaApplicationNumber";
    private static final String APPROVALPOSITION = "approvalPosition";
    private static final String ADDCONNECTION_FORM = "addconnection-form";
    private static final String STATETYPE = "stateType";
    private static final String ADDITIONALTULE = "additionalRule";
    private static final String CURRENTUSER = "currentUser";
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    private WaterConnectionService waterConnectionService;
    @Autowired
    private AdditionalConnectionService additionalConnectionService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private ConnectionDetailService connectionDetailService;

    @ModelAttribute(value="documentNamesList")
    public List<DocumentNames> documentNamesList(@ModelAttribute WaterConnectionDetails addConnection) {
        addConnection.setApplicationType(this.applicationTypeService.findByCode("ADDNLCONNECTION"));
        return this.waterConnectionDetailsService.getAllActiveDocumentNames(addConnection.getApplicationType());
    }

    @RequestMapping(value={"/addconnection/{consumerCode}"}, method={RequestMethod.GET})
    public String showAdditionalApplicationForm(WaterConnectionDetails parentConnectionDetails, @ModelAttribute WaterConnectionDetails addConnection, Model model, @PathVariable String consumerCode, HttpServletRequest request) {
        String meesevaApplicationNumber = request.getParameter(MEESEVAAPPLICATIONNUMBER);
        WaterConnection connection = this.waterConnectionService.findByConsumerCode(consumerCode);
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setAdditionalRule(addConnection.getApplicationType().getCode());
        this.prepareWorkflow(model, (StateAware)addConnection, workflowContainer);
        parentConnectionDetails = this.waterConnectionDetailsService.getParentConnectionDetails(connection.getPropertyIdentifier(), ConnectionStatus.ACTIVE);
        this.loadBasicDetails(addConnection, model, parentConnectionDetails, meesevaApplicationNumber);
        return ADDCONNECTION_FORM;
    }

    private void loadBasicDetails(WaterConnectionDetails addConnection, Model model, WaterConnectionDetails parentConnectionDetails, String meesevaApplicationNumber) {
        addConnection.setConnectionStatus(ConnectionStatus.INPROGRESS);
        model.addAttribute("parentConnection", (Object)parentConnectionDetails.getConnection());
        model.addAttribute("waterConnectionDetails", (Object)parentConnectionDetails);
        model.addAttribute("connectionType", this.waterConnectionDetailsService.getConnectionTypesMap().get(parentConnectionDetails.getConnectionType().name()));
        model.addAttribute("addConnection", (Object)addConnection);
        model.addAttribute(STATETYPE, (Object)parentConnectionDetails.getClass().getSimpleName());
        model.addAttribute(CURRENTUSER, (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute(ADDITIONALTULE, (Object)addConnection.getApplicationType().getCode());
        model.addAttribute("mode", (Object)"addconnection");
        model.addAttribute("validationMessage", (Object)this.additionalConnectionService.validateAdditionalConnection(parentConnectionDetails));
        BigDecimal waterTaxDueforParent = this.waterConnectionDetailsService.getTotalAmount(parentConnectionDetails);
        model.addAttribute("waterTaxDueforParent", (Object)waterTaxDueforParent);
        Boolean loggedUserIsMeesevaUser = this.waterTaxUtils.isMeesevaUser(this.securityUtils.getCurrentUser());
        if (loggedUserIsMeesevaUser.booleanValue()) {
            if (meesevaApplicationNumber == null) {
                throw new ApplicationRuntimeException("MEESEVA.005");
            }
            addConnection.setMeesevaApplicationNumber(meesevaApplicationNumber);
        }
        model.addAttribute("typeOfConnection", (Object)"ADDNLCONNECTION");
        model.addAttribute("citizenPortalUser", (Object)this.waterTaxUtils.isCitizenPortalUser(this.securityUtils.getCurrentUser()));
        model.addAttribute("isAnonymousUser", (Object)this.waterTaxUtils.isAnonymousUser(this.securityUtils.getCurrentUser()));
    }

    @RequestMapping(value={"/addconnection/addConnection-create"}, method={RequestMethod.POST})
    public String create(@Valid @ModelAttribute WaterConnectionDetails addConnection, BindingResult resultBinder, RedirectAttributes redirectAttributes, Model model, @RequestParam String workFlowAction, HttpServletRequest request, BindingResult errors) {
        Boolean applicationByOthers;
        Boolean isJuniorAsstOrSeniorAsst;
        Boolean isCSCOperator = this.waterTaxUtils.isCSCoperator(this.securityUtils.getCurrentUser());
        Boolean citizenPortalUser = this.waterTaxUtils.isCitizenPortalUser(this.securityUtils.getCurrentUser());
        Boolean loggedUserIsMeesevaUser = this.waterTaxUtils.isMeesevaUser(this.securityUtils.getCurrentUser());
        Boolean isAnonymousUser = this.waterTaxUtils.isAnonymousUser(this.securityUtils.getCurrentUser());
        model.addAttribute("isAnonymousUser", (Object)isAnonymousUser);
        if (loggedUserIsMeesevaUser.booleanValue() && request.getParameter(MEESEVAAPPLICATIONNUMBER) != null) {
            addConnection.setMeesevaApplicationNumber(request.getParameter(MEESEVAAPPLICATIONNUMBER));
        }
        model.addAttribute("citizenPortalUser", (Object)citizenPortalUser);
        if (!(isCSCOperator.booleanValue() || citizenPortalUser.booleanValue() || loggedUserIsMeesevaUser.booleanValue() || isAnonymousUser.booleanValue() || (isJuniorAsstOrSeniorAsst = this.waterTaxUtils.isLoggedInUserJuniorOrSeniorAssistant(this.securityUtils.getCurrentUser().getId())).booleanValue())) {
            throw new ValidationException("err.creator.application");
        }
        String sourceChannel = request.getParameter("Source");
        WaterConnectionDetails parent = this.waterConnectionDetailsService.getActiveConnectionDetailsByConnection(addConnection.getConnection().getParentConnection());
        String message = this.additionalConnectionService.validateAdditionalConnection(parent);
        if (!message.isEmpty() && !"".equals(message)) {
            return "redirect:/application/addconnection/" + addConnection.getConnection().getParentConnection().getConsumerCode();
        }
        ArrayList<ApplicationDocuments> applicationDocs = new ArrayList<ApplicationDocuments>();
        int i = 0;
        if (!addConnection.getApplicationDocs().isEmpty()) {
            for (ApplicationDocuments applicationDocument : addConnection.getApplicationDocs()) {
                String fieldError;
                if (applicationDocument.getDocumentNumber() == null && applicationDocument.getDocumentDate() != null) {
                    fieldError = "applicationDocs[" + i + "].documentNumber";
                    resultBinder.rejectValue(fieldError, "documentNumber.required");
                }
                if (applicationDocument.getDocumentNumber() != null && applicationDocument.getDocumentDate() == null) {
                    fieldError = "applicationDocs[" + i + "].documentDate";
                    resultBinder.rejectValue(fieldError, "documentDate.required");
                } else if (this.connectionDetailService.validApplicationDocument(applicationDocument)) {
                    applicationDocs.add(applicationDocument);
                }
                ++i;
            }
        }
        this.waterConnectionDetailsService.validateWaterRateAndDonationHeader(addConnection);
        if (addConnection.getState() == null) {
            addConnection.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CREATED", "WATERTAXAPPLICATION"));
        }
        if (resultBinder.hasErrors()) {
            WaterConnectionDetails parentConnectionDetails = this.waterConnectionDetailsService.getActiveConnectionDetailsByConnection(addConnection.getConnection());
            this.loadBasicDetails(addConnection, model, parentConnectionDetails, addConnection.getMeesevaApplicationNumber());
            WorkflowContainer workflowContainer = new WorkflowContainer();
            workflowContainer.setAdditionalRule(addConnection.getApplicationType().getCode());
            this.prepareWorkflow(model, (StateAware)addConnection, workflowContainer);
            model.addAttribute("approvalPosOnValidate", (Object)request.getParameter(APPROVALPOSITION));
            model.addAttribute(ADDITIONALTULE, (Object)addConnection.getApplicationType().getCode());
            model.addAttribute(STATETYPE, (Object)addConnection.getClass().getSimpleName());
            model.addAttribute(CURRENTUSER, (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
            return ADDCONNECTION_FORM;
        }
        addConnection.setApplicationDate(new Date());
        addConnection.getApplicationDocs().clear();
        addConnection.setApplicationDocs(applicationDocs);
        this.processAndStoreApplicationDocuments(addConnection);
        Long approvalPosition = 0L;
        String approvalComment = "";
        String workFlowActionValue = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComment = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowActionValue = request.getParameter("workFlowAction");
        }
        if (request.getParameter(APPROVALPOSITION) != null && !request.getParameter(APPROVALPOSITION).isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter(APPROVALPOSITION));
        }
        if ((applicationByOthers = this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser())) != null && applicationByOthers.equals(true) || citizenPortalUser.booleanValue() || isAnonymousUser.booleanValue()) {
            Position userPosition = this.waterTaxUtils.getZonalLevelClerkForLoggedInUser(addConnection.getConnection().getPropertyIdentifier());
            if (userPosition != null) {
                approvalPosition = userPosition.getId();
            } else {
                WaterConnectionDetails parentConnectionDetails = this.waterConnectionDetailsService.getActiveConnectionDetailsByConnection(addConnection.getConnection());
                this.loadBasicDetails(addConnection, model, parentConnectionDetails, null);
                WorkflowContainer workflowContainer = new WorkflowContainer();
                workflowContainer.setAdditionalRule(addConnection.getApplicationType().getCode());
                this.prepareWorkflow(model, (StateAware)addConnection, workflowContainer);
                model.addAttribute(ADDITIONALTULE, (Object)addConnection.getApplicationType().getCode());
                model.addAttribute(STATETYPE, (Object)addConnection.getClass().getSimpleName());
                model.addAttribute(CURRENTUSER, (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
                errors.rejectValue("connection.propertyIdentifier", "err.validate.connection.user.mapping", "err.validate.connection.user.mapping");
                model.addAttribute("noJAORSAMessage", (Object)"No JA/SA exists to forward the application.");
                return ADDCONNECTION_FORM;
            }
        }
        if (isAnonymousUser.booleanValue()) {
            addConnection.setSource(Source.ONLINE);
            sourceChannel = "ONLINE";
        }
        if (citizenPortalUser.booleanValue() && (addConnection.getSource() == null || StringUtils.isBlank((CharSequence)addConnection.getSource().toString()))) {
            addConnection.setSource(this.waterTaxUtils.setSourceOfConnection(this.securityUtils.getCurrentUser()));
        }
        if (loggedUserIsMeesevaUser.booleanValue()) {
            addConnection.setSource(Source.MEESEVA);
            if (addConnection.getMeesevaApplicationNumber() != null) {
                addConnection.setApplicationNumber(addConnection.getMeesevaApplicationNumber());
            }
        }
        this.waterConnectionDetailsService.createNewWaterConnection(addConnection, approvalPosition, approvalComment, addConnection.getApplicationType().getCode(), workFlowActionValue, sourceChannel);
        if (loggedUserIsMeesevaUser.booleanValue()) {
            return "redirect:/application/generate-meesevareceipt?transactionServiceNumber=" + addConnection.getApplicationNumber();
        }
        return "redirect:/application/citizeenAcknowledgement?pathVars=" + addConnection.getApplicationNumber();
    }
}

