/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Writer;
import java.math.BigDecimal;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ValidationException;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.log4j.Logger;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.repository.FileStoreMapperRepository;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infra.utils.JsonUtils;
import org.egov.wtms.application.entity.GenerateConnectionBill;
import org.egov.wtms.application.service.GenerateConnectionBillService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.entity.ApplicationType;
import org.egov.wtms.masters.entity.PropertyType;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.masters.service.PropertyTypeService;
import org.egov.wtms.reports.entity.GenerateConnectionBillAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/generateBill/search"})
public class GenerateConnectionBillController {
    @Autowired
    private PropertyTypeService propertyTypeService;
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    @Qualifier(value="fileStoreService")
    protected FileStoreService fileStoreService;
    @Autowired
    private GenerateConnectionBillService generateConnectionBillService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private FileStoreMapperRepository fileStoreMapperRepository;
    private static final Logger LOGGER = Logger.getLogger(GenerateConnectionBillController.class);

    @RequestMapping(method={RequestMethod.GET})
    public String search(Model model) {
        return "generateBill-Report";
    }

    @ModelAttribute
    public GenerateConnectionBill reportModel() {
        return new GenerateConnectionBill();
    }

    @ModelAttribute(value="zones")
    public List<Boundary> zones() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
    }

    @ModelAttribute(value="revenueWards")
    public List<Boundary> revenueWardList() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE");
    }

    @ModelAttribute(value="connectionTypes")
    public Map<String, String> connectionTypes() {
        return this.waterConnectionDetailsService.getNonMeteredConnectionTypesMap();
    }

    @ModelAttribute(value="propertyTypes")
    public List<PropertyType> propertyTypes() {
        return this.propertyTypeService.getAllActivePropertyTypes();
    }

    @ModelAttribute(value="applicationTypes")
    public List<ApplicationType> applicationTypes() {
        return this.applicationTypeService.findAll();
    }

    @RequestMapping(value={"/result"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void searchResult(HttpServletRequest request, HttpServletResponse response) throws IOException, ParseException {
        String result = null;
        List generateConnectionBillList = new ArrayList();
        generateConnectionBillList = this.generateConnectionBillService.getBillReportDetails(request.getParameter("zone"), request.getParameter("revenueWard"), request.getParameter("propertyType"), request.getParameter("applicationType"), request.getParameter("connectionType"), request.getParameter("consumerCode"), request.getParameter("houseNumber"), request.getParameter("assessmentNumber"));
        long foundRows = this.generateConnectionBillService.getTotalCountofBills(request.getParameter("zone"), request.getParameter("revenueWard"), request.getParameter("propertyType"), request.getParameter("applicationType"), request.getParameter("connectionType"), request.getParameter("consumerCode"), request.getParameter("houseNumber"), request.getParameter("assessmentNumber"));
        int count = generateConnectionBillList.size();
        LOGGER.info((Object)("Total count of records-->" + Long.valueOf(count)));
        new ArrayList();
        if (Long.valueOf(count) > 5000L) {
            new ArrayList();
        }
        result = "{ \"draw\":" + request.getParameter("draw") + ", \"recordsTotal\":" + foundRows + ", \"recordsFiltered\":" + foundRows + ", \"data\":" + JsonUtils.toJSON(generateConnectionBillList, GenerateConnectionBill.class, GenerateConnectionBillAdaptor.class) + ", \"recordsCount\":" + Long.valueOf(count) + "}";
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }

    @RequestMapping(value={"/result/{consumerCode}"}, method={RequestMethod.GET})
    public void getBillBySearchParameter(HttpServletRequest request, HttpServletResponse response, @PathVariable String consumerCode) {
        List waterChargesDocumentslist = this.generateConnectionBillService.getDocuments(consumerCode, this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(consumerCode).getApplicationType().getName());
        if (!waterChargesDocumentslist.isEmpty() && waterChargesDocumentslist.get(0) != null) {
            try {
                FileStoreMapper fsm = this.fileStoreMapperRepository.findByFileStoreId(waterChargesDocumentslist.get(0) + "");
                ArrayList<ByteArrayInputStream> pdfs = new ArrayList<ByteArrayInputStream>();
                File file = this.fileStoreService.fetch(fsm, "WTMS");
                byte[] bFile = FileUtils.readFileToByteArray((File)file);
                pdfs.add(new ByteArrayInputStream(bFile));
                this.getServletResponse(response, pdfs, consumerCode);
            }
            catch (Exception e) {
                throw new ValidationException(e.getMessage());
            }
        } else {
            throw new ValidationException("err.demand.notice");
        }
    }

    @RequestMapping(value={"/mergeAndDownload"}, method={RequestMethod.GET})
    public String mergeAndDownload(HttpServletRequest request, HttpServletResponse response) throws IOException, ParseException, ValidationException {
        long startTime = System.currentTimeMillis();
        List generateConnectionBillList = this.generateConnectionBillService.getBillReportDetails(request.getParameter("zone"), request.getParameter("revenueWard"), request.getParameter("propertyType"), request.getParameter("applicationType"), request.getParameter("connectionType"), request.getParameter("consumerCode"), request.getParameter("houseNumber"), request.getParameter("assessmentNumber"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of Bills : " + (generateConnectionBillList != null ? Integer.valueOf(generateConnectionBillList.size()) : BigDecimal.ZERO)));
        }
        ArrayList<ByteArrayInputStream> pdfs = new ArrayList<ByteArrayInputStream>();
        for (GenerateConnectionBill connectionbill : generateConnectionBillList) {
            if (connectionbill == null) continue;
            try {
                if (connectionbill.getFileStoreID().isEmpty()) continue;
                FileStoreMapper fsm = this.fileStoreMapperRepository.findByFileStoreId(connectionbill.getFileStoreID());
                File file = this.fileStoreService.fetch(fsm, "WTMS");
                byte[] bFile = FileUtils.readFileToByteArray((File)file);
                pdfs.add(new ByteArrayInputStream(bFile));
            }
            catch (Exception e) {
                LOGGER.debug((Object)("Entered into executeJob" + e));
            }
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of pdfs : " + (pdfs != null ? Integer.valueOf(pdfs.size()) : BigDecimal.ZERO)));
        }
        if (pdfs.isEmpty()) {
            throw new ValidationException("err.demand.notice");
        }
        this.getServletResponse(response, pdfs, "search_bill");
        long endTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("GenerateBill | mergeAndDownload | Time taken(ms) " + (endTime - startTime)));
            LOGGER.debug((Object)"Exit from mergeAndDownload method");
        }
        return null;
    }

    private HttpServletResponse getServletResponse(HttpServletResponse response, List<InputStream> pdfs, String filename) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] data = this.concatPDFs(pdfs, output);
            response.setHeader("Content-disposition", "attachment;filename=" + filename + ".pdf");
            response.setContentType("application/pdf");
            response.setContentLength(data.length);
            response.getOutputStream().write(data);
            return response;
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] concatPDFs(List<InputStream> streamOfPDFFiles, ByteArrayOutputStream outputStream) {
        Document document = null;
        try {
            List<InputStream> pdfs = streamOfPDFFiles;
            ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
            for (InputStream pdf : pdfs) {
                PdfReader pdfReader = new PdfReader(pdf);
                readers.add(pdfReader);
                if (null != document) continue;
                document = new Document(pdfReader.getPageSize(1));
            }
            PdfWriter writer = PdfWriter.getInstance(document, (OutputStream)outputStream);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            int pageOfCurrentReaderPDF = 0;
            for (PdfReader pdfReader : readers) {
                while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
                    document.newPage();
                    PdfImportedPage page = writer.getImportedPage(pdfReader, ++pageOfCurrentReaderPDF);
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                }
                pageOfCurrentReaderPDF = 0;
            }
            outputStream.flush();
            document.close();
            outputStream.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception in concat PDFs : ", (Throwable)e);
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ioe) {
                LOGGER.error((Object)"Exception in concat PDFs : ", (Throwable)ioe);
            }
        }
        return outputStream.toByteArray();
    }

    @RequestMapping(value={"/zipAndDownload"}, method={RequestMethod.GET})
    public String zipAndDownload(HttpServletRequest request, HttpServletResponse response) throws IOException, ParseException, ValidationException {
        long startTime = System.currentTimeMillis();
        List generateConnectionBillList = this.generateConnectionBillService.getBillReportDetails(request.getParameter("zone"), request.getParameter("revenueWard"), request.getParameter("propertyType"), request.getParameter("applicationType"), request.getParameter("connectionType"), request.getParameter("consumerCode"), request.getParameter("houseNumber"), request.getParameter("assessmentNumber"));
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Number of BIlls : " + (generateConnectionBillList != null ? Integer.valueOf(generateConnectionBillList.size()) : BigDecimal.ZERO)));
        }
        try {
            ZipOutputStream zipOutputStream = null;
            if (null != generateConnectionBillList && generateConnectionBillList.size() >= 0) {
                zipOutputStream = new ZipOutputStream((OutputStream)response.getOutputStream());
                response.setHeader("Content-disposition", "attachment;filename=searchbill.zip");
                response.setContentType("application/zip");
            }
            for (GenerateConnectionBill connectionbill : generateConnectionBillList) {
                try {
                    if (connectionbill.getFileStoreID().isEmpty()) continue;
                    FileStoreMapper fsm = this.fileStoreMapperRepository.findByFileStoreId(connectionbill.getFileStoreID());
                    File file = this.fileStoreService.fetch(fsm, "WTMS");
                    byte[] bFile = FileUtils.readFileToByteArray((File)file);
                    zipOutputStream = this.addFilesToZip((InputStream)new ByteArrayInputStream(bFile), file.getName(), zipOutputStream);
                }
                catch (Exception e) {
                    LOGGER.error((Object)"zipAndDownload : Getting demand notice failed ", (Throwable)e);
                }
            }
            zipOutputStream.closeEntry();
            zipOutputStream.close();
        }
        catch (IOException e) {
            LOGGER.error((Object)"Exception in Zip and Download : ", (Throwable)e);
        }
        long endTime = System.currentTimeMillis();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("GenerateBill | zipAndDownload | Time taken(ms) " + (endTime - startTime)));
            LOGGER.debug((Object)"Exit from zipAndDownload method");
        }
        return null;
    }

    private ZipOutputStream addFilesToZip(InputStream inputStream, String noticeNo, ZipOutputStream out) {
        byte[] buffer = new byte[1024];
        try {
            int len;
            out.setLevel(-1);
            out.putNextEntry(new ZipEntry(noticeNo.replaceAll("/", "_")));
            while ((len = inputStream.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            inputStream.close();
        }
        catch (IllegalArgumentException iae) {
            LOGGER.error((Object)"Exception in addFilesToZip : ", (Throwable)iae);
        }
        catch (FileNotFoundException fnfe) {
            LOGGER.error((Object)"Exception in addFilesToZip : ", (Throwable)fnfe);
        }
        catch (IOException ioe) {
            LOGGER.error((Object)"Exception in addFilesToZip : ", (Throwable)ioe);
        }
        return out;
    }
}

