/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.commons.Installment;
import org.egov.commons.dao.InstallmentDao;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.Module;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.ModuleService;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.utils.JsonUtils;
import org.egov.wtms.application.entity.BaseRegisterResult;
import org.egov.wtms.application.service.BaseRegisterReportService;
import org.egov.wtms.reports.entity.BaseRegisterResultAdaptor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/baseRegister"})
public class BaseRegisterReportController {
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private BaseRegisterReportService baseRegisterReportService;
    @Autowired
    private InstallmentDao installmentDao;
    @Autowired
    private ModuleService moduleService;

    @ModelAttribute(value="wards")
    public List<Boundary> wardBoundaries() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE");
    }

    @ModelAttribute
    public void getPropertyModel(Model model) {
        BaseRegisterResult baseRegisterResult = new BaseRegisterResult();
        model.addAttribute("baseRegisterResult", (Object)baseRegisterResult);
    }

    @RequestMapping(method={RequestMethod.GET})
    public String searchForm(Model model) {
        model.addAttribute("currDate", (Object)new Date());
        return "baseRegister-form";
    }

    @RequestMapping(value={"/result"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void springPaginationDataTableUpdate(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String ward = "";
        if (null != request.getParameter("ward")) {
            ward = request.getParameter("ward");
        }
        try {
            List baseRegisterResultList = this.baseRegisterReportService.getBaseRegisterReportDetails(ward);
            Module nonMeteredModule = this.moduleService.getModuleByName("Property Tax");
            Module meteredModule = this.moduleService.getModuleByName("Water Tax Management");
            Installment currInstallmentForNonMetered = this.installmentDao.getInsatllmentByModuleForGivenDate(nonMeteredModule, new Date());
            Installment currInstallmentForMetered = this.installmentDao.getInsatllmentByModuleForGivenDateAndInstallmentType(meteredModule, new Date(), "Monthly");
            for (BaseRegisterResult br : baseRegisterResultList) {
                if (br.getConnectionType().equals("NON_METERED")) {
                    br.setPeriod(currInstallmentForNonMetered.getDescription());
                    continue;
                }
                br.setPeriod(currInstallmentForMetered.getDescription());
            }
            String result = "{ \"data\":" + JsonUtils.toJSON((Collection)baseRegisterResultList, BaseRegisterResult.class, BaseRegisterResultAdaptor.class) + "}";
            response.setContentType("application/json");
            IOUtils.write((String)result, (Writer)response.getWriter());
        }
        catch (ParseException e) {
            throw new ApplicationRuntimeException("Error while getting base register report " + e);
        }
    }
}

