/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import javax.validation.ValidationException;
import org.apache.commons.lang3.ArrayUtils;
import org.egov.commons.entity.Source;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Position;
import org.egov.wtms.application.entity.ApplicationDocuments;
import org.egov.wtms.application.entity.WaterConnection;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.NewConnectionService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.application.service.WaterConnectionService;
import org.egov.wtms.masters.entity.ConnectionCategory;
import org.egov.wtms.masters.entity.DocumentNames;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.egov.wtms.web.controller.application.GenericConnectionController;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.FlashMap;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.RedirectView;

@Controller
@RequestMapping(value={"/application"})
public class NewConnectionController
extends GenericConnectionController {
    private static final Logger LOG = LoggerFactory.getLogger(NewConnectionController.class);
    private static final String ERROR_REQUIRED = "err.required";
    private final WaterConnectionDetailsService waterConnectionDetailsService;
    private final ApplicationTypeService applicationTypeService;
    private final ConnectionDemandService connectionDemandService;
    private final WaterConnectionService waterConnectionService;
    private final NewConnectionService newConnectionService;
    private final WaterTaxUtils waterTaxUtils;
    @Autowired
    private SecurityUtils securityUtils;

    @Autowired
    public NewConnectionController(WaterConnectionDetailsService waterConnectionDetailsService, ApplicationTypeService applicationTypeService, ConnectionDemandService connectionDemandService, WaterTaxUtils waterTaxUtils, NewConnectionService newConnectionService, WaterConnectionService waterConnectionService) {
        this.waterConnectionDetailsService = waterConnectionDetailsService;
        this.applicationTypeService = applicationTypeService;
        this.connectionDemandService = connectionDemandService;
        this.waterTaxUtils = waterTaxUtils;
        this.newConnectionService = newConnectionService;
        this.waterConnectionService = waterConnectionService;
    }

    @ModelAttribute(value="documentNamesList")
    public List<DocumentNames> documentNamesList(@ModelAttribute WaterConnectionDetails waterConnectionDetails) {
        waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode("NEWCONNECTION"));
        return this.waterConnectionDetailsService.getAllActiveDocumentNames(waterConnectionDetails.getApplicationType());
    }

    @RequestMapping(value={"/newConnection-newform"}, method={RequestMethod.GET})
    public String showNewApplicationForm(@ModelAttribute WaterConnectionDetails waterConnectionDetails, Model model, HttpServletRequest request) {
        waterConnectionDetails.setApplicationDate(new Date());
        waterConnectionDetails.setConnectionStatus(ConnectionStatus.INPROGRESS);
        model.addAttribute("allowIfPTDueExists", (Object)this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent());
        model.addAttribute("additionalRule", (Object)waterConnectionDetails.getApplicationType().getCode());
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setAdditionalRule(waterConnectionDetails.getApplicationType().getCode());
        this.prepareWorkflow(model, (StateAware)waterConnectionDetails, workflowContainer);
        model.addAttribute("currentUser", (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute("stateType", (Object)waterConnectionDetails.getClass().getSimpleName());
        model.addAttribute("documentName", (Object)this.waterTaxUtils.documentRequiredForBPLCategory());
        model.addAttribute("typeOfConnection", (Object)"NEWCONNECTION");
        Boolean loggedUserIsMeesevaUser = this.waterTaxUtils.isMeesevaUser(this.securityUtils.getCurrentUser());
        if (loggedUserIsMeesevaUser.booleanValue()) {
            if (request.getParameter("applicationNo") == null) {
                throw new ApplicationRuntimeException("MEESEVA.005");
            }
            waterConnectionDetails.setMeesevaApplicationNumber(request.getParameter("applicationNo"));
        }
        return "newconnection-form";
    }

    @RequestMapping(value={"/newConnection-dataEntryForm"}, method={RequestMethod.GET})
    public String dataEntryForm(@ModelAttribute WaterConnectionDetails waterConnectionDetails, Model model) {
        waterConnectionDetails.setApplicationDate(new Date());
        waterConnectionDetails.setConnectionStatus(ConnectionStatus.ACTIVE);
        HashMap<Long, String> connectionTypeMap = new HashMap<Long, String>();
        connectionTypeMap.put(this.applicationTypeService.findByCode("NEWCONNECTION").getId(), "Primary Connection");
        connectionTypeMap.put(this.applicationTypeService.findByCode("ADDNLCONNECTION").getId(), "Additional Connection");
        model.addAttribute("radioButtonMap", connectionTypeMap);
        model.addAttribute("mode", (Object)"dataEntry");
        model.addAttribute("typeOfConnection", (Object)"NEWCONNECTION");
        return "newconnection-dataEntryForm";
    }

    @RequestMapping(value={"/newConnection-existingMessage/{consumerCode}"}, method={RequestMethod.GET})
    public String dataEntryMessage(Model model, @PathVariable String consumerCode) {
        model.addAttribute("consumerCode", (Object)consumerCode);
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(consumerCode);
        model.addAttribute("connectionType", this.waterConnectionDetailsService.getConnectionTypesMap().get(waterConnectionDetails.getConnectionType().name()));
        if (waterConnectionDetails.getId() != null) {
            model.addAttribute("mode", (Object)"edit");
        } else {
            model.addAttribute("mode", (Object)"");
        }
        return "newconnection-dataEntryMessage";
    }

    @RequestMapping(value={"/newConnection-create"}, method={RequestMethod.POST})
    public String createNewConnection(@Valid @ModelAttribute WaterConnectionDetails waterConnectionDetails, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model, @RequestParam String workFlowAction, BindingResult errors) {
        Boolean isJuniorAsstOrSeniorAsst;
        Boolean isCSCOperator = this.waterTaxUtils.isCSCoperator(this.securityUtils.getCurrentUser());
        if (!isCSCOperator.booleanValue() && !(isJuniorAsstOrSeniorAsst = this.waterTaxUtils.isLoggedInUserJuniorOrSeniorAssistant(this.securityUtils.getCurrentUser().getId())).booleanValue()) {
            throw new ValidationException("err.creator.application");
        }
        Boolean loggedUserIsMeesevaUser = this.waterTaxUtils.isMeesevaUser(this.securityUtils.getCurrentUser());
        Boolean applicationByOthers = this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser());
        String sourceChannel = request.getParameter("Source");
        this.validatePropertyID(waterConnectionDetails, resultBinder);
        this.waterConnectionDetailsService.validateWaterRateAndDonationHeader(waterConnectionDetails);
        ArrayList applicationDocs = new ArrayList();
        int i = 0;
        String documentRequired = this.waterTaxUtils.documentRequiredForBPLCategory();
        if (!waterConnectionDetails.getApplicationDocs().isEmpty()) {
            for (ApplicationDocuments applicationDocument : waterConnectionDetails.getApplicationDocs()) {
                this.validateDocuments(applicationDocs, applicationDocument, i, resultBinder, waterConnectionDetails.getCategory().getId(), documentRequired);
                ++i;
            }
        }
        if (waterConnectionDetails.getState() == null) {
            waterConnectionDetails.setStatus(this.waterTaxUtils.getStatusByCodeAndModuleType("CREATED", "WATERTAXAPPLICATION"));
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Model Level Validation occurs = " + resultBinder);
        }
        if (resultBinder.hasErrors()) {
            waterConnectionDetails.setApplicationDate(new Date());
            model.addAttribute("validateIfPTDueExists", (Object)this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent());
            WorkflowContainer workflowContainer = new WorkflowContainer();
            workflowContainer.setAdditionalRule(waterConnectionDetails.getApplicationType().getCode());
            this.prepareWorkflow(model, (StateAware)waterConnectionDetails, workflowContainer);
            model.addAttribute("additionalRule", (Object)waterConnectionDetails.getApplicationType().getCode());
            model.addAttribute("currentUser", (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
            model.addAttribute("approvalPosOnValidate", (Object)request.getParameter("approvalPosition"));
            model.addAttribute("stateType", (Object)waterConnectionDetails.getClass().getSimpleName());
            model.addAttribute("documentName", (Object)this.waterTaxUtils.documentRequiredForBPLCategory());
            return "newconnection-form";
        }
        waterConnectionDetails.getApplicationDocs().clear();
        waterConnectionDetails.setApplicationDocs(applicationDocs);
        this.processAndStoreApplicationDocuments(waterConnectionDetails);
        Long approvalPosition = 0L;
        String approvalComent = "";
        if (request.getParameter("approvalComent") != null) {
            approvalComent = request.getParameter("approvalComent");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        if (applicationByOthers != null && applicationByOthers.equals(true)) {
            Position userPosition = this.waterTaxUtils.getZonalLevelClerkForLoggedInUser(waterConnectionDetails.getConnection().getPropertyIdentifier());
            if (userPosition != null) {
                approvalPosition = userPosition.getId();
            } else {
                model.addAttribute("validateIfPTDueExists", (Object)this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent());
                WorkflowContainer workflowContainer = new WorkflowContainer();
                workflowContainer.setAdditionalRule(waterConnectionDetails.getApplicationType().getCode());
                this.prepareWorkflow(model, (StateAware)waterConnectionDetails, workflowContainer);
                model.addAttribute("additionalRule", (Object)waterConnectionDetails.getApplicationType().getCode());
                model.addAttribute("approvalPosOnValidate", (Object)request.getParameter("approvalPosition"));
                model.addAttribute("currentUser", (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
                model.addAttribute("stateType", (Object)waterConnectionDetails.getClass().getSimpleName());
                errors.rejectValue("connection.propertyIdentifier", "err.validate.connection.user.mapping", "err.validate.connection.user.mapping");
                model.addAttribute("noJAORSAMessage", (Object)"No JA/SA exists to forward the application.");
                return "newconnection-form";
            }
        }
        if (loggedUserIsMeesevaUser.booleanValue()) {
            HashMap<String, String> meesevaParams = new HashMap<String, String>();
            meesevaParams.put("APPLICATIONNUMBER", waterConnectionDetails.getMeesevaApplicationNumber());
            if (waterConnectionDetails.getApplicationNumber() == null) {
                waterConnectionDetails.setApplicationNumber(waterConnectionDetails.getMeesevaApplicationNumber());
                waterConnectionDetails.setSource(Source.MEESEVA);
                this.waterConnectionDetailsService.createNewWaterConnection(waterConnectionDetails, approvalPosition, approvalComent, waterConnectionDetails.getApplicationType().getCode(), workFlowAction, meesevaParams, sourceChannel);
            }
        } else {
            this.waterConnectionDetailsService.createNewWaterConnection(waterConnectionDetails, approvalPosition, approvalComent, waterConnectionDetails.getApplicationType().getCode(), workFlowAction, sourceChannel);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("createNewWaterConnection is completed ");
        }
        if (loggedUserIsMeesevaUser.booleanValue()) {
            return "redirect:/application/generate-meesevareceipt?transactionServiceNumber=" + waterConnectionDetails.getApplicationNumber();
        }
        return "redirect:/application/citizeenAcknowledgement?pathVars=" + waterConnectionDetails.getApplicationNumber();
    }

    @ModelAttribute
    public WaterConnectionDetails loadByConsumerNo(@RequestParam(name="id", required=false) Long id) {
        if (id != null) {
            return this.waterConnectionDetailsService.findBy(id);
        }
        return new WaterConnectionDetails();
    }

    @RequestMapping(value={"/newConnection-dataEntryForm"}, method={RequestMethod.POST})
    public String createExisting(@Valid @ModelAttribute WaterConnectionDetails waterConnectionDetails, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model) {
        return this.createAndUpdateDataEntryRecord(waterConnectionDetails, resultBinder, model);
    }

    private String createAndUpdateDataEntryRecord(WaterConnectionDetails waterConnectionDetails, BindingResult resultBinder, Model model) {
        this.validatePropertyIDForDataEntry(waterConnectionDetails, resultBinder);
        this.validateExisting(waterConnectionDetails, resultBinder);
        if (resultBinder.hasErrors()) {
            model.addAttribute("validateIfPTDueExists", (Object)this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent());
            HashMap<Long, String> connectionTypeMap = new HashMap<Long, String>();
            connectionTypeMap.put(this.applicationTypeService.findByCode("NEWCONNECTION").getId(), "Primary Connection");
            connectionTypeMap.put(this.applicationTypeService.findByCode("ADDNLCONNECTION").getId(), "Additional Connection");
            model.addAttribute("radioButtonMap", connectionTypeMap);
            model.addAttribute("radioButtonMap", connectionTypeMap);
            model.addAttribute("usageTypes", (Object)this.usageTypeService.getActiveUsageTypes());
            model.addAttribute("connectionCategories", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
            model.addAttribute("pipeSizes", (Object)this.pipeSizeService.getAllActivePipeSize());
            if (waterConnectionDetails.getId() == null) {
                return "newconnection-dataEntryForm";
            }
            return "newconnection-dataEntryEditForm";
        }
        this.waterConnectionDetailsService.createExisting(waterConnectionDetails);
        return "redirect:newConnection-existingMessage/" + waterConnectionDetails.getConnection().getConsumerCode();
    }

    private void validateDocuments(List<ApplicationDocuments> applicationDocs, ApplicationDocuments applicationDocument, int i, BindingResult resultBinder, Long categoryId, String documentRequired) {
        ConnectionCategory connectionCategory = this.connectionCategoryService.findOne(categoryId);
        if (connectionCategory != null && documentRequired != null && connectionCategory.getCode().equalsIgnoreCase("BPL") && documentRequired.equalsIgnoreCase(applicationDocument.getDocumentNames().getDocumentName())) {
            String fieldError;
            if (applicationDocument.getDocumentNumber() == null) {
                fieldError = "applicationDocs[" + i + "].documentNumber";
                resultBinder.rejectValue(fieldError, "documentNumber.required");
            }
            if (applicationDocument.getDocumentDate() == null) {
                fieldError = "applicationDocs[" + i + "].documentDate";
                resultBinder.rejectValue(fieldError, "documentDate.required");
            }
            if (ArrayUtils.isNotEmpty((Object[])applicationDocument.getFiles())) {
                Iterator stream = Arrays.asList(applicationDocument.getFiles()).stream().filter(file -> !file.isEmpty()).iterator();
                if (stream != null && this.validApplicationDocument(applicationDocument)) {
                    applicationDocs.add(applicationDocument);
                }
            } else {
                String fieldError2 = "applicationDocs[" + i + "].files";
                resultBinder.rejectValue(fieldError2, "files.required");
            }
        } else {
            String fieldError;
            if (applicationDocument.getDocumentNumber() == null && applicationDocument.getDocumentDate() != null) {
                fieldError = "applicationDocs[" + i + "].documentNumber";
                resultBinder.rejectValue(fieldError, "documentNumber.required");
            }
            if (applicationDocument.getDocumentNumber() != null && applicationDocument.getDocumentDate() == null) {
                fieldError = "applicationDocs[" + i + "].documentDate";
                resultBinder.rejectValue(fieldError, "documentDate.required");
            }
            if (applicationDocument.getDocumentNumber() != null && applicationDocument.getDocumentDate() != null) {
                Iterator stream = null;
                if (ArrayUtils.isNotEmpty((Object[])applicationDocument.getFiles())) {
                    stream = Arrays.asList(applicationDocument.getFiles()).stream().filter(file -> !file.isEmpty()).iterator();
                }
                if (stream == null) {
                    String fieldError3 = "applicationDocs[" + i + "].files";
                    resultBinder.rejectValue(fieldError3, "files.required");
                }
            }
            if (this.validApplicationDocument(applicationDocument)) {
                applicationDocs.add(applicationDocument);
            }
        }
    }

    @RequestMapping(value={"/generate-meesevareceipt"}, method={RequestMethod.GET})
    public RedirectView generateMeesevaReceipt(@ModelAttribute WaterConnectionDetails waterConnectionDetails, HttpServletRequest request, Model model) {
        String keyNameArray = request.getParameter("transactionServiceNumber");
        RedirectView redirect = new RedirectView("/meeseva/generatereceipt?transactionServiceNumber=" + keyNameArray, false);
        FlashMap outputFlashMap = RequestContextUtils.getOutputFlashMap((HttpServletRequest)request);
        if (outputFlashMap != null) {
            outputFlashMap.put((Object)"url", (Object)request.getRequestURL());
        }
        return redirect;
    }

    @RequestMapping(value={"/application-success"}, method={RequestMethod.GET})
    public ModelAndView successView(@ModelAttribute WaterConnectionDetails waterConnectionDetails, HttpServletRequest request, Model model) {
        String[] keyNameArray = request.getParameter("pathVars").split(",");
        String applicationNumber = "";
        String approverName = "";
        String currentUserDesgn = "";
        String nextDesign = "";
        if (keyNameArray.length != 0 && keyNameArray.length > 0) {
            if (keyNameArray.length == 1) {
                applicationNumber = keyNameArray[0];
            } else if (keyNameArray.length == 3) {
                applicationNumber = keyNameArray[0];
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
            } else {
                applicationNumber = keyNameArray[0];
                approverName = keyNameArray[1];
                currentUserDesgn = keyNameArray[2];
                nextDesign = keyNameArray[3];
            }
        }
        if (applicationNumber != null) {
            waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(applicationNumber);
        }
        model.addAttribute("approverName", (Object)approverName);
        model.addAttribute("currentUserDesgn", (Object)currentUserDesgn);
        model.addAttribute("nextDesign", (Object)nextDesign);
        model.addAttribute("connectionType", this.waterConnectionDetailsService.getConnectionTypesMap().get(waterConnectionDetails.getConnectionType().name()));
        model.addAttribute("cityName", (Object)this.waterTaxUtils.getMunicipalityName());
        model.addAttribute("applicationDocList", (Object)this.waterConnectionDetailsService.getApplicationDocForExceptClosureAndReConnection(waterConnectionDetails));
        model.addAttribute("feeDetails", (Object)this.connectionDemandService.getSplitFee(waterConnectionDetails));
        model.addAttribute("mode", (Object)"ack");
        return new ModelAndView("application/application-success", "waterConnectionDetails", (Object)waterConnectionDetails);
    }

    private void validatePropertyID(WaterConnectionDetails waterConnectionDetails, BindingResult errors) {
        if (waterConnectionDetails.getConnection() != null && waterConnectionDetails.getConnection().getPropertyIdentifier() != null && !"".equals(waterConnectionDetails.getConnection().getPropertyIdentifier())) {
            String errorMessage = this.newConnectionService.checkValidPropertyAssessmentNumber(waterConnectionDetails.getConnection().getPropertyIdentifier());
            if (errorMessage != null && !"".equals(errorMessage)) {
                errors.rejectValue("connection.propertyIdentifier", errorMessage, errorMessage);
            } else {
                errorMessage = this.newConnectionService.checkConnectionPresentForProperty(waterConnectionDetails.getConnection().getPropertyIdentifier());
                if (errorMessage != null && !"".equals(errorMessage)) {
                    errors.rejectValue("connection.propertyIdentifier", errorMessage, errorMessage);
                }
            }
        }
    }

    private void validatePropertyIDForDataEntry(WaterConnectionDetails waterConnectionDetails, BindingResult errors) {
        if (waterConnectionDetails.getConnection() != null && waterConnectionDetails.getConnection().getPropertyIdentifier() != null && !"".equals(waterConnectionDetails.getConnection().getPropertyIdentifier())) {
            String errorMessage = this.newConnectionService.checkValidPropertyForDataEntry(waterConnectionDetails.getConnection().getPropertyIdentifier());
            if (errorMessage != null && !"".equals(errorMessage)) {
                errors.rejectValue("connection.propertyIdentifier", errorMessage, errorMessage);
            } else if (waterConnectionDetails.getId() == null && waterConnectionDetails.getApplicationType().getCode().equalsIgnoreCase("NEWCONNECTION")) {
                errorMessage = this.newConnectionService.checkConnectionPresentForProperty(waterConnectionDetails.getConnection().getPropertyIdentifier());
            }
            if (errorMessage != null && !"".equals(errorMessage)) {
                errors.rejectValue("connection.propertyIdentifier", errorMessage, errorMessage);
            }
        }
    }

    private void validateExisting(WaterConnectionDetails waterConnectionDetails, BindingResult errors) {
        if (waterConnectionDetails.getConnection() != null) {
            WaterConnection validateWaterConnDet = null;
            if (waterConnectionDetails.getConnection().getOldConsumerNumber() != null) {
                validateWaterConnDet = this.waterConnectionService.findByConsumerCode(waterConnectionDetails.getConnection().getOldConsumerNumber());
            }
            if (validateWaterConnDet != null && !waterConnectionDetails.getConnection().getId().equals(validateWaterConnDet.getId())) {
                errors.rejectValue("connection.consumerCode", "err.exist.consumerCode");
            }
        }
        if (waterConnectionDetails.getConnectionType() != null && waterConnectionDetails.getConnectionType() == ConnectionType.METERED) {
            WaterConnectionDetails validateExistWaterConnectionDet;
            if (waterConnectionDetails.getConnection().getOldConsumerNumber() == null) {
                errors.rejectValue("connection.oldConsumerNumber", ERROR_REQUIRED);
            }
            if (waterConnectionDetails.getConnection().getConsumerCode() != null && (validateExistWaterConnectionDet = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(waterConnectionDetails.getConnection().getConsumerCode())) != null && !validateExistWaterConnectionDet.getId().equals(waterConnectionDetails.getId())) {
                errors.rejectValue("connection.consumerCode", "err.exist.consumerCode");
            }
            if (waterConnectionDetails.getExecutionDate() == null) {
                errors.rejectValue("executionDate", ERROR_REQUIRED);
            }
            if (waterConnectionDetails.getExistingConnection().getMeterNo() == null) {
                errors.rejectValue("existingConnection.meterNo", ERROR_REQUIRED);
            }
            if (waterConnectionDetails.getExistingConnection().getPreviousReading() == null) {
                errors.rejectValue("existingConnection.previousReading", ERROR_REQUIRED);
            }
            if (waterConnectionDetails.getExistingConnection().getReadingDate() == null) {
                errors.rejectValue("existingConnection.readingDate", ERROR_REQUIRED);
            }
            if (waterConnectionDetails.getExistingConnection().getCurrentReading() == null) {
                errors.rejectValue("existingConnection.currentReading", ERROR_REQUIRED);
            }
        }
    }

    @RequestMapping(value={"/newConnection-editExisting/{consumerCode}"}, method={RequestMethod.GET})
    public String editExisting(@ModelAttribute WaterConnectionDetails waterConnectionDetails, @PathVariable String consumerCode, Model model) {
        waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(consumerCode);
        model.addAttribute("allowIfPTDueExists", (Object)this.waterTaxUtils.isNewConnectionAllowedIfPTDuePresent());
        model.addAttribute("additionalRule", (Object)waterConnectionDetails.getApplicationType().getCode());
        model.addAttribute("currentUser", (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        model.addAttribute("stateType", (Object)waterConnectionDetails.getClass().getSimpleName());
        HashMap<Long, String> connectionTypeMap = new HashMap<Long, String>();
        connectionTypeMap.put(this.applicationTypeService.findByCode("NEWCONNECTION").getId(), "Primary Connection");
        connectionTypeMap.put(this.applicationTypeService.findByCode("ADDNLCONNECTION").getId(), "Additional Connection");
        model.addAttribute("radioButtonMap", connectionTypeMap);
        model.addAttribute("mode", (Object)"dataEntry");
        model.addAttribute("waterConnectionDetails", (Object)waterConnectionDetails);
        model.addAttribute("usageTypes", (Object)this.usageTypeService.getActiveUsageTypes());
        model.addAttribute("connectionCategories", (Object)this.connectionCategoryService.getAllActiveConnectionCategory());
        model.addAttribute("pipeSizes", (Object)this.pipeSizeService.getAllActivePipeSize());
        return "newconnection-dataEntryEditForm";
    }

    @RequestMapping(value={"/newConnection-editExisting/{consumerCode}"}, method={RequestMethod.POST})
    public String modifyExisting(@Valid @ModelAttribute WaterConnectionDetails waterConnectionDetails, @PathVariable String consumerCode, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model) {
        return this.createAndUpdateDataEntryRecord(waterConnectionDetails, resultBinder, model);
    }
}

