/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.text.SimpleDateFormat;
import java.util.HashMap;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.lang.WordUtils;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.reporting.engine.ReportOutput;
import org.egov.infra.reporting.engine.ReportRequest;
import org.egov.infra.reporting.engine.ReportService;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.OwnerName;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.masters.service.ApplicationProcessTimeService;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/application"})
public class CitizenAcknowledgementController {
    @Autowired
    private ReportService reportService;
    @Autowired
    private ApplicationProcessTimeService applicationProcessTimeService;
    public static final String CITIZEN_ACKNOWLDGEMENT = "citizenAcknowledgement";
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private CityService cityService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;

    @RequestMapping(value={"/citizeenAcknowledgement"}, method={RequestMethod.GET})
    @ResponseBody
    public ResponseEntity<byte[]> generateEstimationNotice(HttpServletRequest request, HttpSession session) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByApplicationNumber(request.getParameter("pathVars"));
        return this.generateReport(waterConnectionDetails, session);
    }

    private ResponseEntity<byte[]> generateReport(WaterConnectionDetails waterConnectionDetails, HttpSession session) {
        ReportRequest reportInput = null;
        HashMap<String, Object> reportParams = new HashMap<String, Object>();
        if (waterConnectionDetails != null) {
            Integer appProcessTime;
            SimpleDateFormat formatter = new SimpleDateFormat("dd/MM/yyyy");
            AssessmentDetails assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ACTIVE);
            String[] doorNo = assessmentDetails.getPropertyAddress().split(",");
            String ownerName = "";
            Iterator iterator = assessmentDetails.getOwnerNames().iterator();
            if (iterator.hasNext()) {
                OwnerName names = (OwnerName)iterator.next();
                ownerName = names.getOwnerName();
            }
            if ((appProcessTime = this.applicationProcessTimeService.getApplicationProcessTime(waterConnectionDetails.getApplicationType(), waterConnectionDetails.getCategory())) != null) {
                reportParams.put("applicationDueDate", formatter.format(this.waterConnectionDetailsService.getDisposalDate(waterConnectionDetails, appProcessTime)));
            } else {
                reportParams.put("applicationDueDate", null);
            }
            String districtName = (String)session.getAttribute("districtName");
            reportParams.put("cityUrl", (!this.cityService.findAll().isEmpty() ? ((City)this.cityService.findAll().get(0)).getName().toLowerCase() : districtName.toLowerCase()) + ".cdma.ap.gov.in");
            reportParams.put("applicationType", WordUtils.capitalize((String)waterConnectionDetails.getApplicationType().getName()).toString());
            reportParams.put("cityName", session.getAttribute("citymunicipalityname"));
            reportParams.put("district", session.getAttribute("districtName"));
            reportParams.put("applicationNumber", waterConnectionDetails.getApplicationNumber());
            reportParams.put("applicationDate", formatter.format(waterConnectionDetails.getApplicationDate()));
            reportParams.put("applicantName", ownerName);
            reportParams.put("address", assessmentDetails.getPropertyAddress());
            reportParams.put("houseNo", doorNo[0]);
            reportParams.put("propertyID", waterConnectionDetails.getConnection().getPropertyIdentifier());
            reportParams.put("electionWard", assessmentDetails.getBoundaryDetails().getAdminWardName());
            if (waterConnectionDetails.getCloseConnectionType() != null) {
                if ("T".equals(waterConnectionDetails.getCloseConnectionType().toString())) {
                    waterConnectionDetails.setCloseConnectionType("Temporary");
                } else if ("P".equals(waterConnectionDetails.getCloseConnectionType().toString())) {
                    waterConnectionDetails.setCloseConnectionType("Permanent");
                }
            }
            reportParams.put("closeconnectiontype", waterConnectionDetails.getCloseConnectionType());
            if (waterConnectionDetails.getCloseconnectionreason() != null) {
                reportParams.put("closeconnectionreason", waterConnectionDetails.getCloseconnectionreason().toString());
            }
            if (waterConnectionDetails.getReConnectionReason() != null) {
                reportParams.put("reconnectionreason", waterConnectionDetails.getReConnectionReason().toString());
            }
            reportInput = new ReportRequest(CITIZEN_ACKNOWLDGEMENT, (Object)waterConnectionDetails, reportParams);
        }
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.parseMediaType((String)"application/pdf"));
        headers.add("content-disposition", "inline;filename=EstimationNotice.pdf");
        ReportOutput reportOutput = this.reportService.createReport(reportInput);
        return new ResponseEntity((Object)reportOutput.getReportOutputData(), (MultiValueMap)headers, HttpStatus.CREATED);
    }
}

