/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.search;

import java.math.BigDecimal;
import javax.servlet.http.HttpServletRequest;
import org.egov.ptis.domain.model.AssessmentDetails;
import org.egov.ptis.domain.model.enums.BasicPropertyStatus;
import org.egov.ptis.domain.service.property.PropertyExternalService;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.entity.es.ConnectionSearchRequest;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.entity.enums.ConnectionType;
import org.egov.wtms.utils.PropertyExtnUtils;
import org.egov.wtms.utils.WaterTaxUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
@RequestMapping(value={"/search/waterSearch/"})
public class CommonWaterTaxSearchController {
    private static final String COMMON_FORM_SEARCH = "waterTaxSearch-commonForm";
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private PropertyExtnUtils propertyExtnUtils;
    @Autowired
    private WaterTaxUtils waterTaxUtils;

    @ModelAttribute
    public ConnectionSearchRequest searchRequest() {
        return new ConnectionSearchRequest();
    }

    @RequestMapping(value={"commonSearch/"}, method={RequestMethod.GET})
    public String commonSearchForm() {
        return COMMON_FORM_SEARCH;
    }

    @RequestMapping(value={"commonSearch/"}, method={RequestMethod.POST})
    public String searchConnectionSubmit(@ModelAttribute ConnectionSearchRequest searchRequest, BindingResult resultBinder, Model model, @RequestParam String applicationType, HttpServletRequest request) {
        WaterConnectionDetails waterConnectionDetails = null;
        waterConnectionDetails = applicationType != null && applicationType.equals("RECONNECTION") ? this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(searchRequest.getConsumerCode(), ConnectionStatus.CLOSED) : this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCodeAndStatus(searchRequest.getConsumerCode(), ConnectionStatus.ACTIVE);
        applicationType = request.getParameter("applicationType");
        if (waterConnectionDetails == null) {
            resultBinder.rejectValue("consumerCode", "invalid.consumernumber");
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("ADDNLCONNECTION")) {
            if (waterConnectionDetails.getCloseConnectionType() != null && (waterConnectionDetails.getCloseConnectionType().equals("P") || waterConnectionDetails.getCloseConnectionType().equals("T"))) {
                model.addAttribute("mode", (Object)"errorMode");
                resultBinder.rejectValue("consumerCode", "connection.closed");
                return COMMON_FORM_SEARCH;
            }
            if (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE)) {
                return "redirect:/application/addconnection/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute("mode", (Object)"errorMode");
            resultBinder.rejectValue("consumerCode", "invalid.consumernumber");
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("CHANGEOFUSE")) {
            if (waterConnectionDetails.getCloseConnectionType() != null && (waterConnectionDetails.getCloseConnectionType().equals("P") || waterConnectionDetails.getCloseConnectionType().equals("T"))) {
                model.addAttribute("mode", (Object)"errorMode");
                resultBinder.rejectValue("consumerCode", "connection.closed");
                return COMMON_FORM_SEARCH;
            }
            if ((waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE")) && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE)) {
                return "redirect:/application/changeOfUse/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute("mode", (Object)"errorMode");
            resultBinder.rejectValue("consumerCode", "invalid.consumernumber");
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("CLOSURECONNECTION")) {
            if (waterConnectionDetails.getCloseConnectionType() != null && (waterConnectionDetails.getCloseConnectionType().equals("P") || waterConnectionDetails.getCloseConnectionType().equals("T"))) {
                model.addAttribute("mode", (Object)"errorMode");
                resultBinder.rejectValue("consumerCode", "connection.closed");
                return COMMON_FORM_SEARCH;
            }
            if ((waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE")) && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE) && waterConnectionDetails.getCloseConnectionType() == null) {
                return "redirect:/application/close/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute("mode", (Object)"errorMode");
            resultBinder.rejectValue("consumerCode", "invalid.consumernumber");
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("RECONNECTION")) {
            if (waterConnectionDetails.getCloseConnectionType() != null && waterConnectionDetails.getCloseConnectionType().equals("P")) {
                model.addAttribute("mode", (Object)"errorMode");
                resultBinder.rejectValue("consumerCode", "connection.closed");
                return COMMON_FORM_SEARCH;
            }
            if (waterConnectionDetails.getApplicationType().getCode().equals("CLOSINGCONNECTION") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.CLOSED) && waterConnectionDetails.getStatus().getCode().equals("CLOSERSANCTIONED") && waterConnectionDetails.getCloseConnectionType().equals("T")) {
                return "redirect:/application/reconnection/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute("mode", (Object)"errorMode");
            resultBinder.rejectValue("consumerCode", "invalid.consumernumber");
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("METERENTRY")) {
            if ((waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE")) && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE) && waterConnectionDetails.getConnectionType().name().equals("METERED")) {
                return "redirect:/application/meterentry/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute("mode", (Object)"errorMode");
            resultBinder.rejectValue("consumerCode", "invalid.consumernumber");
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("DATAENTRYEDIT")) {
            if ((waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION")) && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE) && waterConnectionDetails.getLegacy().booleanValue()) {
                return "redirect:/application/newConnection-editExisting/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute("mode", (Object)"errorMode");
            resultBinder.rejectValue("consumerCode", "invalid.consumernumber");
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("COLLECTTAX")) {
            AssessmentDetails assessmentDetails;
            BigDecimal amoutToBeCollected = BigDecimal.ZERO;
            if (null != this.waterTaxUtils.getCurrentDemand(waterConnectionDetails).getDemand()) {
                amoutToBeCollected = this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails);
            }
            if ((assessmentDetails = this.propertyExtnUtils.getAssessmentDetailsForFlag(waterConnectionDetails.getConnection().getPropertyIdentifier(), PropertyExternalService.FLAG_FULL_DETAILS, BasicPropertyStatus.ALL)) != null) {
                if ((amoutToBeCollected.doubleValue() > 0.0 && waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.METERED) || waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.NON_METERED)) && (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE")) && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE)) {
                    return "redirect:/application/generatebill/" + waterConnectionDetails.getConnection().getConsumerCode();
                }
                model.addAttribute("mode", (Object)"errorMode");
                resultBinder.rejectValue("consumerCode", "invalid.consumernumber");
                return COMMON_FORM_SEARCH;
            }
        }
        if (applicationType != null && applicationType.equals("EDITCOLLECTION")) {
            if (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE) && waterConnectionDetails.getLegacy().booleanValue()) {
                return "redirect:/application/editCollection/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute("mode", (Object)"errorMode");
            resultBinder.rejectValue("consumerCode", "invalid.consumernumber");
            return COMMON_FORM_SEARCH;
        }
        if (applicationType != null && applicationType.equals("GENERATEBILL")) {
            if (waterConnectionDetails.getApplicationType().getCode().equals("NEWCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("ADDNLCONNECTION") || waterConnectionDetails.getApplicationType().getCode().equals("CHANGEOFUSE") && waterConnectionDetails.getConnectionStatus().equals((Object)ConnectionStatus.ACTIVE) && waterConnectionDetails.getConnectionType().equals((Object)ConnectionType.NON_METERED)) {
                return "redirect:/report/generateBillForHSCNo/" + waterConnectionDetails.getConnection().getConsumerCode();
            }
            model.addAttribute("mode", (Object)"errorMode");
            resultBinder.rejectValue("consumerCode", "invalid.consumernumber");
            return COMMON_FORM_SEARCH;
        }
        return "";
    }
}

