/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import java.util.Date;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.egov.collection.entity.es.CollectionDocument;
import org.egov.commons.EgwStatus;
import org.egov.commons.dao.EgwStatusHibernateDAO;
import org.egov.commons.entity.Source;
import org.egov.eis.service.AssignmentService;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.AppConfigValueService;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.wtms.application.entity.DailyWTCollectionReportSearch;
import org.egov.wtms.utils.constants.WaterTaxConstants;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.elasticsearch.search.aggregations.AbstractAggregationBuilder;
import org.elasticsearch.search.aggregations.AggregationBuilders;
import org.elasticsearch.search.aggregations.Aggregations;
import org.elasticsearch.search.aggregations.metrics.valuecount.ValueCount;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.ElasticsearchTemplate;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/report/dailyWTCollectionReport/search/"})
public class DailyWTCollectionReportController {
    @Autowired
    public EgwStatusHibernateDAO egwStatusHibernateDAO;
    @Autowired
    public AssignmentService assignmentService;
    @Autowired
    private ElasticsearchTemplate elasticsearchTemplate;
    @Autowired
    public AppConfigValueService appConfigValueService;
    @Autowired
    private CityService cityService;
    @Autowired
    private BoundaryService boundaryService;

    @ModelAttribute
    public void reportModel(Model model) {
        DailyWTCollectionReportSearch dailyCollectionReportResut = new DailyWTCollectionReportSearch();
        model.addAttribute("dailyWTCollectionReport", (Object)dailyCollectionReportResut);
    }

    @ModelAttribute(value="collectionMode")
    public Map<String, String> loadInstrumentTypes() {
        LinkedHashMap<String, String> collectionModeMap = new LinkedHashMap<String, String>(0);
        collectionModeMap.put(Source.ESEVA.toString(), Source.ESEVA.toString());
        collectionModeMap.put(Source.MEESEVA.toString(), Source.MEESEVA.toString());
        collectionModeMap.put(Source.APONLINE.toString(), Source.APONLINE.toString());
        collectionModeMap.put(Source.SOFTTECH.toString(), Source.SOFTTECH.toString());
        collectionModeMap.put(Source.SYSTEM.toString(), Source.SYSTEM.toString());
        return collectionModeMap;
    }

    @ModelAttribute(value="operators")
    public Set<User> loadCollectionOperators() {
        String operatorDesignation = this.appConfigValueService.getAppConfigValueByDate("Collection", "COLLECTIONDESIGNATIONFORCSCOPERATORASCLERK", new Date()).getValue();
        return this.assignmentService.getUsersByDesignations(operatorDesignation.split(","));
    }

    @ModelAttribute(value="status")
    public List<EgwStatus> loadStatus() {
        return this.egwStatusHibernateDAO.getStatusByModule("ReceiptHeader");
    }

    @ModelAttribute(value="wards")
    public List<Boundary> wardBoundaries() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @RequestMapping(method={RequestMethod.GET})
    public String search(Model model) {
        model.addAttribute("currentDate", (Object)new Date());
        return "dailyWTCollection-search";
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public List<CollectionDocument> searchCollection(@ModelAttribute DailyWTCollectionReportSearch searchRequest) {
        City cityWebsite = this.cityService.getCityByURL(ApplicationThreadLocals.getDomainName());
        searchRequest.setUlbName(cityWebsite.getName());
        String receiptCount = "receipt_count";
        BoolQueryBuilder boolQuery = this.getCollectionFilterQuery(searchRequest);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)receiptCount).field("consumerCode")).build();
        Aggregations collCountAggr = (Aggregations)this.elasticsearchTemplate.query((SearchQuery)searchQuery, response -> response.getAggregations());
        ValueCount aggr = (ValueCount)collCountAggr.get(receiptCount);
        searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"receipts"}).withQuery((QueryBuilder)boolQuery).addAggregation((AbstractAggregationBuilder)AggregationBuilders.count((String)receiptCount).field("consumerCode")).withPageable((Pageable)new PageRequest(0, Long.valueOf(aggr.getValue()).intValue() == 0 ? 1 : Long.valueOf(aggr.getValue()).intValue())).build();
        return this.elasticsearchTemplate.queryForList((SearchQuery)searchQuery, CollectionDocument.class);
    }

    private BoolQueryBuilder getCollectionFilterQuery(DailyWTCollectionReportSearch searchRequest) {
        Date fromDate = null;
        Date toDate = null;
        if (searchRequest.getFromDate() != null) {
            fromDate = org.egov.infra.utils.DateUtils.getDate((String)searchRequest.getFromDate(), (String)"yyyy-MM-dd");
        }
        if (searchRequest.getToDate() != null) {
            toDate = DateUtils.addDays((Date)org.egov.infra.utils.DateUtils.getDate((String)searchRequest.getToDate(), (String)"yyyy-MM-dd"), (int)1);
        }
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.matchQuery((String)"billingService", (Object)"Water Tax")).filter((QueryBuilder)QueryBuilders.rangeQuery((String)"receiptDate").gte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(fromDate)).lte(WaterTaxConstants.DATEFORMATTER_YYYY_MM_DD.format(toDate)).includeUpper(false));
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCollectionMode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"channel", (Object)searchRequest.getCollectionMode()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getCollectionOperator())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"receiptCreator", (Object)searchRequest.getCollectionOperator()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getStatus())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"status", (Object)searchRequest.getStatus()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getUlbName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"cityName", (Object)searchRequest.getUlbName()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getRevenueWard())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"revenueWard", (Object)searchRequest.getRevenueWard()));
        }
        return boolQuery;
    }
}

