/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.masters;

import java.util.List;
import javax.validation.Valid;
import org.egov.wtms.masters.entity.MeterCost;
import org.egov.wtms.masters.service.MeterCostService;
import org.egov.wtms.masters.service.PipeSizeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class MeterCostMasterController {
    private final PipeSizeService pipeSizeService;
    private final MeterCostService meterCostService;

    @Autowired
    public MeterCostMasterController(PipeSizeService pipeSizeService, MeterCostService meterCostService) {
        this.pipeSizeService = pipeSizeService;
        this.meterCostService = meterCostService;
    }

    @RequestMapping(value={"/meterCostMaster"}, method={RequestMethod.GET})
    public String viewForm(Model model) {
        MeterCost meterCost = new MeterCost();
        model.addAttribute("meterCost", (Object)meterCost);
        model.addAttribute("pipeSize", (Object)this.pipeSizeService.getAllActivePipeSize());
        model.addAttribute("reqAttr", (Object)"false");
        model.addAttribute("mode", (Object)"create");
        return "meter-cost-master";
    }

    @RequestMapping(value={"/meterCostMaster"}, method={RequestMethod.POST})
    public String createMeterCostMasterData(@Valid @ModelAttribute MeterCost meterCost, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            model.addAttribute("pipeSize", (Object)this.pipeSizeService.getAllActivePipeSize());
            return "meter-cost-master";
        }
        this.meterCostService.createMeterCost(meterCost);
        redirectAttrs.addFlashAttribute("meterCost", (Object)meterCost);
        model.addAttribute("message", (Object)"Meter Cost created successfully.");
        model.addAttribute("mode", (Object)"create");
        return "meter-cost-master-success";
    }

    @RequestMapping(value={"/meterCostMaster/list"}, method={RequestMethod.GET})
    public String getMeterCostMasterList(Model model) {
        List meterCostList = this.meterCostService.findAll();
        model.addAttribute("meterCostList", (Object)meterCostList);
        return "meter-cost-master-list";
    }

    @RequestMapping(value={"/meterCostMaster/edit"}, method={RequestMethod.GET})
    public String getMeterCostMaster(Model model) {
        model.addAttribute("mode", (Object)"edit");
        return this.getMeterCostMasterList(model);
    }

    @RequestMapping(value={"/meterCostMaster/edit/{meterCostId}"}, method={RequestMethod.GET})
    public String getMeterCostMasterDetails(Model model, @PathVariable String meterCostId) {
        MeterCost meterCost = this.meterCostService.findOne(Long.valueOf(Long.parseLong(meterCostId)));
        model.addAttribute("meterCost", (Object)meterCost);
        model.addAttribute("pipeSize", (Object)this.pipeSizeService.getAllActivePipeSize());
        model.addAttribute("reqAttr", (Object)"true");
        return "meter-cost-master";
    }

    @RequestMapping(value={"/meterCostMaster/edit/{meterCostId}"}, method={RequestMethod.POST})
    public String editMeterCostMasterData(@Valid @ModelAttribute MeterCost meterCost, BindingResult errors, RedirectAttributes redirectAttrs, Model model, @PathVariable long meterCostId) {
        if (errors.hasErrors()) {
            model.addAttribute("pipeSize", (Object)this.pipeSizeService.getAllActivePipeSize());
            return "meter-cost-master";
        }
        this.meterCostService.updateMeterCost(meterCost);
        redirectAttrs.addFlashAttribute("meterCost", (Object)meterCost);
        model.addAttribute("message", (Object)"Meter Cost updated successfully.");
        return "meter-cost-master-success";
    }
}

