/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.masters;

import java.util.List;
import javax.validation.Valid;
import org.egov.wtms.masters.entity.ConnectionCategory;
import org.egov.wtms.masters.service.ConnectionCategoryService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/masters"})
public class CategoryMasterController {
    @Autowired
    private ConnectionCategoryService connectionCategoryService;

    @RequestMapping(value={"/categoryMaster"}, method={RequestMethod.GET})
    public String viewForm(Model model) {
        ConnectionCategory connectionCategory = new ConnectionCategory();
        model.addAttribute("connectionCategory", (Object)connectionCategory);
        model.addAttribute("reqAttr", (Object)false);
        model.addAttribute("mode", (Object)"create");
        return "category-master";
    }

    @RequestMapping(value={"/categoryMaster"}, method={RequestMethod.POST})
    public String createCategoryMasterData(@Valid @ModelAttribute ConnectionCategory connectionCategory, BindingResult errors, RedirectAttributes redirectAttrs, Model model) {
        if (errors.hasErrors()) {
            return "category-master";
        }
        this.connectionCategoryService.createConnectionCategory(connectionCategory);
        redirectAttrs.addFlashAttribute("connectionCategory", (Object)connectionCategory);
        model.addAttribute("message", (Object)"Category created successfully.");
        model.addAttribute("mode", (Object)"create");
        return "category-master-success";
    }

    @RequestMapping(value={"/categoryMaster/list"}, method={RequestMethod.GET})
    public String getCategoryMasterList(Model model) {
        List connectionCategoryList = this.connectionCategoryService.findAll();
        model.addAttribute("connectionCategoryList", (Object)connectionCategoryList);
        return "category-master-list";
    }

    @RequestMapping(value={"/categoryMaster/edit"}, method={RequestMethod.GET})
    public String getCategoryMaster(Model model) {
        model.addAttribute("mode", (Object)"edit");
        return this.getCategoryMasterList(model);
    }

    @RequestMapping(value={"/categoryMaster/edit/{connectionCategoryId}"}, method={RequestMethod.GET})
    public String getCategoryMasterDetails(Model model, @PathVariable String connectionCategoryId) {
        ConnectionCategory connectionCategory = this.connectionCategoryService.findOne(Long.valueOf(Long.parseLong(connectionCategoryId)));
        model.addAttribute("connectionCategory", (Object)connectionCategory);
        model.addAttribute("reqAttr", (Object)"true");
        return "category-master";
    }

    @RequestMapping(value={"/categoryMaster/edit/{connectionCategoryId}"}, method={RequestMethod.POST})
    public String editCategoryMasterData(@Valid @ModelAttribute ConnectionCategory connectionCategory, BindingResult errors, RedirectAttributes redirectAttrs, Model model, @PathVariable long connectionCategoryId) {
        if (errors.hasErrors()) {
            return "category-master";
        }
        this.connectionCategoryService.updateConnectionCategory(connectionCategory);
        redirectAttrs.addFlashAttribute("connectionCategory", (Object)connectionCategory);
        model.addAttribute("message", (Object)"Category updated successfully.");
        return "category-master-success";
    }
}

