/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.application;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.validation.Valid;
import org.egov.eis.entity.Assignment;
import org.egov.eis.web.contract.WorkflowContainer;
import org.egov.infra.admin.master.service.DepartmentService;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.infra.workflow.entity.StateAware;
import org.egov.pims.commons.Position;
import org.egov.wtms.application.entity.ApplicationDocuments;
import org.egov.wtms.application.entity.WaterConnectionDetails;
import org.egov.wtms.application.service.ConnectionDemandService;
import org.egov.wtms.application.service.ReconnectionService;
import org.egov.wtms.masters.entity.ApplicationType;
import org.egov.wtms.masters.entity.ConnectionCategory;
import org.egov.wtms.masters.entity.DocumentNames;
import org.egov.wtms.masters.entity.PipeSize;
import org.egov.wtms.masters.entity.UsageType;
import org.egov.wtms.masters.entity.enums.ConnectionStatus;
import org.egov.wtms.masters.service.ApplicationTypeService;
import org.egov.wtms.utils.WaterTaxUtils;
import org.egov.wtms.web.controller.application.GenericConnectionController;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@RequestMapping(value={"/application"})
public class ReconnectionController
extends GenericConnectionController {
    @Autowired
    private ApplicationTypeService applicationTypeService;
    @Autowired
    private ConnectionDemandService connectionDemandService;
    @Autowired
    private DepartmentService departmentService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private ReconnectionService reconnectionService;
    @Autowired
    private SecurityUtils securityUtils;

    @ModelAttribute
    public WaterConnectionDetails getWaterConnectionDetails(@PathVariable String applicationCode) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(applicationCode, ConnectionStatus.CLOSED);
        return waterConnectionDetails;
    }

    @ModelAttribute(value="documentNamesList")
    public List<DocumentNames> documentNamesList(@ModelAttribute WaterConnectionDetails waterConnectionDetails) {
        ApplicationType applicationType = this.applicationTypeService.findByCode("RECONNECTION");
        return this.waterConnectionDetailsService.getAllActiveDocumentNames(applicationType);
    }

    @ModelAttribute(value="connectionCategories")
    public List<ConnectionCategory> connectionCategories() {
        return this.connectionCategoryService.getAllActiveConnectionCategory();
    }

    @ModelAttribute(value="usageTypes")
    public List<UsageType> usageTypes() {
        return this.usageTypeService.getActiveUsageTypes();
    }

    @ModelAttribute(value="pipeSizes")
    public List<PipeSize> pipeSizes() {
        return this.pipeSizeService.getAllActivePipeSize();
    }

    @RequestMapping(value={"/reconnection/{applicationCode}"}, method={RequestMethod.GET})
    public String newForm(Model model, @PathVariable String applicationCode, HttpServletRequest request) {
        WaterConnectionDetails waterConnectionDetails = this.waterConnectionDetailsService.findByConsumerCodeAndConnectionStatus(applicationCode, ConnectionStatus.CLOSED);
        return this.loadViewData(model, request, waterConnectionDetails);
    }

    private String loadViewData(Model model, HttpServletRequest request, WaterConnectionDetails waterConnectionDetails) {
        model.addAttribute("stateType", (Object)waterConnectionDetails.getClass().getSimpleName());
        model.addAttribute("additionalRule", (Object)"RECONNECTION");
        model.addAttribute("currentUser", (Object)this.waterTaxUtils.getCurrentUserRole(this.securityUtils.getCurrentUser()));
        WorkflowContainer workflowContainer = new WorkflowContainer();
        workflowContainer.setAdditionalRule("RECONNECTION");
        this.prepareWorkflow(model, (StateAware)waterConnectionDetails, workflowContainer);
        model.addAttribute("applicationDocList", (Object)this.waterConnectionDetailsService.getApplicationDocForExceptClosureAndReConnection(waterConnectionDetails));
        model.addAttribute("waterConnectionDetails", (Object)waterConnectionDetails);
        model.addAttribute("feeDetails", (Object)this.connectionDemandService.getSplitFee(waterConnectionDetails));
        model.addAttribute("connectionType", this.waterConnectionDetailsService.getConnectionTypesMap().get(waterConnectionDetails.getConnectionType().name()));
        waterConnectionDetails.setApplicationType(this.applicationTypeService.findByCode("RECONNECTION"));
        model.addAttribute("applicationHistory", (Object)this.waterConnectionDetailsService.getHistory(waterConnectionDetails));
        model.addAttribute("approvalDepartmentList", (Object)this.departmentService.getAllDepartments());
        model.addAttribute("loggedInCSCUser", (Object)this.waterTaxUtils.getCurrentUserRole());
        model.addAttribute("typeOfConnection", (Object)"RECONNECTION");
        BigDecimal waterTaxDueforParent = this.waterConnectionDetailsService.getTotalAmount(waterConnectionDetails);
        model.addAttribute("waterTaxDueforParent", (Object)waterTaxDueforParent);
        return "reconnection-newForm";
    }

    @RequestMapping(value={"/reconnection/{applicationCode}"}, method={RequestMethod.POST})
    public String update(@Valid @ModelAttribute WaterConnectionDetails waterConnectionDetails, BindingResult resultBinder, RedirectAttributes redirectAttributes, HttpServletRequest request, Model model, @RequestParam(value="files") MultipartFile[] files) {
        String sourceChannel = request.getParameter("Source");
        String workFlowAction = "";
        if (request.getParameter("mode") != null) {
            request.getParameter("mode");
        }
        if (request.getParameter("workFlowAction") != null) {
            workFlowAction = request.getParameter("workFlowAction");
        }
        Long approvalPosition = 0L;
        String approvalComent = "";
        Boolean applicationByOthers = this.waterTaxUtils.getCurrentUserRole();
        if (applicationByOthers != null && applicationByOthers.equals(true)) {
            Position userPosition = this.waterTaxUtils.getZonalLevelClerkForLoggedInUser(waterConnectionDetails.getConnection().getPropertyIdentifier());
            if (userPosition == null) {
                model.addAttribute("noJAORSAMessage", (Object)"No JA/SA exists to forward the application.");
                return "reconnection-newForm";
            }
            approvalPosition = userPosition.getId();
        }
        if (request.getParameter("approvalComent") != null) {
            approvalComent = request.getParameter("approvalComent");
        }
        List documentListForClosed = this.waterConnectionDetailsService.getAllActiveDocumentNames(waterConnectionDetails.getApplicationType());
        ApplicationDocuments applicationDocument = new ApplicationDocuments();
        if (!documentListForClosed.isEmpty()) {
            applicationDocument.setDocumentNames((DocumentNames)documentListForClosed.get(0));
            applicationDocument.setWaterConnectionDetails(waterConnectionDetails);
            applicationDocument.setSupportDocs(this.addToFileStore(files));
            applicationDocument.setDocumentNumber("111");
            applicationDocument.setDocumentDate(new Date());
            waterConnectionDetails.getApplicationDocs().add(applicationDocument);
        }
        if (request.getParameter("approvalPosition") != null && !request.getParameter("approvalPosition").isEmpty()) {
            approvalPosition = Long.valueOf(request.getParameter("approvalPosition"));
        }
        String addrule = request.getParameter("additionalRule");
        WaterConnectionDetails savedWaterConnectionDetails = this.reconnectionService.updateReConnection(waterConnectionDetails, approvalPosition, approvalComent, addrule, workFlowAction, sourceChannel);
        model.addAttribute("waterConnectionDetails", (Object)savedWaterConnectionDetails);
        Assignment currentUserAssignment = this.assignmentService.getPrimaryAssignmentForGivenRange(this.securityUtils.getCurrentUser().getId(), new Date(), new Date());
        String nextDesign = "";
        Assignment assignObj = null;
        List<Object> asignList = null;
        if (approvalPosition != null) {
            assignObj = this.assignmentService.getPrimaryAssignmentForPositon(approvalPosition);
        }
        if (assignObj != null) {
            asignList = new ArrayList<Assignment>();
            asignList.add(assignObj);
        } else if (assignObj == null && approvalPosition != null) {
            asignList = this.assignmentService.getAssignmentsForPosition(approvalPosition, new Date());
        }
        nextDesign = !asignList.isEmpty() ? ((Assignment)asignList.get(0)).getDesignation().getName() : "";
        String pathVars = waterConnectionDetails.getApplicationNumber() + "," + this.waterTaxUtils.getApproverName(approvalPosition) + "," + (currentUserAssignment != null ? currentUserAssignment.getDesignation().getName() : "") + "," + (nextDesign != null ? nextDesign : "");
        return "redirect:/application/application-success?pathVars=" + pathVars;
    }
}

