/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.search;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.entity.City;
import org.egov.infra.admin.master.entity.Role;
import org.egov.infra.admin.master.entity.User;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.admin.master.service.CityService;
import org.egov.infra.admin.master.service.UserService;
import org.egov.infra.config.core.ApplicationThreadLocals;
import org.egov.infra.security.utils.SecurityUtils;
import org.egov.wtms.entity.es.ConnectionSearchRequest;
import org.egov.wtms.entity.es.WaterChargeDocument;
import org.egov.wtms.repository.es.WaterChargeDocumentRepository;
import org.egov.wtms.utils.WaterTaxUtils;
import org.elasticsearch.index.query.BoolQueryBuilder;
import org.elasticsearch.index.query.QueryBuilder;
import org.elasticsearch.index.query.QueryBuilders;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.elasticsearch.core.query.NativeSearchQuery;
import org.springframework.data.elasticsearch.core.query.NativeSearchQueryBuilder;
import org.springframework.data.elasticsearch.core.query.SearchQuery;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/search/waterSearch/"})
public class WaterTaxSearchController {
    private final CityService cityService;
    @Autowired
    private WaterTaxUtils waterTaxUtils;
    @Autowired
    private SecurityUtils securityUtils;
    @Autowired
    private UserService userService;
    @Autowired
    private BoundaryService boundaryService;
    @Autowired
    private WaterChargeDocumentRepository waterChargeDocumentRepository;

    @Autowired
    public WaterTaxSearchController(CityService cityService) {
        this.cityService = cityService;
    }

    @ModelAttribute
    public ConnectionSearchRequest searchRequest() {
        return new ConnectionSearchRequest();
    }

    @ModelAttribute(value="cscUserRole")
    public String getCurrentUserRole() {
        String cscUserRole = "";
        User currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("CSC Operator")) continue;
            cscUserRole = userrole.getName();
            break;
        }
        return cscUserRole;
    }

    @ModelAttribute(value="citizenRole")
    public Boolean getCitizenUserRole() {
        Boolean citizenrole = Boolean.FALSE;
        if (ApplicationThreadLocals.getUserId() != null) {
            User currentUser = this.userService.getUserById(ApplicationThreadLocals.getUserId());
            for (Role userrole : currentUser.getRoles()) {
                if (!userrole.getName().equals("CITIZEN")) continue;
                citizenrole = Boolean.TRUE;
                break;
            }
        } else {
            citizenrole = Boolean.TRUE;
        }
        return citizenrole;
    }

    @ModelAttribute(value="ulbUserRole")
    public String getUlbOperatorUserRole() {
        String userRole = "";
        User currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("ULB Operator")) continue;
            userRole = userrole.getName();
            break;
        }
        return userRole;
    }

    @ModelAttribute(value="superUserRole")
    public String getSuperUserRole() {
        String userRole = "";
        User currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("SYSTEM")) continue;
            userRole = userrole.getName();
            break;
        }
        return userRole;
    }

    @ModelAttribute(value="administratorRole")
    public String getAdminstratorRole() {
        String userRole = "";
        User currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("Property Administrator")) continue;
            userRole = userrole.getName();
            break;
        }
        return userRole;
    }

    @ModelAttribute(value="approverUserRole")
    public String getApproverUserRole() {
        String userRole = "";
        this.waterTaxUtils.getUserRolesForLoggedInUser();
        User currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("Water Tax Approver")) continue;
            userRole = userrole.getName();
            break;
        }
        return userRole;
    }

    @ModelAttribute(value="operatorRole")
    public String getOperatorUserRole() {
        String userRole = "";
        User currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("Operator")) continue;
            userRole = userrole.getName();
            break;
        }
        return userRole;
    }

    @ModelAttribute(value="billcollectionRole")
    public String getBillOperatorUserRole() {
        String userRole = "";
        User currentUser = ApplicationThreadLocals.getUserId() != null ? this.userService.getUserById(ApplicationThreadLocals.getUserId()) : this.securityUtils.getCurrentUser();
        for (Role userrole : currentUser.getRoles()) {
            if (!userrole.getName().equals("Collection Operator")) continue;
            userRole = userrole.getName();
            break;
        }
        return userRole;
    }

    @ModelAttribute(value="revenueWards")
    public List<Boundary> revenueWardList() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("WARD", "REVENUE");
    }

    @RequestMapping(method={RequestMethod.GET})
    public String newSearchForm(Model model) {
        return "waterTaxSearch-newForm";
    }

    @RequestMapping(method={RequestMethod.POST})
    @ResponseBody
    public List<ConnectionSearchRequest> searchConnection(@ModelAttribute ConnectionSearchRequest searchRequest) {
        ArrayList<ConnectionSearchRequest> finalResult = new ArrayList<ConnectionSearchRequest>();
        List temList = this.findAllWaterChargeIndexByFilter(searchRequest);
        for (WaterChargeDocument waterChargeIndex : temList) {
            ConnectionSearchRequest customerObj = new ConnectionSearchRequest();
            customerObj.setApplicantName(waterChargeIndex.getConsumerName());
            customerObj.setConsumerCode(waterChargeIndex.getConsumerCode());
            customerObj.setOldConsumerNumber(waterChargeIndex.getOldConsumerCode());
            customerObj.setPropertyid(waterChargeIndex.getPropertyId());
            customerObj.setAddress(waterChargeIndex.getLocality());
            customerObj.setApplicationcode(waterChargeIndex.getApplicationCode());
            customerObj.setUsage(waterChargeIndex.getUsage());
            customerObj.setIslegacy(waterChargeIndex.getLegacy().booleanValue());
            customerObj.setPropertyTaxDue(waterChargeIndex.getTotalDue());
            customerObj.setStatus(waterChargeIndex.getStatus());
            customerObj.setConnectiontype(waterChargeIndex.getConnectionType());
            customerObj.setWaterTaxDue(waterChargeIndex.getWaterTaxDue());
            finalResult.add(customerObj);
        }
        return finalResult;
    }

    private BoolQueryBuilder getFilterQuery(ConnectionSearchRequest searchRequest) {
        City cityWebsite = this.cityService.getCityByCode(ApplicationThreadLocals.getCityCode());
        BoolQueryBuilder boolQuery = QueryBuilders.boolQuery().filter((QueryBuilder)QueryBuilders.termQuery((String)"cityName", (String)cityWebsite.getName()));
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getApplicantName())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"consumerName", (Object)searchRequest.getApplicantName()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getConsumerCode())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"consumerCode", (Object)searchRequest.getConsumerCode()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getOldConsumerNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"oldConsumerCode", (Object)searchRequest.getOldConsumerNumber()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getPropertyid())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"propertyId", (Object)searchRequest.getPropertyid()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getRevenueWard())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"revenueWard", (Object)searchRequest.getRevenueWard()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getMobileNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"mobileNumber", (Object)searchRequest.getMobileNumber()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getDoorNumber())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"doorNo", (Object)searchRequest.getDoorNumber()));
        }
        if (StringUtils.isNotBlank((CharSequence)searchRequest.getLocality())) {
            boolQuery = boolQuery.filter((QueryBuilder)QueryBuilders.matchQuery((String)"locality", (Object)searchRequest.getLocality()));
        }
        return boolQuery;
    }

    public List<WaterChargeDocument> findAllWaterChargeIndexByFilter(ConnectionSearchRequest searchRequest) {
        BoolQueryBuilder query = this.getFilterQuery(searchRequest);
        NativeSearchQuery searchQuery = new NativeSearchQueryBuilder().withIndices(new String[]{"waterchargeconsumer"}).withQuery((QueryBuilder)query).withPageable((Pageable)new PageRequest(0, 250)).build();
        Page sampleEntities = this.waterChargeDocumentRepository.search((SearchQuery)searchQuery);
        ArrayList<WaterChargeDocument> sampleEntitiesTemp = new ArrayList<WaterChargeDocument>();
        for (WaterChargeDocument document : sampleEntities) {
            sampleEntitiesTemp.add(document);
        }
        return sampleEntitiesTemp;
    }
}

