/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.utils.JsonUtils;
import org.egov.wtms.masters.service.BoundaryWiseReportService;
import org.egov.wtms.reports.entity.WaterConnectionHelperAdaptor;
import org.egov.wtms.reports.entity.WaterConnectionReportResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class NumberOfConnectionReportController {
    @Autowired
    private final BoundaryWiseReportService boundaryWiseReportService;
    @Autowired
    private BoundaryService boundaryService;

    @Autowired
    public NumberOfConnectionReportController(BoundaryWiseReportService drillDownReportService) {
        this.boundaryWiseReportService = drillDownReportService;
    }

    @ModelAttribute(value="wards")
    public List<Boundary> wards() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @ModelAttribute
    public void getReportHelper(Model model) {
        WaterConnectionReportResult reportHealperObj = new WaterConnectionReportResult();
        model.addAttribute("reportHelper", (Object)reportHealperObj);
    }

    @ModelAttribute(value="localitys")
    public List<Boundary> localitys() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION");
    }

    @RequestMapping(method={RequestMethod.GET}, value={"/coonectionReport/wardWise"})
    public String searchNoOfConnectionByBoundaryForm(Model model) {
        model.addAttribute("currDate", (Object)new Date());
        return "connectionReport-search";
    }

    @ExceptionHandler(value={Exception.class})
    @RequestMapping(value={"/connectionReportList"}, method={RequestMethod.GET})
    @ResponseBody
    public void springPaginationDataTablesUpdate(@RequestParam String ward, @RequestParam String block, HttpServletRequest request, HttpServletResponse response) throws IOException {
        List drillDownresult = this.boundaryWiseReportService.getDrillDownReportResult(ward, block);
        String result = "{ \"data\":" + JsonUtils.toJSON((Collection)drillDownresult, WaterConnectionReportResult.class, WaterConnectionHelperAdaptor.class) + "}";
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }
}

