/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import com.lowagie.text.Document;
import com.lowagie.text.pdf.PdfContentByte;
import com.lowagie.text.pdf.PdfImportedPage;
import com.lowagie.text.pdf.PdfReader;
import com.lowagie.text.pdf.PdfTemplate;
import com.lowagie.text.pdf.PdfWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.validation.ValidationException;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Logger;
import org.egov.demand.model.EgBill;
import org.egov.infra.exception.ApplicationRuntimeException;
import org.egov.infra.filestore.entity.FileStoreMapper;
import org.egov.infra.filestore.repository.FileStoreMapperRepository;
import org.egov.infra.filestore.service.FileStoreService;
import org.egov.infstr.services.PersistenceService;
import org.egov.wtms.application.service.GenerateConnectionBillService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.service.bill.WaterConnectionBillService;
import org.hibernate.Query;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;

@Controller
@RequestMapping(value={"/report"})
public class GenerateBillForConsumerCodeController {
    @Autowired
    @Qualifier(value="persistenceService")
    private PersistenceService persistenceService;
    @Autowired
    private WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private ApplicationContext beanProvider;
    @Autowired
    private GenerateConnectionBillService generateConnectionBillService;
    @Autowired
    private FileStoreMapperRepository fileStoreMapperRepository;
    @Autowired
    private FileStoreService fileStoreService;
    private static final Logger LOGGER = Logger.getLogger(GenerateBillForConsumerCodeController.class);

    @RequestMapping(value={"/generateBillForHSCNo/{consumerCode}"}, method={RequestMethod.GET})
    public String newForm(Model model, @PathVariable String consumerCode, HttpServletRequest request, HttpServletResponse response) {
        WaterConnectionBillService waterConnectionBillService = null;
        try {
            EgBill egBill = this.getBillByConsumerCode(consumerCode);
            if (egBill != null) {
                throw new ValidationException("err.demand.bill.generated");
            }
            waterConnectionBillService = (WaterConnectionBillService)this.beanProvider.getBean("waterConnectionBillService");
        }
        catch (NoSuchBeanDefinitionException egBill) {
            // empty catch block
        }
        if (waterConnectionBillService != null) {
            waterConnectionBillService.generateBillForConsumercode(consumerCode);
        }
        List waterChargesDocumentslist = this.generateConnectionBillService.getDocuments(consumerCode, this.waterConnectionDetailsService.findByApplicationNumberOrConsumerCode(consumerCode).getApplicationType().getName());
        model.addAttribute("successMessage", (Object)"Demand Bill got generated, Please click on download.");
        model.addAttribute("fileStoreId", !waterChargesDocumentslist.isEmpty() ? waterChargesDocumentslist.get(0) : "");
        return "generatebill-consumercode";
    }

    @RequestMapping(value={"/generateBillForHSCNo/downloadDemandBill"})
    public void generatePDF(String consumerCode, HttpServletRequest request, HttpServletResponse response) {
        String signedFileStoreId = request.getParameter("signedFileStoreId");
        if (signedFileStoreId != null) {
            try {
                FileStoreMapper fsm = this.fileStoreMapperRepository.findByFileStoreId(signedFileStoreId);
                ArrayList<ByteArrayInputStream> pdfs = new ArrayList<ByteArrayInputStream>();
                File file = this.fileStoreService.fetch(fsm, "WTMS");
                byte[] bFile = FileUtils.readFileToByteArray((File)file);
                pdfs.add(new ByteArrayInputStream(bFile));
                this.getServletResponse(response, pdfs, consumerCode);
            }
            catch (FileNotFoundException fileNotFoundExcep) {
                throw new ApplicationRuntimeException("Exception while loading file : " + fileNotFoundExcep);
            }
            catch (IOException ioExcep) {
                throw new ApplicationRuntimeException("Exception while generating bill : " + ioExcep);
            }
        } else {
            throw new ValidationException("err.demand.notice");
        }
    }

    private HttpServletResponse getServletResponse(HttpServletResponse response, List<InputStream> pdfs, String filename) {
        try {
            ByteArrayOutputStream output = new ByteArrayOutputStream();
            byte[] data = this.concatPDFs(pdfs, output);
            response.setHeader("Content-disposition", "attachment;filename=" + filename + ".pdf");
            response.setContentType("application/pdf");
            response.setContentLength(data.length);
            response.getOutputStream().write(data);
            return response;
        }
        catch (IOException e) {
            throw new ValidationException(e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] concatPDFs(List<InputStream> streamOfPDFFiles, ByteArrayOutputStream outputStream) {
        Document document = null;
        try {
            List<InputStream> pdfs = streamOfPDFFiles;
            ArrayList<PdfReader> readers = new ArrayList<PdfReader>();
            for (InputStream pdf : pdfs) {
                PdfReader pdfReader = new PdfReader(pdf);
                readers.add(pdfReader);
                if (null != document) continue;
                document = new Document(pdfReader.getPageSize(1));
            }
            PdfWriter writer = PdfWriter.getInstance(document, (OutputStream)outputStream);
            document.open();
            PdfContentByte cb = writer.getDirectContent();
            int pageOfCurrentReaderPDF = 0;
            for (PdfReader pdfReader : readers) {
                while (pageOfCurrentReaderPDF < pdfReader.getNumberOfPages()) {
                    document.newPage();
                    PdfImportedPage page = writer.getImportedPage(pdfReader, ++pageOfCurrentReaderPDF);
                    cb.addTemplate((PdfTemplate)page, 0.0f, 0.0f);
                }
                pageOfCurrentReaderPDF = 0;
            }
            outputStream.flush();
            document.close();
            outputStream.close();
        }
        catch (Exception e) {
            LOGGER.error((Object)"Exception in concat PDFs : ", (Throwable)e);
        }
        finally {
            if (document.isOpen()) {
                document.close();
            }
            try {
                if (outputStream != null) {
                    outputStream.close();
                }
            }
            catch (IOException ioe) {
                LOGGER.error((Object)"Exception in concat PDFs : ", (Throwable)ioe);
            }
        }
        return outputStream.toByteArray();
    }

    public EgBill getBillByConsumerCode(String consumerCode) {
        EgBill egBill = null;
        String query = "select distinct bill From EgBill bill,EgBillType billtype,WaterConnection conn,WaterConnectionDetails connDet,EgwStatus status,WaterDemandConnection conndem  , EgDemand demd where billtype.id=bill.egBillType and billtype.code='MANUAL' and bill.consumerId = conn.consumerCode and conn.id=connDet.connection and connDet.id=conndem.waterConnectionDetails  and demd.id=bill.egDemand and demd.id=conndem.demand and connDet.connectionType='Non-metered'  and demd.isHistory = 'N' and  bill.is_Cancelled='N' and bill.serviceCode='WT' and connDet.connectionStatus='ACTIVE' and connDet.status=status.id and status.moduletype='WATERTAXAPPLICATION'  and status.code='SANCTIONED' and conn.consumerCode =:consumerCode  order by bill.id desc";
        Query hibquery = this.persistenceService.getSession().createQuery("select distinct bill From EgBill bill,EgBillType billtype,WaterConnection conn,WaterConnectionDetails connDet,EgwStatus status,WaterDemandConnection conndem  , EgDemand demd where billtype.id=bill.egBillType and billtype.code='MANUAL' and bill.consumerId = conn.consumerCode and conn.id=connDet.connection and connDet.id=conndem.waterConnectionDetails  and demd.id=bill.egDemand and demd.id=conndem.demand and connDet.connectionType='Non-metered'  and demd.isHistory = 'N' and  bill.is_Cancelled='N' and bill.serviceCode='WT' and connDet.connectionStatus='ACTIVE' and connDet.status=status.id and status.moduletype='WATERTAXAPPLICATION'  and status.code='SANCTIONED' and conn.consumerCode =:consumerCode  order by bill.id desc".toString()).setString("consumerCode", consumerCode);
        List egBilltemp = hibquery.list();
        if (!egBilltemp.isEmpty()) {
            egBill = (EgBill)egBilltemp.get(0);
        }
        LOGGER.debug((Object)("query to get Bill for single consumernumber" + "select distinct bill From EgBill bill,EgBillType billtype,WaterConnection conn,WaterConnectionDetails connDet,EgwStatus status,WaterDemandConnection conndem  , EgDemand demd where billtype.id=bill.egBillType and billtype.code='MANUAL' and bill.consumerId = conn.consumerCode and conn.id=connDet.connection and connDet.id=conndem.waterConnectionDetails  and demd.id=bill.egDemand and demd.id=conndem.demand and connDet.connectionType='Non-metered'  and demd.isHistory = 'N' and  bill.is_Cancelled='N' and bill.serviceCode='WT' and connDet.connectionStatus='ACTIVE' and connDet.status=status.id and status.moduletype='WATERTAXAPPLICATION'  and status.code='SANCTIONED' and conn.consumerCode =:consumerCode  order by bill.id desc".toString() + " for consumer No= " + consumerCode));
        return egBill;
    }
}

