/*
 * Decompiled with CFR 0.152.
 */
package org.egov.wtms.web.controller.reports;

import java.io.IOException;
import java.io.Writer;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.egov.infra.admin.master.entity.Boundary;
import org.egov.infra.admin.master.service.BoundaryService;
import org.egov.infra.utils.JsonUtils;
import org.egov.wtms.application.service.CurrentDcbService;
import org.egov.wtms.application.service.WaterConnectionDetailsService;
import org.egov.wtms.reports.entity.DCBReportHelperAdaptor;
import org.egov.wtms.reports.entity.DCBReportResult;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/reports"})
public class DCBReportController {
    @PersistenceContext
    EntityManager entityManager;
    @Autowired
    private CurrentDcbService currentDcbService;
    @Autowired(required=true)
    protected WaterConnectionDetailsService waterConnectionDetailsService;
    @Autowired
    private BoundaryService boundaryService;

    @ModelAttribute(value="dCBReportResult")
    public DCBReportResult dCBReportResultModel() {
        return new DCBReportResult();
    }

    @ModelAttribute(value="connectionTypes")
    public Map<String, String> connectionTypes() {
        return this.waterConnectionDetailsService.getConnectionTypesMap();
    }

    @ModelAttribute(value="zones")
    public List<Boundary> zones() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Zone", "REVENUE");
    }

    @ModelAttribute(value="wards")
    public List<Boundary> wards() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Ward", "REVENUE");
    }

    @ModelAttribute(value="blocks")
    public List<Boundary> blocks() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("Block", "REVENUE");
    }

    @ModelAttribute(value="localitys")
    public List<Boundary> localitys() {
        return this.boundaryService.getActiveBoundariesByBndryTypeNameAndHierarchyTypeName("locality", "LOCATION");
    }

    @RequestMapping(value={"/dCBReport/zoneWise"}, method={RequestMethod.GET})
    public String zoneWisesearch(Model model) {
        model.addAttribute("mode", (Object)"zone");
        model.addAttribute("reportType", (Object)"zoneWise");
        return "dCBReport-search";
    }

    @RequestMapping(value={"/dCBReport/wardWise"}, method={RequestMethod.GET})
    public String wardWisesearch(Model model) {
        model.addAttribute("mode", (Object)"ward");
        model.addAttribute("reportType", (Object)"wardWise");
        return "dCBReport-search";
    }

    @RequestMapping(value={"/dCBReport/blockWise"}, method={RequestMethod.GET})
    public String blockWisesearch(Model model) {
        model.addAttribute("mode", (Object)"block");
        model.addAttribute("reportType", (Object)"blockWise");
        return "dCBReport-search";
    }

    @RequestMapping(value={"/dCBReport/localityWise"}, method={RequestMethod.GET})
    public String localityWisesearch(Model model) {
        model.addAttribute("mode", (Object)"locality");
        model.addAttribute("reportType", (Object)"localityWise");
        return "dCBReport-search";
    }

    @RequestMapping(value={"/dCBReportList"}, method={RequestMethod.GET}, produces={"application/json"})
    @ResponseBody
    public void search(HttpServletRequest request, HttpServletResponse response, Model model) throws IOException {
        String connectionType = "";
        String mode = "";
        String reportType = "";
        String[] boundaryId = null;
        StringBuilder zones = new StringBuilder();
        if (request.getParameter("boundaryId[]") != null && !"".equals(request.getParameter("boundaryId[]"))) {
            boundaryId = request.getParameterValues("boundaryId[]");
        } else if (request.getParameter("boundaryId") != null && !"".equals(request.getParameter("boundaryId"))) {
            boundaryId = request.getParameterValues("boundaryId");
        }
        if (boundaryId != null) {
            for (String n : boundaryId) {
                if (zones.length() > 0) {
                    zones.append(',');
                }
                zones.append(n);
            }
        }
        if (request.getParameter("connectionType") != null && !"".equals(request.getParameter("connectionType"))) {
            connectionType = request.getParameter("connectionType");
        }
        if (request.getParameter("mode") != null && !"".equals(request.getParameter("mode"))) {
            mode = request.getParameter("mode");
        }
        if (request.getParameter("reportType") != null && !"".equals(request.getParameter("reportType"))) {
            reportType = request.getParameter("reportType");
        }
        List resultList = this.currentDcbService.getReportResult(zones.toString(), connectionType, mode, reportType);
        String result = "{ \"data\":" + JsonUtils.toJSON((Collection)resultList, DCBReportResult.class, DCBReportHelperAdaptor.class) + "}";
        response.setContentType("application/json");
        IOUtils.write((String)result, (Writer)response.getWriter());
    }
}

